/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.LSMInsertDeleteOperatorNodePushable;
import org.apache.asterix.external.feed.dataflow.FeedRuntimeInputHandler;
import org.apache.asterix.external.feed.dataflow.SyncFeedRuntimeInputHandler;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedMetaOperatorDescriptor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedMetaStoreNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean hasMessage;
    private final AbstractUnaryInputUnaryOutputOperatorNodePushable insertOperator;
    private final FeedPolicyAccessor policyAccessor;
    private final FeedConnectionId connectionId;
    private final int partition;
    private final FeedUtils.FeedRuntimeType runtimeType = FeedUtils.FeedRuntimeType.STORE;
    private final ActiveManager feedManager;
    private FrameTupleAccessor fta;
    private final IHyracksTaskContext ctx;
    private final VSizeFrame message;
    private final IRecordDescriptorProvider recordDescProvider;
    private final FeedMetaOperatorDescriptor opDesc;
    private final ITracer tracer;
    private final long traceCategory;

    FeedMetaStoreNodePushable(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions, IOperatorDescriptor coreOperator, FeedConnectionId feedConnectionId, Map<String, String> feedPolicyProperties, FeedMetaOperatorDescriptor feedMetaOperatorDescriptor, boolean hasMessage) throws HyracksDataException {
        this.hasMessage = hasMessage;
        this.ctx = ctx;
        this.insertOperator = (AbstractUnaryInputUnaryOutputOperatorNodePushable)((IActivity)coreOperator).createPushRuntime(ctx, recordDescProvider, partition, nPartitions);
        this.policyAccessor = new FeedPolicyAccessor(feedPolicyProperties);
        this.partition = partition;
        this.connectionId = feedConnectionId;
        this.feedManager = (ActiveManager)((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getActiveManager();
        if (hasMessage) {
            this.message = new VSizeFrame((IHyracksFrameMgrContext)ctx);
            TaskUtil.put((String)"HYX:MSG", (Object)this.message, (IHyracksTaskContext)ctx);
        } else {
            this.message = null;
        }
        this.recordDescProvider = recordDescProvider;
        this.opDesc = feedMetaOperatorDescriptor;
        this.tracer = ctx.getJobletContext().getServiceContext().getTracer();
        this.traceCategory = this.tracer.getRegistry().get("Storage");
    }

    public void open() throws HyracksDataException {
        ActiveRuntimeId runtimeId = new ActiveRuntimeId(this.connectionId.getFeedId(), this.runtimeType.toString() + "." + this.connectionId.getDatasetName(), this.partition);
        try {
            this.initializeNewFeedRuntime(runtimeId);
            this.insertOperator.open();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failed to open feed store operator", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void initializeNewFeedRuntime(ActiveRuntimeId runtimeId) throws Exception {
        LSMInsertDeleteOperatorNodePushable indexOp;
        this.fta = new FrameTupleAccessor(this.recordDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0));
        this.insertOperator.setOutputFrameWriter(0, this.writer, this.recordDesc);
        if (this.insertOperator instanceof LSMInsertDeleteOperatorNodePushable && !(indexOp = (LSMInsertDeleteOperatorNodePushable)this.insertOperator).isPrimary()) {
            this.writer = this.insertOperator;
            return;
        }
        this.writer = this.policyAccessor.flowControlEnabled() ? new FeedRuntimeInputHandler(this.ctx, this.connectionId, runtimeId, (IFrameWriter)this.insertOperator, this.policyAccessor, this.fta, this.feedManager.getFramePool()) : new SyncFeedRuntimeInputHandler(this.ctx, (IFrameWriter)this.insertOperator, this.fta);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        long tid = this.tracer.durationB("Ingestion-Store", this.traceCategory, null);
        try {
            if (this.hasMessage) {
                FeedUtils.processFeedMessage(buffer, this.message, this.fta);
            }
            this.writer.nextFrame(buffer);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure Processing a frame at store side", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.tracer.durationE(tid, this.traceCategory, null);
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void close() throws HyracksDataException {
        this.writer.close();
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

