/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class APolygon
implements IAObject {
    protected APoint[] points;

    public APolygon(APoint[] points) {
        this.points = points;
    }

    public int getNumberOfPoints() {
        return this.points.length;
    }

    public APoint[] getPoints() {
        return this.points;
    }

    @Override
    public IAType getType() {
        return BuiltinType.APOLYGON;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof APolygon)) {
            return false;
        }
        APolygon p = (APolygon)obj;
        if (p.getPoints().length != this.points.length) {
            return false;
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].deepEqual(p.getPoints()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hash() {
        int h = 0;
        for (int i = 0; i < this.points.length; ++i) {
            h += 31 * h + this.points[i].hash();
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("polygon: [ ");
        for (int i = 0; i < this.points.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.points[i].toString());
        }
        sb.append(" ]");
        return sb.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ArrayNode polygon = om.createArrayNode();
        for (int i = 0; i < this.points.length; ++i) {
            polygon.add((JsonNode)this.points[i].toJSON());
        }
        json.set("APolygon", (JsonNode)polygon);
        return json;
    }
}

