/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.util.Arrays;
import java.util.List;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IntervalColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class IntervalPartitions {
    private final RangeMap rangeMap;
    private final List<IntervalColumn> leftIntervalColumn;
    private final List<IntervalColumn> rightIntervalColumn;
    private final IPartitioningProperty.PartitioningType leftPartitioningType;
    private final IPartitioningProperty.PartitioningType rightPartitioningType;

    IntervalPartitions(RangeMap rangeMap, List<IntervalColumn> leftIntervalColumn, List<IntervalColumn> rightIntervalColumn, IPartitioningProperty.PartitioningType leftPartitioningType, IPartitioningProperty.PartitioningType rightPartitioningType) {
        this.rangeMap = rangeMap;
        this.leftIntervalColumn = leftIntervalColumn;
        this.rightIntervalColumn = rightIntervalColumn;
        this.leftPartitioningType = leftPartitioningType;
        this.rightPartitioningType = rightPartitioningType;
    }

    public RangeMap getRangeMap() {
        return this.rangeMap;
    }

    public IPartitioningProperty.PartitioningType getLeftPartitioningType() {
        return this.leftPartitioningType;
    }

    public IPartitioningProperty.PartitioningType getRightPartitioningType() {
        return this.rightPartitioningType;
    }

    public List<IntervalColumn> getLeftIntervalColumn() {
        return this.leftIntervalColumn;
    }

    public List<IntervalColumn> getRightIntervalColumn() {
        return this.rightIntervalColumn;
    }

    public List<OrderColumn> getLeftStartColumn() {
        LogicalVariable leftStartLogicalVariable = this.leftIntervalColumn.get(0).getStartColumn();
        List<OrderColumn> leftOrderColumn = Arrays.asList(new OrderColumn(leftStartLogicalVariable, this.leftIntervalColumn.get(0).getOrder()));
        return leftOrderColumn;
    }

    public List<OrderColumn> getRightStartColumn() {
        LogicalVariable rightStartLogicalVariable = this.rightIntervalColumn.get(0).getStartColumn();
        List<OrderColumn> rightOrderColumn = Arrays.asList(new OrderColumn(rightStartLogicalVariable, this.rightIntervalColumn.get(0).getOrder()));
        return rightOrderColumn;
    }
}

