/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entitytupletranslators.AbstractDatatypeTupleTranslator;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatatypeTupleTranslator
extends AbstractDatatypeTupleTranslator<Datatype> {
    private static final int DATATYPE_PAYLOAD_TUPLE_FIELD_INDEX = 2;

    protected DatatypeTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple) {
        super(txnId, metadataNode, getTuple, MetadataPrimaryIndexes.DATATYPE_DATASET, 2);
    }

    @Override
    protected Datatype createMetadataEntityFromARecord(ARecord datatypeRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)datatypeRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String datatypeName = ((AString)datatypeRecord.getValueByPos(1)).getStringValue();
        BuiltinType type = BuiltinTypeMap.getBuiltinType(datatypeName);
        if (type == null) {
            ARecord derivedTypeRecord = (ARecord)datatypeRecord.getValueByPos(2);
            AbstractDatatypeTupleTranslator.DerivedTypeTag tag = AbstractDatatypeTupleTranslator.DerivedTypeTag.valueOf(((AString)derivedTypeRecord.getValueByPos(0)).getStringValue());
            boolean isAnonymous = ((ABoolean)derivedTypeRecord.getValueByPos(1)).getBoolean();
            switch (tag) {
                case RECORD: {
                    ARecord recordType = (ARecord)derivedTypeRecord.getValueByPos(2);
                    boolean isOpen = ((ABoolean)recordType.getValueByPos(0)).getBoolean();
                    int numberOfFields = ((AOrderedList)recordType.getValueByPos(1)).size();
                    IACursor cursor = ((AOrderedList)recordType.getValueByPos(1)).getCursor();
                    String[] fieldNames = new String[numberOfFields];
                    IAType[] fieldTypes = new IAType[numberOfFields];
                    int fieldId = 0;
                    while (cursor.next()) {
                        ARecord field = (ARecord)cursor.get();
                        fieldNames[fieldId] = ((AString)field.getValueByPos(0)).getStringValue();
                        String fieldTypeName = ((AString)field.getValueByPos(1)).getStringValue();
                        boolean isNullable = ((ABoolean)field.getValueByPos(2)).getBoolean();
                        int isMissableIdx = field.getType().getFieldIndex("IsMissable");
                        boolean isMissable = isMissableIdx >= 0 ? ((ABoolean)field.getValueByPos(isMissableIdx)).getBoolean() : isNullable;
                        IAType fieldType = BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dataverseName, fieldTypeName);
                        fieldTypes[fieldId] = TypeUtil.createQuantifiedType(fieldType, isNullable, isMissable);
                        ++fieldId;
                    }
                    return new Datatype(dataverseName, datatypeName, (IAType)new ARecordType(datatypeName, fieldNames, fieldTypes, isOpen), isAnonymous);
                }
                case UNORDEREDLIST: {
                    String unorderedlistTypeName = ((AString)derivedTypeRecord.getValueByPos(3)).getStringValue();
                    return new Datatype(dataverseName, datatypeName, (IAType)new AUnorderedListType(BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dataverseName, unorderedlistTypeName), datatypeName), isAnonymous);
                }
                case ORDEREDLIST: {
                    String orderedlistTypeName = ((AString)derivedTypeRecord.getValueByPos(4)).getStringValue();
                    return new Datatype(dataverseName, datatypeName, (IAType)new AOrderedListType(BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dataverseName, orderedlistTypeName), datatypeName), isAnonymous);
                }
            }
            throw new UnsupportedOperationException("Unsupported derived type: " + tag);
        }
        return new Datatype(dataverseName, datatypeName, (IAType)type, false);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Datatype dataType) throws HyracksDataException {
        String dataverseCanonicalName = dataType.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(dataType.getDatatypeName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.DATATYPE_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataType.getDatatypeName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        IAType fieldType = dataType.getDatatype();
        if (fieldType.getTypeTag().isDerivedType()) {
            this.fieldValue.reset();
            this.writeDerivedTypeRecord(dataType.getDataverseName(), (AbstractComplexType)fieldType, this.fieldValue.getDataOutput(), dataType.getIsAnonymous());
            this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

