/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.util;

import java.util.BitSet;

public class SelectionTree {
    private int size;
    private Entry[] entries;
    private int[] losers;
    private BitSet available;

    public SelectionTree(Entry[] e) {
        int i;
        this.size = e.length + 1 & 0xFFFFFFFE;
        this.available = new BitSet(this.size);
        this.available.set(0, e.length, true);
        this.losers = new int[this.size];
        this.entries = e;
        for (i = 0; i < this.size; ++i) {
            this.losers[i] = -1;
        }
        for (i = 0; i < this.size; ++i) {
            int slot = this.size + i >> 1;
            if (i < this.entries.length) {
                this.available.set(i, this.entries[i].advance());
            }
            int currIdx = i;
            while (slot > 0) {
                int cmp = 0;
                if (this.losers[slot] < 0 || currIdx < 0) {
                    cmp = this.losers[slot] < 0 ? -1 : 1;
                } else if (!this.available.get(this.losers[slot])) {
                    cmp = 1;
                } else if (this.available.get(currIdx)) {
                    cmp = currIdx <= i ? this.entries[this.losers[slot]].compareTo(this.entries[currIdx]) : 1;
                }
                if (cmp <= 0) {
                    int tmp = this.losers[slot];
                    this.losers[slot] = currIdx;
                    currIdx = tmp;
                }
                slot >>= 1;
            }
            this.losers[0] = currIdx;
        }
    }

    public Entry peek() {
        if (this.entries.length == 0) {
            return null;
        }
        return this.entries[this.losers[0]];
    }

    public void pop() {
        int winner = this.losers[0];
        int slot = this.size + winner >> 1;
        boolean avail = this.entries[winner].advance();
        if (!avail) {
            this.entries[winner] = null;
        }
        this.available.set(winner, avail);
        int currIdx = winner;
        while (!this.available.isEmpty() && slot > 0) {
            int cmp = 0;
            if (!this.available.get(this.losers[slot])) {
                cmp = 1;
            } else if (this.available.get(currIdx)) {
                cmp = this.entries[this.losers[slot]].compareTo(this.entries[currIdx]);
            }
            if (cmp <= 0) {
                int tmp = this.losers[slot];
                this.losers[slot] = currIdx;
                currIdx = tmp;
            }
            slot >>= 1;
        }
        this.losers[0] = currIdx;
    }

    public static interface Entry
    extends Comparable<Entry> {
        public boolean advance();
    }
}

