/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.replication.api.ReplicationDestination;
import org.apache.asterix.replication.logging.ReplicationLogBuffer;
import org.apache.asterix.replication.logging.TxnAckTracker;
import org.apache.asterix.replication.logging.TxnLogReplicator;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.ReplicateLogsTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogReplicationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LinkedBlockingQueue<ReplicationLogBuffer> emptyLogBuffersQ;
    private final LinkedBlockingQueue<ReplicationLogBuffer> pendingFlushLogBuffersQ;
    private final ByteBuffer txnLogsBatchSizeBuffer = ByteBuffer.allocate(4);
    private final Map<ReplicationDestination, ISocketChannel> destinations = new HashMap<ReplicationDestination, ISocketChannel>();
    private final IReplicationManager replicationManager;
    private final Executor executor;
    private final TxnAckTracker ackTracker = new TxnAckTracker();
    private final Set<ISocketChannel> failedSockets = new HashSet<ISocketChannel>();
    private final Object transferLock = new Object();
    private final INcApplicationContext appCtx;
    private final int logPageSize;
    private final int logBatchSize;
    private ReplicationLogBuffer currentTxnLogBuffer;
    private ISocketChannel[] destSockets;

    public LogReplicationManager(INcApplicationContext appCtx, IReplicationManager replicationManager) {
        this.appCtx = appCtx;
        this.replicationManager = replicationManager;
        ReplicationProperties replicationProperties = appCtx.getReplicationProperties();
        this.logPageSize = replicationProperties.getLogBufferPageSize();
        this.logBatchSize = replicationProperties.getLogBatchSize();
        this.executor = appCtx.getThreadExecutor();
        this.emptyLogBuffersQ = new LinkedBlockingQueue();
        this.pendingFlushLogBuffersQ = new LinkedBlockingQueue();
        this.initBuffers(replicationProperties.getLogBufferNumOfPages());
        TxnLogReplicator txnlogReplicator = new TxnLogReplicator(this.emptyLogBuffersQ, this.pendingFlushLogBuffersQ);
        ((ExecutorService)this.executor).submit(txnlogReplicator);
    }

    private void initBuffers(int buffers) {
        for (int i = 0; i < buffers; ++i) {
            this.emptyLogBuffersQ.add(new ReplicationLogBuffer(this, this.logPageSize, this.logBatchSize));
        }
        try {
            this.getAndInitNewPage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ReplicationDestination dest) {
        Object object = this.transferLock;
        synchronized (object) {
            Map<ReplicationDestination, ISocketChannel> map = this.destinations;
            synchronized (map) {
                if (this.destinations.containsKey(dest)) {
                    return;
                }
                LOGGER.info(() -> "register " + dest);
                ISocketChannel socketChannel = dest.getLogReplicationChannel(this.appCtx);
                this.handshake(dest, socketChannel);
                this.destinations.put(dest, socketChannel);
                this.failedSockets.remove(socketChannel);
                this.destSockets = this.destinations.values().toArray(new ISocketChannel[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IReplicationDestination dest) {
        Object object = this.transferLock;
        synchronized (object) {
            Map<ReplicationDestination, ISocketChannel> map = this.destinations;
            synchronized (map) {
                if (!this.destinations.containsKey(dest)) {
                    return;
                }
                LOGGER.info(() -> "unregister " + dest);
                this.ackTracker.unregister(dest);
                ISocketChannel destSocket = this.destinations.remove(dest);
                this.failedSockets.remove(destSocket);
                this.destSockets = this.destinations.values().toArray(new ISocketChannel[0]);
                this.endReplication(destSocket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(ILogRecord logRecord) throws InterruptedException {
        if (logRecord.getLogType() == 1 || logRecord.getLogType() == 3) {
            Map<ReplicationDestination, ISocketChannel> map = this.destinations;
            synchronized (map) {
                this.ackTracker.track(logRecord, new HashSet<IReplicationDestination>(this.destinations.keySet()));
            }
        }
        this.appendToLogBuffer(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferBatch(ByteBuffer buffer) {
        this.txnLogsBatchSizeBuffer.clear();
        this.txnLogsBatchSizeBuffer.putInt(buffer.remaining());
        this.txnLogsBatchSizeBuffer.flip();
        buffer.mark();
        Object object = this.transferLock;
        synchronized (object) {
            if (this.destSockets != null) {
                for (ISocketChannel replicaSocket : this.destSockets) {
                    try {
                        NetworkingUtil.transferBufferToChannel(replicaSocket, this.txnLogsBatchSizeBuffer);
                        NetworkingUtil.transferBufferToChannel(replicaSocket, buffer);
                    }
                    catch (IOException e) {
                        this.handleFailure(replicaSocket, e);
                    }
                    finally {
                        this.txnLogsBatchSizeBuffer.position(0);
                        buffer.reset();
                    }
                }
            }
        }
        buffer.position(buffer.limit());
    }

    public int getLogPageSize() {
        return this.logPageSize;
    }

    private synchronized void appendToLogBuffer(ILogRecord logRecord) throws InterruptedException {
        if (!this.currentTxnLogBuffer.hasSpace(logRecord)) {
            this.currentTxnLogBuffer.setFull(true);
            if (logRecord.getLogSize() > this.logPageSize) {
                this.getAndInitNewLargePage(logRecord.getLogSize());
            } else {
                this.getAndInitNewPage();
            }
        }
        this.currentTxnLogBuffer.append(logRecord);
    }

    private void getAndInitNewPage() throws InterruptedException {
        this.currentTxnLogBuffer = null;
        while (this.currentTxnLogBuffer == null) {
            this.currentTxnLogBuffer = this.emptyLogBuffersQ.take();
        }
        this.currentTxnLogBuffer.reset();
        this.pendingFlushLogBuffersQ.add(this.currentTxnLogBuffer);
    }

    private void getAndInitNewLargePage(int pageSize) {
        this.currentTxnLogBuffer = new ReplicationLogBuffer(this, pageSize, this.logBatchSize);
        this.pendingFlushLogBuffersQ.add(this.currentTxnLogBuffer);
    }

    private void handshake(ReplicationDestination dest, ISocketChannel socketChannel) {
        String nodeId = this.appCtx.getServiceContext().getNodeId();
        ReplicateLogsTask task = new ReplicateLogsTask(nodeId);
        ReplicationProtocol.sendTo(socketChannel, task, null);
        this.executor.execute(new TxnAckListener(dest, socketChannel));
    }

    private void endReplication(ISocketChannel socketChannel) {
        if (socketChannel.getSocketChannel().isConnected()) {
            ByteBuffer endLogRepBuffer = ReplicationProtocol.getEndLogReplicationBuffer();
            try {
                NetworkingUtil.transferBufferToChannel(socketChannel, endLogRepBuffer);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to end txn log", (Throwable)e);
            }
        }
    }

    private synchronized void handleFailure(ISocketChannel replicaSocket, Exception e) {
        if (this.failedSockets.contains(replicaSocket)) {
            return;
        }
        LOGGER.error("Replica failed", (Throwable)e);
        this.failedSockets.add(replicaSocket);
        Optional<ReplicationDestination> socketDest = this.destinations.entrySet().stream().filter(entry -> ((ISocketChannel)entry.getValue()).equals(replicaSocket)).map(Map.Entry::getKey).findFirst();
        socketDest.ifPresent(dest -> this.replicationManager.notifyFailure((IReplicationDestination)dest, e));
    }

    private class TxnAckListener
    implements Runnable {
        private final ReplicationDestination dest;
        private final ISocketChannel replicaSocket;

        TxnAckListener(ReplicationDestination dest, ISocketChannel replicaSocket) {
            this.dest = dest;
            this.replicaSocket = replicaSocket;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("TxnAckListener (" + this.dest + ")");
            LOGGER.info("Started listening on socket: {}", (Object)this.dest);
            try (BufferedReader incomingResponse = new BufferedReader(new InputStreamReader(this.replicaSocket.getSocketChannel().socket().getInputStream()));){
                while (true) {
                    String response;
                    if ((response = incomingResponse.readLine()) == null) {
                        LogReplicationManager.this.handleFailure(this.replicaSocket, new IOException("Unexpected response from replica " + this.dest));
                        break;
                    }
                    int txnId = ReplicationProtocol.getTxnIdFromLogAckMessage(response);
                    LogReplicationManager.this.ackTracker.ack(txnId, this.dest);
                }
            }
            catch (AsynchronousCloseException e) {
                LOGGER.debug(() -> "Stopped listening on socket:" + this.dest, (Throwable)e);
            }
            catch (Exception e) {
                LogReplicationManager.this.handleFailure(this.replicaSocket, e);
            }
        }
    }
}

