/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.replication.api.IReplicationMessage;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PartitionResourcesListResponse
implements IReplicationMessage {
    private final int partition;
    private final List<String> resources;

    public PartitionResourcesListResponse(int partition, List<String> resources) {
        this.partition = partition;
        this.resources = resources;
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.PARTITION_RESOURCES_RESPONSE;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeInt(this.partition);
            dos.writeInt(this.resources.size());
            for (String file : this.resources) {
                dos.writeUTF(file);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public List<String> getResources() {
        return this.resources;
    }

    public static PartitionResourcesListResponse create(DataInput input) throws IOException {
        int partition = input.readInt();
        int size = input.readInt();
        ArrayList<String> resources = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            resources.add(input.readUTF());
        }
        return new PartitionResourcesListResponse(partition, resources);
    }
}

