/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds;

import com.teradata.tpcds.ScalingInfo;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.TpcdsException;
import com.teradata.tpcds.distribution.CalendarDistribution;
import com.teradata.tpcds.type.Date;
import java.util.EnumMap;
import java.util.Map;

public class Scaling {
    private final double scale;
    private final Map<Table, Long> tableToRowCountMap = new EnumMap<Table, Long>(Table.class);

    public Scaling(double scale) {
        this.scale = scale;
        for (Table table : Table.values()) {
            ScalingInfo scalingInfo = table.getScalingInfo();
            long baseRowCount = scalingInfo.getRowCountForScale(scale);
            int multiplier = table.keepsHistory() ? 2 : 1;
            for (int i = 1; i <= scalingInfo.getMultiplier(); ++i) {
                multiplier *= 10;
            }
            this.tableToRowCountMap.put(table, baseRowCount * (long)multiplier);
        }
    }

    public long getRowCount(Table table) {
        if (table == Table.INVENTORY) {
            return this.scaleInventory();
        }
        if (table == Table.S_INVENTORY) {
            return this.getIdCount(Table.ITEM) * this.getRowCount(Table.WAREHOUSE) * 6L;
        }
        return this.tableToRowCountMap.get((Object)table);
    }

    public long getIdCount(Table table) {
        long rowCount = this.getRowCount(table);
        if (table.keepsHistory()) {
            long uniqueCount = rowCount / 6L * 3L;
            switch ((int)(rowCount % 6L)) {
                case 1: {
                    ++uniqueCount;
                    break;
                }
                case 2: 
                case 3: {
                    uniqueCount += 2L;
                    break;
                }
                case 4: 
                case 5: {
                    uniqueCount += 3L;
                    break;
                }
            }
            return uniqueCount;
        }
        return rowCount;
    }

    private long scaleInventory() {
        int nDays = Date.JULIAN_DATE_MAXIMUM - Date.JULIAN_DATE_MINIMUM;
        nDays += 7;
        return this.getIdCount(Table.ITEM) * this.getRowCount(Table.WAREHOUSE) * (long)(nDays /= 7);
    }

    public double getScale() {
        return this.scale;
    }

    public long getRowCountForDate(Table table, long julianDate) {
        long rowCount;
        switch (table) {
            case STORE_SALES: 
            case CATALOG_SALES: 
            case WEB_SALES: {
                rowCount = this.getRowCount(table);
                break;
            }
            case S_CATALOG_ORDER: {
                rowCount = this.getRowCount(Table.CATALOG_SALES);
                break;
            }
            case S_PURCHASE: {
                rowCount = this.getRowCount(Table.STORE_SALES);
                break;
            }
            case S_WEB_ORDER: {
                rowCount = this.getRowCount(Table.WEB_SALES);
                break;
            }
            case S_INVENTORY: 
            case INVENTORY: {
                rowCount = this.getRowCount(Table.WAREHOUSE) * this.getIdCount(Table.ITEM);
                break;
            }
            default: {
                throw new TpcdsException("Invalid table for date scaling");
            }
        }
        Date date = Date.fromJulianDays((int)julianDate);
        if (table != Table.INVENTORY) {
            CalendarDistribution.Weights weights;
            if (table == Table.S_INVENTORY) {
                weights = CalendarDistribution.Weights.UNIFORM;
                if (Date.isLeapYear(date.getYear())) {
                    weights = CalendarDistribution.Weights.UNIFORM_LEAP_YEAR;
                }
            } else {
                weights = CalendarDistribution.Weights.SALES;
                if (Date.isLeapYear(date.getYear())) {
                    weights = CalendarDistribution.Weights.SALES_LEAP_YEAR;
                }
            }
            int calendarTotal = CalendarDistribution.getMaxWeight(weights) * 5;
            int dayWeight = CalendarDistribution.getWeightForDayNumber(CalendarDistribution.getIndexForDate(date), weights);
            rowCount *= (long)dayWeight;
            rowCount += (long)(calendarTotal / 2);
            rowCount /= (long)calendarTotal;
        }
        return rowCount;
    }
}

