/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.JoinKeyUtils;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Parallel;
import com.teradata.tpcds.Permutations;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.SlowlyChangingDimensionUtils;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.CatalogSalesGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.CatalogSalesRow;
import com.teradata.tpcds.row.TableRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.CatalogReturnsRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Decimal;
import com.teradata.tpcds.type.Pricing;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CatalogSalesRowGenerator
extends AbstractRowGenerator {
    public static final int CS_QUANTITY_MAX = 100;
    public static final Decimal CS_MARKUP_MAX = new Decimal(200L, 2);
    public static final Decimal CS_DISCOUNT_MAX = new Decimal(100L, 2);
    public static final Decimal CS_WHOLESALE_MAX = new Decimal(10000L, 2);
    public static final int CS_MIN_SHIP_DELAY = 2;
    public static final int CS_MAX_SHIP_DELAY = 90;
    public static final int GIFT_PERCENTAGE = 10;
    private int[] itemPermutation;
    private long julianDate;
    private long nextDateIndex;
    private int remainingLineItems = 0;
    private OrderInfo orderInfo = new OrderInfo();
    private int ticketItemBase;

    public CatalogSalesRowGenerator() {
        super(Table.CATALOG_SALES);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long csShipDateSk;
        int itemCount = (int)session.getScaling().getIdCount(Table.ITEM);
        if (this.itemPermutation == null) {
            this.itemPermutation = Permutations.makePermutation(itemCount, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_PERMUTE));
            Parallel.DateNextIndexPair pair = Parallel.skipDaysUntilFirstRowOfChunk(Table.CATALOG_SALES, session);
            this.julianDate = pair.getJulianDate();
            this.nextDateIndex = pair.getNextDateIndex();
        }
        if (this.remainingLineItems == 0) {
            this.orderInfo = this.generateOrderInfo(rowNumber, session);
            this.ticketItemBase = RandomValueGenerator.generateUniformRandomInt(1, itemCount, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SOLD_ITEM_SK));
            this.remainingLineItems = RandomValueGenerator.generateUniformRandomInt(4, 14, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_ORDER_NUMBER));
        }
        long nullBitMap = Nulls.createNullBitMap(Table.CATALOG_SALES, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_NULLS));
        int shippingLag = RandomValueGenerator.generateUniformRandomInt(2, 90, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_DATE_SK));
        long l = csShipDateSk = this.orderInfo.getCsSoldDateSk() == -1L ? -1L : this.orderInfo.getCsSoldDateSk() + (long)shippingLag;
        if (++this.ticketItemBase > itemCount) {
            this.ticketItemBase = 1;
        }
        Scaling scaling = session.getScaling();
        long item = Permutations.getPermutationEntry(this.itemPermutation, this.ticketItemBase);
        long csSoldItemSk = SlowlyChangingDimensionUtils.matchSurrogateKey(item, this.orderInfo.getCsSoldDateSk(), Table.ITEM, scaling);
        long csCatalogPageSk = this.orderInfo.getCsSoldDateSk() == -1L ? -1L : JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_CATALOG_PAGE_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_CATALOG_PAGE_SK), Table.CATALOG_PAGE, this.orderInfo.getCsSoldDateSk(), scaling);
        long csShipModeSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_SHIP_MODE_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_MODE_SK), Table.SHIP_MODE, 1L, scaling);
        long csWarehouseSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_WAREHOUSE_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_WAREHOUSE_SK), Table.WAREHOUSE, 1L, scaling);
        long csPromoSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_PROMO_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_PROMO_SK), Table.PROMOTION, 1L, scaling);
        Pricing csPricing = Pricing.generatePricingForSalesTable(CatalogSalesGeneratorColumn.CS_PRICING, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_PRICING));
        CatalogSalesRow catalogSalesRow = new CatalogSalesRow(this.orderInfo.getCsSoldDateSk(), this.orderInfo.getCsSoldTimeSk(), csShipDateSk, this.orderInfo.getCsBillCustomerSk(), this.orderInfo.getCsBillCdemoSk(), this.orderInfo.getCsBillHdemoSk(), this.orderInfo.getCsBillAddrSk(), this.orderInfo.getCsShipCustomerSk(), this.orderInfo.getCsShipCdemoSk(), this.orderInfo.getCsShipHdemoSk(), this.orderInfo.getCsShipAddrSk(), this.orderInfo.getCsCallCenterSk(), csCatalogPageSk, csShipModeSk, csWarehouseSk, csSoldItemSk, csPromoSk, this.orderInfo.getCsOrderNumber(), csPricing, nullBitMap);
        ArrayList<TableRow> generatedRows = new ArrayList<TableRow>(2);
        generatedRows.add(catalogSalesRow);
        int randomInt = RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CR_IS_RETURNED));
        if (!(randomInt >= 10 || session.generateOnlyOneTable() && session.getOnlyTableToGenerate() == Table.CATALOG_SALES)) {
            TableRow catalogReturnsRow = ((CatalogReturnsRowGenerator)childRowGenerator).generateRow(session, catalogSalesRow);
            generatedRows.add(catalogReturnsRow);
        }
        --this.remainingLineItems;
        return new RowGeneratorResult(generatedRows, this.isLastRowInOrder());
    }

    private boolean isLastRowInOrder() {
        return this.remainingLineItems == 0;
    }

    private OrderInfo generateOrderInfo(long rowNumber, Session session) {
        Scaling scaling = session.getScaling();
        while (rowNumber > this.nextDateIndex) {
            ++this.julianDate;
            this.nextDateIndex += scaling.getRowCountForDate(Table.CATALOG_SALES, this.julianDate);
        }
        long csSoldDateSk = this.julianDate;
        long csSoldTimeSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_SOLD_TIME_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SOLD_TIME_SK), Table.TIME_DIM, this.orderInfo.getCsCallCenterSk(), scaling);
        long csCallCenterSk = csSoldDateSk == -1L ? -1L : JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_CALL_CENTER_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_CALL_CENTER_SK), Table.CALL_CENTER, csSoldDateSk, scaling);
        long csBillCustomerSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_BILL_CUSTOMER_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_BILL_CUSTOMER_SK), Table.CUSTOMER, 1L, scaling);
        long csBillCdemoSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_BILL_CDEMO_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_BILL_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 1L, scaling);
        long csBillHdemoSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_BILL_HDEMO_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_BILL_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 1L, scaling);
        long csBillAddrSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_BILL_ADDR_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_BILL_ADDR_SK), Table.CUSTOMER_ADDRESS, 1L, scaling);
        int giftPercentage = RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_CUSTOMER_SK));
        long csShipCustomerSk = csBillCustomerSk;
        long csShipCdemoSk = csBillCdemoSk;
        long csShipHdemoSk = csBillHdemoSk;
        long csShipAddrSk = csBillAddrSk;
        if (giftPercentage <= 10) {
            csShipCustomerSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_SHIP_CUSTOMER_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_CUSTOMER_SK), Table.CUSTOMER, 2L, scaling);
            csShipCdemoSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_SHIP_CDEMO_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 2L, scaling);
            csShipHdemoSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_SHIP_HDEMO_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 2L, scaling);
            csShipAddrSk = JoinKeyUtils.generateJoinKey(CatalogSalesGeneratorColumn.CS_SHIP_ADDR_SK, this.getRandomNumberStream(CatalogSalesGeneratorColumn.CS_SHIP_ADDR_SK), Table.CUSTOMER_ADDRESS, 2L, scaling);
        }
        long csOrderNumber = rowNumber;
        return new OrderInfo(csSoldDateSk, csSoldTimeSk, csCallCenterSk, csBillCustomerSk, csBillCdemoSk, csBillHdemoSk, csBillAddrSk, csShipCustomerSk, csShipCdemoSk, csShipHdemoSk, csShipAddrSk, csOrderNumber);
    }

    private class OrderInfo {
        private final long csSoldDateSk;
        private final long csSoldTimeSk;
        private final long csCallCenterSk;
        private final long csBillCustomerSk;
        private final long csBillCdemoSk;
        private final long csBillHdemoSk;
        private final long csBillAddrSk;
        private final long csShipCustomerSk;
        private final long csShipCdemoSk;
        private final long csShipHdemoSk;
        private final long csShipAddrSk;
        private final long csOrderNumber;

        public OrderInfo(long csSoldDateSk, long csSoldTimeSk, long csCallCenterSk, long csBillCustomerSk, long csBillCdemoSk, long csBillHdemoSk, long csBillAddrSk, long csShipCustomerSk, long csShipCdemoSk, long csShipHdemoSk, long csShipAddrSk, long csOrderNumber) {
            this.csSoldDateSk = csSoldDateSk;
            this.csSoldTimeSk = csSoldTimeSk;
            this.csCallCenterSk = csCallCenterSk;
            this.csBillCustomerSk = csBillCustomerSk;
            this.csBillCdemoSk = csBillCdemoSk;
            this.csBillHdemoSk = csBillHdemoSk;
            this.csBillAddrSk = csBillAddrSk;
            this.csShipCustomerSk = csShipCustomerSk;
            this.csShipCdemoSk = csShipCdemoSk;
            this.csShipHdemoSk = csShipHdemoSk;
            this.csShipAddrSk = csShipAddrSk;
            this.csOrderNumber = csOrderNumber;
        }

        public OrderInfo() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        public long getCsSoldDateSk() {
            return this.csSoldDateSk;
        }

        public long getCsSoldTimeSk() {
            return this.csSoldTimeSk;
        }

        public long getCsCallCenterSk() {
            return this.csCallCenterSk;
        }

        public long getCsBillCustomerSk() {
            return this.csBillCustomerSk;
        }

        public long getCsBillCdemoSk() {
            return this.csBillCdemoSk;
        }

        public long getCsBillHdemoSk() {
            return this.csBillHdemoSk;
        }

        public long getCsBillAddrSk() {
            return this.csBillAddrSk;
        }

        public long getCsShipCustomerSk() {
            return this.csShipCustomerSk;
        }

        public long getCsShipCdemoSk() {
            return this.csShipCdemoSk;
        }

        public long getCsShipHdemoSk() {
            return this.csShipHdemoSk;
        }

        public long getCsShipAddrSk() {
            return this.csShipAddrSk;
        }

        public long getCsOrderNumber() {
            return this.csOrderNumber;
        }
    }
}

