/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.printers.adm;

import org.apache.asterix.dataflow.data.nontagged.printers.adm.ADatePrinterFactory;
import org.apache.asterix.dataflow.data.nontagged.printers.adm.ADateTimePrinterFactory;
import org.apache.asterix.dataflow.data.nontagged.printers.adm.ATimePrinterFactory;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AIntervalPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    public static final AIntervalPrinterFactory INSTANCE = new AIntervalPrinterFactory();
    public static final IPrinter PRINTER = (b, s, l, ps) -> {
        ps.print("interval(");
        byte typetag = AIntervalSerializerDeserializer.getIntervalTimeType(b, s + 1);
        int startOffset = AIntervalSerializerDeserializer.getIntervalStartOffset(s + 1) - 1;
        int startSize = AIntervalSerializerDeserializer.getStartSize(b, s + 1);
        int endOffset = AIntervalSerializerDeserializer.getIntervalEndOffset(b, s + 1) - 1;
        int endSize = AIntervalSerializerDeserializer.getEndSize(b, s + 1);
        IPrinter timeInstancePrinter = AIntervalPrinterFactory.getIPrinter(typetag);
        timeInstancePrinter.print(b, startOffset, startSize, ps);
        ps.print(", ");
        timeInstancePrinter.print(b, endOffset, endSize, ps);
        ps.print(")");
    };

    private static IPrinter getIPrinter(byte typetag) throws HyracksDataException {
        switch (EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(typetag)) {
            case DATE: {
                return ADatePrinterFactory.PRINTER;
            }
            case TIME: {
                return ATimePrinterFactory.PRINTER;
            }
            case DATETIME: {
                return ADateTimePrinterFactory.PRINTER;
            }
        }
        throw new HyracksDataException("Unsupported internal time types in interval: " + typetag);
    }

    public IPrinter createPrinter() {
        return PRINTER;
    }
}

