/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result.fields;

import java.io.PrintWriter;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.ExecutionPlansJsonPrintUtil;
import org.apache.asterix.translator.SessionConfig;

public class PlansPrinter
implements IResponseFieldPrinter {
    private static final String FIELD_NAME = "plans";
    private final ExecutionPlans executionPlans;
    private final SessionConfig.PlanFormat planFormat;

    public PlansPrinter(ExecutionPlans executionPlans, SessionConfig.PlanFormat planFormat) {
        this.executionPlans = executionPlans;
        this.planFormat = planFormat;
    }

    public void print(PrintWriter pw) {
        pw.print("\t\"");
        pw.print(FIELD_NAME);
        pw.print("\":");
        switch (this.planFormat) {
            case JSON: 
            case STRING: {
                pw.print(ExecutionPlansJsonPrintUtil.asJson((ExecutionPlans)this.executionPlans, (SessionConfig.PlanFormat)this.planFormat));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized plan format: " + this.planFormat);
            }
        }
    }

    public String getName() {
        return FIELD_NAME;
    }
}

