/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.functions;

import java.util.List;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExternalTypeComputer
extends AbstractResultTypeComputer {
    private final IAType resultType;
    private final List<IAType> paramPrimeTypes;
    private final boolean nullCall;

    protected void checkArgType(FunctionIdentifier funcId, int argIndex, IAType type, SourceLocation sourceLoc) throws AlgebricksException {
        IAType reqParamType = this.paramPrimeTypes.get(argIndex);
        if (!type.equals(this.paramPrimeTypes.get(argIndex)) && !ATypeHierarchy.isCompatible((ATypeTag)type.getTypeTag(), (ATypeTag)reqParamType.getTypeTag())) {
            throw new TypeMismatchException(sourceLoc, funcId, argIndex, type.getTypeTag(), new ATypeTag[]{this.paramPrimeTypes.get(argIndex).getTypeTag()});
        }
    }

    public ExternalTypeComputer(IAType resultPrimeType, List<IAType> paramPrimeTypes, boolean nullCall) {
        this.resultType = resultPrimeType.getTypeTag() == ATypeTag.ANY ? resultPrimeType : AUnionType.createUnknownableType((IAType)resultPrimeType);
        this.paramPrimeTypes = paramPrimeTypes;
        this.nullCall = nullCall;
    }

    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) {
        return this.resultType;
    }

    protected boolean propagateNullAndMissing() {
        return !this.nullCall;
    }
}

