/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.io.IWritable;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class IndexStats
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ICounter numPages;
    private String indexName;

    public IndexStats(String indexName, long numPages) {
        this.indexName = indexName;
        this.numPages = new Counter("numPages");
        this.numPages.set(numPages);
    }

    public static IndexStats create(DataInput input) throws IOException {
        String indexName = input.readUTF();
        long numPages = input.readLong();
        return new IndexStats(indexName, numPages);
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.indexName);
        output.writeLong(this.numPages.get());
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.indexName = input.readUTF();
        this.numPages.set(input.readLong());
    }

    public void updateNumPages(long delta) {
        this.numPages.update(delta);
    }

    public long getNumPages() {
        return this.numPages.get();
    }

    public String toString() {
        return "IndexStats{indexName='" + this.indexName + "', numPages=" + this.numPages.get() + "}";
    }
}

