/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.algebra.operators.physical.ExternalDataLookupPOperator;
import org.apache.asterix.common.annotations.AbstractExpressionAnnotationWithIndexNames;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizer;

public class AccessMethodUtils {
    public static final ImmutableSet<FunctionIdentifier> CAST_NULL_TYPE_CONSTRUCTORS = ImmutableSet.of((Object)BuiltinFunctions.BOOLEAN_DEFAULT_NULL_CONSTRUCTOR, (Object)BuiltinFunctions.INT8_DEFAULT_NULL_CONSTRUCTOR, (Object)BuiltinFunctions.INT16_DEFAULT_NULL_CONSTRUCTOR, (Object)BuiltinFunctions.INT32_DEFAULT_NULL_CONSTRUCTOR, (Object)BuiltinFunctions.INT64_DEFAULT_NULL_CONSTRUCTOR, (Object)BuiltinFunctions.FLOAT_DEFAULT_NULL_CONSTRUCTOR, (Object[])new FunctionIdentifier[]{BuiltinFunctions.DOUBLE_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.STRING_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DATE_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DATE_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT, BuiltinFunctions.TIME_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.TIME_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT, BuiltinFunctions.DATETIME_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DATETIME_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT, BuiltinFunctions.DURATION_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.DAY_TIME_DURATION_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.YEAR_MONTH_DURATION_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.UUID_DEFAULT_NULL_CONSTRUCTOR, BuiltinFunctions.BINARY_BASE64_DEFAULT_NULL_CONSTRUCTOR});
    private static final Pair<List<String>, Integer> NO_FIELD_NAME = new Pair(Collections.emptyList(), (Object)0);

    public static void appendPrimaryIndexTypes(Dataset dataset, IAType itemType, IAType metaItemType, List<Object> target) throws AlgebricksException {
        ARecordType recordType = (ARecordType)itemType;
        ARecordType metaRecordType = (ARecordType)metaItemType;
        target.addAll(KeyFieldTypeUtil.getPartitoningKeyTypes((Dataset)dataset, (ARecordType)recordType, (ARecordType)metaRecordType));
        target.add(itemType);
        if (dataset.hasMetaPart()) {
            target.add(metaItemType);
        }
    }

    public static ConstantExpression createStringConstant(String str) {
        return new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(str)));
    }

    public static ConstantExpression createInt32Constant(int i) {
        return new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)));
    }

    public static ConstantExpression createBooleanConstant(boolean b) {
        return new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.valueOf((boolean)b)));
    }

    public static String getStringConstant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static int getInt32Constant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getIntConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static long getInt64Constant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getLongConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static boolean getBooleanConstant(Mutable<ILogicalExpression> expr) {
        return ConstantExpressionUtil.getBooleanConstant((ILogicalExpression)((ILogicalExpression)expr.getValue()));
    }

    public static boolean analyzeFuncExprArgsForOneConstAndVarAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment, boolean allowFunctionExprArg) throws AlgebricksException {
        int varIndex;
        ILogicalExpression constExpression = null;
        IAType constantExpressionType = null;
        LogicalVariable fieldVar = null;
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() == LogicalExpressionTag.VARIABLE && arg2.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return false;
        }
        if (arg2.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.STRING_CONTAINS || funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS || funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
                return false;
            }
            IAType expressionType = AccessMethodUtils.constantRuntimeResultType(arg1, context, typeEnvironment);
            if (expressionType == null) {
                return false;
            }
            constantExpressionType = expressionType;
            constExpression = arg1;
            VariableReferenceExpression varExpr = (VariableReferenceExpression)arg2;
            fieldVar = varExpr.getVariableReference();
            varIndex = 1;
        } else if (arg1.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType expressionType = AccessMethodUtils.constantRuntimeResultType(arg2, context, typeEnvironment);
            if (expressionType == null) {
                return false;
            }
            constantExpressionType = expressionType;
            constExpression = arg2;
            if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.FULLTEXT_CONTAINS && arg2.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                AccessMethodUtils.checkFTSearchConstantExpression(constExpression);
            }
            VariableReferenceExpression varExpr = (VariableReferenceExpression)arg1;
            fieldVar = varExpr.getVariableReference();
            varIndex = 0;
        } else {
            if (!allowFunctionExprArg) {
                return false;
            }
            if (AccessMethodUtils.acceptExpressionArg(arg1, context, typeEnvironment)) {
                Pair<LogicalVariable, IAType> varConstType = AccessMethodUtils.getVarAndConstExprType(arg1, arg2, context, typeEnvironment);
                if (varConstType == null) {
                    return false;
                }
                fieldVar = (LogicalVariable)varConstType.first;
                constantExpressionType = (IAType)varConstType.second;
                constExpression = arg2;
                varIndex = 0;
            } else if (AccessMethodUtils.acceptExpressionArg(arg2, context, typeEnvironment)) {
                Pair<LogicalVariable, IAType> varConstType = AccessMethodUtils.getVarAndConstExprType(arg2, arg1, context, typeEnvironment);
                if (varConstType == null) {
                    return false;
                }
                fieldVar = (LogicalVariable)varConstType.first;
                constantExpressionType = (IAType)varConstType.second;
                constExpression = arg1;
                varIndex = 1;
            } else {
                return false;
            }
        }
        AccessMethodUtils.constructNewOptFuncExprAndAddToAnalysisCtx(funcExpr, fieldVar, constExpression, constantExpressionType, analysisCtx, varIndex);
        return true;
    }

    private static boolean acceptExpressionArg(ILogicalExpression expr, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funExpr = (AbstractFunctionCallExpression)expr;
        List funArgs = funExpr.getArguments();
        if (funArgs.size() <= 0) {
            return false;
        }
        if (((ILogicalExpression)((Mutable)funArgs.get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        for (int i = 1; i < funArgs.size(); ++i) {
            IAType constExprType = AccessMethodUtils.constantRuntimeResultType((ILogicalExpression)((Mutable)funArgs.get(i)).getValue(), context, typeEnvironment);
            if (constExprType != null) continue;
            return false;
        }
        return true;
    }

    private static Pair<LogicalVariable, IAType> getVarAndConstExprType(ILogicalExpression exprWithVar, ILogicalExpression constExpr, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        IAType constExprType = AccessMethodUtils.constantRuntimeResultType(constExpr, context, typeEnvironment);
        if (constExprType == null) {
            return null;
        }
        AbstractFunctionCallExpression funExpr = (AbstractFunctionCallExpression)exprWithVar;
        LogicalVariable varFromExpr = ((VariableReferenceExpression)((Mutable)funExpr.getArguments().get(0)).getValue()).getVariableReference();
        return new Pair((Object)varFromExpr, (Object)constExprType);
    }

    private static void constructNewOptFuncExprAndAddToAnalysisCtx(AbstractFunctionCallExpression funcExpr, LogicalVariable fieldVar, ILogicalExpression expression, IAType expressionType, AccessMethodAnalysisContext analysisCtx, int varIndex) {
        OptimizableFuncExpr newOptFuncExpr = new OptimizableFuncExpr(funcExpr, fieldVar, expression, expressionType, varIndex);
        AccessMethodUtils.addNewOptFuncExprToAnalysisCtx(funcExpr, newOptFuncExpr, analysisCtx);
    }

    private static void constructNewOptFuncExprAndAddToAnalysisCtx(AbstractFunctionCallExpression funcExpr, LogicalVariable[] fieldVars, int[] fieldVarsIdxes, ILogicalExpression[] expressions, IAType[] expressionTypes, AccessMethodAnalysisContext analysisCtx) {
        OptimizableFuncExpr newOptFuncExpr = new OptimizableFuncExpr(funcExpr, fieldVars, fieldVarsIdxes, expressions, expressionTypes);
        AccessMethodUtils.addNewOptFuncExprToAnalysisCtx(funcExpr, newOptFuncExpr, analysisCtx);
    }

    private static void addNewOptFuncExprToAnalysisCtx(AbstractFunctionCallExpression funcExpr, OptimizableFuncExpr newOptFuncExpr, AccessMethodAnalysisContext analysisCtx) {
        for (IOptimizableFuncExpr optFuncExpr : analysisCtx.getMatchedFuncExprs()) {
            if (!optFuncExpr.getFuncExpr().equals((Object)funcExpr)) continue;
            return;
        }
        analysisCtx.addMatchedFuncExpr(newOptFuncExpr);
    }

    private static void checkEachElementInFTSearchListPredicate(IACursor oListCursor) throws AlgebricksException {
        while (oListCursor.next()) {
            IAObject element = oListCursor.get();
            if (element.getType() == BuiltinType.ASTRING) {
                String argValue = ConstantExpressionUtil.getStringConstant((IAObject)element);
                AccessMethodUtils.checkAndGenerateFTSearchExceptionForStringPhrase(argValue);
                continue;
            }
            throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, new Serializable[]{BuiltinFunctions.FULLTEXT_CONTAINS.getName(), element.getType().getTypeTag()});
        }
    }

    public static void checkFTSearchConstantExpression(ILogicalExpression constExpression) throws AlgebricksException {
        IAObject objectFromExpr = ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)constExpression, null);
        switch (objectFromExpr.getType().getTypeTag()) {
            case STRING: {
                String arg2Value = ConstantExpressionUtil.getStringConstant((IAObject)objectFromExpr);
                AccessMethodUtils.checkAndGenerateFTSearchExceptionForStringPhrase(arg2Value);
                break;
            }
            case ARRAY: {
                IACursor oListCursor = ConstantExpressionUtil.getOrderedListConstant((IAObject)objectFromExpr).getCursor();
                AccessMethodUtils.checkEachElementInFTSearchListPredicate(oListCursor);
                break;
            }
            case MULTISET: {
                IACursor oListCursor = ConstantExpressionUtil.getUnorderedListConstant((IAObject)objectFromExpr).getCursor();
                AccessMethodUtils.checkEachElementInFTSearchListPredicate(oListCursor);
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, constExpression.getSourceLocation(), new Serializable[]{BuiltinFunctions.FULLTEXT_CONTAINS.getName(), objectFromExpr.getType().getTypeTag()});
            }
        }
    }

    public static void checkAndGenerateFTSearchExceptionForStringPhrase(String value) throws AlgebricksException {
        for (int j = 0; j < value.length(); ++j) {
            if (!DelimitedUTF8StringBinaryTokenizer.isSeparator((char)value.charAt(j))) continue;
            throw new CompilationException(ErrorCode.COMPILATION_FULLTEXT_PHRASE_FOUND, new Serializable[0]);
        }
    }

    public static boolean analyzeFuncExprArgsForTwoVarsAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, AccessMethodAnalysisContext analysisCtx) {
        LogicalVariable fieldVar1 = null;
        LogicalVariable fieldVar2 = null;
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.VARIABLE || arg2.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        fieldVar1 = ((VariableReferenceExpression)arg1).getVariableReference();
        fieldVar2 = ((VariableReferenceExpression)arg2).getVariableReference();
        AccessMethodUtils.constructNewOptFuncExprAndAddToAnalysisCtx(funcExpr, new LogicalVariable[]{fieldVar1, fieldVar2}, new int[]{0, 1}, new ILogicalExpression[0], new IAType[0], analysisCtx);
        return true;
    }

    public static void appendSecondaryIndexTypes(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, Index index, List<Object> dest, boolean requireResultOfInstantTryLock) throws AlgebricksException {
        boolean primaryKeysOnly = AccessMethodUtils.isInvertedIndex(index);
        if (!primaryKeysOnly) {
            switch (index.getIndexType()) {
                case ARRAY: {
                    dest.addAll(KeyFieldTypeUtil.getArrayBTreeIndexKeyTypes((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType));
                    break;
                }
                case BTREE: {
                    List bTreeIndexKeyTypes = KeyFieldTypeUtil.getBTreeIndexKeyTypes((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType);
                    dest.addAll(bTreeIndexKeyTypes.stream().map(Pair::getFirst).collect(Collectors.toList()));
                    break;
                }
                case RTREE: {
                    dest.addAll(KeyFieldTypeUtil.getRTreeIndexKeyTypes((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType));
                    break;
                }
            }
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            AccessMethodUtils.appendExternalRecPrimaryKeys(dataset, dest);
        } else {
            dest.addAll(KeyFieldTypeUtil.getPartitoningKeyTypes((Dataset)dataset, (ARecordType)recordType, (ARecordType)metaRecordType));
        }
        if (requireResultOfInstantTryLock) {
            dest.add(BuiltinType.AINT32);
        }
    }

    public static void appendSecondaryIndexOutputVars(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, Index index, IOptimizationContext context, List<LogicalVariable> dest, boolean requireResultOfInstantTryLock) throws AlgebricksException {
        int numVars;
        int numPrimaryKeys = dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getRIDSize((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties()) : dataset.getPrimaryKeys().size();
        int numSecondaryKeys = KeyFieldTypeUtil.getNumSecondaryKeys((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType);
        int n = numVars = AccessMethodUtils.isInvertedIndex(index) ? numPrimaryKeys : numPrimaryKeys + numSecondaryKeys;
        if (requireResultOfInstantTryLock) {
            ++numVars;
        }
        for (int i = 0; i < numVars; ++i) {
            dest.add(context.newVar());
        }
    }

    public static List<LogicalVariable> getKeyVarsFromSecondaryUnnestMap(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, ILogicalOperator unnestMapOp, Index index, SecondaryUnnestMapOutputVarType keyVarType) throws AlgebricksException {
        int stop;
        int numSecondaryKeys = KeyFieldTypeUtil.getNumSecondaryKeys((Index)index, (ARecordType)recordType, (ARecordType)metaRecordType);
        int numPrimaryKeys = dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getRIDSize((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties()) : dataset.getPrimaryKeys().size();
        ArrayList<LogicalVariable> keyVars = new ArrayList<LogicalVariable>();
        AbstractUnnestMapOperator abstractUnnestMapOp = (AbstractUnnestMapOperator)unnestMapOp;
        List sourceVars = abstractUnnestMapOp.getVariables();
        boolean isNgramOrKeywordIndex = AccessMethodUtils.isInvertedIndex(index);
        if (isNgramOrKeywordIndex) {
            numSecondaryKeys = 0;
        }
        switch (keyVarType) {
            case PRIMARY_KEY: {
                int start = numSecondaryKeys;
                stop = numSecondaryKeys + numPrimaryKeys;
                break;
            }
            case SECONDARY_KEY: {
                int start = 0;
                stop = numSecondaryKeys;
                break;
            }
            case CONDITIONAL_SPLIT_VAR: {
                if (!abstractUnnestMapOp.getGenerateCallBackProceedResultVar()) {
                    throw CompilationException.create((ErrorCode)ErrorCode.CANNOT_GET_CONDITIONAL_SPLIT_KEY_VARIABLE, (SourceLocation)unnestMapOp.getSourceLocation(), (Serializable[])new Serializable[0]);
                }
                int start = numSecondaryKeys + numPrimaryKeys;
                stop = start + 1;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        for (int i = start; i < stop; ++i) {
            keyVars.add((LogicalVariable)sourceVars.get(i));
        }
        return keyVars;
    }

    public static List<LogicalVariable> getPrimaryKeyVarsFromPrimaryUnnestMap(Dataset dataset, ILogicalOperator unnestMapOp) {
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        ArrayList<LogicalVariable> primaryKeyVars = new ArrayList<LogicalVariable>();
        List sourceVars = null;
        sourceVars = ((AbstractUnnestMapOperator)unnestMapOp).getVariables();
        for (int i = 0; i < numPrimaryKeys; ++i) {
            primaryKeyVars.add((LogicalVariable)sourceVars.get(i));
        }
        return primaryKeyVars;
    }

    public static Triple<ILogicalExpression, ILogicalExpression, Boolean> createSearchKeyExpr(Index index, IOptimizableFuncExpr optFuncExpr, IAType indexedFieldType, OptimizableOperatorSubTree probeSubTree, SearchKeyRoundingFunctionProvider roundingFunctionProvider) throws AlgebricksException {
        IAType probeType;
        ATypeTag probeTypeTypeTag;
        SourceLocation sourceLoc = optFuncExpr.getFuncExpr().getSourceLocation();
        if (probeSubTree == null) {
            if (optFuncExpr.getNumConstantExpr() == 0) {
                VariableReferenceExpression varRef = new VariableReferenceExpression(optFuncExpr.getLogicalVar(1));
                varRef.setSourceLocation(sourceLoc);
                return new Triple((Object)varRef, null, (Object)false);
            }
            ILogicalExpression constantAtRuntimeExpression = optFuncExpr.getConstantExpr(0);
            AsterixConstantValue constantValue = null;
            if (constantAtRuntimeExpression.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                constantValue = (AsterixConstantValue)((ConstantExpression)constantAtRuntimeExpression).getValue();
            }
            ATypeTag constantValueTag = optFuncExpr.getConstantType(0).getTypeTag();
            ATypeTag indexedFieldTypeTag = TypeComputeUtils.getActualType((IAType)indexedFieldType).getTypeTag();
            boolean realTypeConvertedToIntegerType = false;
            AsterixConstantValue replacedConstantValue = null;
            AsterixConstantValue replacedConstantValueForEQCase = null;
            if (constantValueTag != indexedFieldTypeTag && constantValue != null) {
                realTypeConvertedToIntegerType = AccessMethodUtils.isRealTypeConvertedToIntegerType(constantValueTag, indexedFieldTypeTag);
                if (realTypeConvertedToIntegerType) {
                    FunctionIdentifier functionID = optFuncExpr.getFuncExpr().getFunctionIdentifier();
                    AlgebricksBuiltinFunctions.ComparisonKind cKind = AlgebricksBuiltinFunctions.getComparisonType((FunctionIdentifier)functionID);
                    switch (cKind) {
                        case LT: 
                        case GE: 
                        case LE: 
                        case GT: {
                            ATypeHierarchy.TypeCastingMathFunctionType roundingFunction = roundingFunctionProvider.getRoundingFunction(cKind, index, indexedFieldType, constantValue.getObject(), realTypeConvertedToIntegerType);
                            replacedConstantValue = AccessMethodUtils.getReplacedConstantValue(constantValue.getObject(), constantValueTag, indexedFieldTypeTag, index.isEnforced(), roundingFunction, sourceLoc);
                            break;
                        }
                        case EQ: {
                            replacedConstantValue = AccessMethodUtils.getReplacedConstantValue(constantValue.getObject(), constantValueTag, indexedFieldTypeTag, index.isEnforced(), ATypeHierarchy.TypeCastingMathFunctionType.FLOOR, sourceLoc);
                            replacedConstantValueForEQCase = AccessMethodUtils.getReplacedConstantValue(constantValue.getObject(), constantValueTag, indexedFieldTypeTag, index.isEnforced(), ATypeHierarchy.TypeCastingMathFunctionType.CEIL, sourceLoc);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                } else {
                    replacedConstantValue = AccessMethodUtils.getReplacedConstantValue(constantValue.getObject(), constantValueTag, indexedFieldTypeTag, index.isEnforced(), ATypeHierarchy.TypeCastingMathFunctionType.NONE, sourceLoc);
                }
            }
            if (replacedConstantValue == null) {
                return new Triple((Object)constantAtRuntimeExpression, null, (Object)false);
            }
            if (replacedConstantValueForEQCase == null) {
                return new Triple((Object)new ConstantExpression(replacedConstantValue), null, (Object)realTypeConvertedToIntegerType);
            }
            return new Triple((Object)new ConstantExpression(replacedConstantValue), (Object)new ConstantExpression(replacedConstantValueForEQCase), (Object)realTypeConvertedToIntegerType);
        }
        OptimizableOperatorSubTree opSubTree0 = optFuncExpr.getOperatorSubTree(0);
        int probeVarIndex = opSubTree0 == null || opSubTree0 == probeSubTree ? 0 : 1;
        LogicalVariable probeVar = optFuncExpr.getLogicalVar(probeVarIndex);
        VariableReferenceExpression probeExpr = new VariableReferenceExpression(probeVar);
        probeExpr.setSourceLocation(sourceLoc);
        ATypeTag indexedFieldTypeTag = TypeComputeUtils.getActualType((IAType)indexedFieldType).getTypeTag();
        if (ATypeHierarchy.getTypeDomain((ATypeTag)indexedFieldTypeTag) == ATypeHierarchy.Domain.NUMERIC && (probeTypeTypeTag = (probeType = TypeComputeUtils.getActualType((IAType)optFuncExpr.getFieldType(probeVarIndex))).getTypeTag()) != indexedFieldTypeTag) {
            ScalarFunctionCallExpression castFunc = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE_LAX));
            castFunc.setSourceLocation(sourceLoc);
            castFunc.getArguments().add(new MutableObject((Object)probeExpr));
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castFunc, (IAType)indexedFieldType, (IAType)probeType);
            boolean realTypeConvertedToIntegerType = AccessMethodUtils.isRealTypeConvertedToIntegerType(probeTypeTypeTag, indexedFieldTypeTag);
            return new Triple((Object)castFunc, null, (Object)realTypeConvertedToIntegerType);
        }
        return new Triple((Object)probeExpr, null, (Object)false);
    }

    private static AsterixConstantValue getReplacedConstantValue(IAObject sourceObject, ATypeTag sourceTypeTag, ATypeTag targetTypeTag, boolean strictDemote, ATypeHierarchy.TypeCastingMathFunctionType mathFunction, SourceLocation sourceLoc) throws CompilationException {
        try {
            return ATypeHierarchy.getAsterixConstantValueFromNumericTypeObject((IAObject)sourceObject, (ATypeTag)targetTypeTag, (boolean)strictDemote, (ATypeHierarchy.TypeCastingMathFunctionType)mathFunction);
        }
        catch (HyracksDataException e) {
            throw new CompilationException(ErrorCode.ERROR_OCCURRED_BETWEEN_TWO_TYPES_CONVERSION, (Throwable)e, sourceLoc, new Serializable[]{sourceTypeTag, targetTypeTag});
        }
    }

    private static boolean isRealTypeConvertedToIntegerType(ATypeTag probeTypeTag, ATypeTag indexedFieldTypeTag) {
        switch (probeTypeTag) {
            case DOUBLE: 
            case FLOAT: {
                switch (indexedFieldTypeTag) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static IOptimizableFuncExpr chooseFirstOptFuncExpr(Index chosenIndex, AccessMethodAnalysisContext analysisCtx) {
        List<Pair<Integer, Integer>> indexExprs = analysisCtx.getIndexExprsFromIndexExprsAndVars(chosenIndex);
        int firstExprIndex = (Integer)indexExprs.get((int)0).first;
        return analysisCtx.getMatchedFuncExpr(firstExprIndex);
    }

    public static int chooseFirstOptFuncVar(Index chosenIndex, AccessMethodAnalysisContext analysisCtx) {
        List<Pair<Integer, Integer>> indexExprs = analysisCtx.getIndexExprsFromIndexExprsAndVars(chosenIndex);
        return (Integer)indexExprs.get((int)0).second;
    }

    public static boolean setIndexOnlyPlanInfo(List<Mutable<ILogicalOperator>> afterJoinRefs, Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree probeSubTree, OptimizableOperatorSubTree indexSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, AbstractFunctionCallExpression funcExpr, List<Pair<FunctionIdentifier, Boolean>> funcIdentifiers) throws AlgebricksException {
        boolean isIndexOnlyPlan = false;
        boolean requireVerificationAfterSIdxSearch = false;
        boolean doesSIdxSearchCoverAllPredicates = false;
        Pair<Boolean, Boolean> functionFalsePositiveCheck = AccessMethodUtils.canFunctionGenerateFalsePositiveResultsUsingIndex(funcExpr, funcIdentifiers);
        if (!((Boolean)functionFalsePositiveCheck.first).booleanValue()) {
            return false;
        }
        requireVerificationAfterSIdxSearch = (Boolean)functionFalsePositiveCheck.second;
        Quadruple indexOnlyPlanInfo = new Quadruple((Object)isIndexOnlyPlan, (Object)false, (Object)requireVerificationAfterSIdxSearch, (Object)doesSIdxSearchCoverAllPredicates);
        if (analysisCtx.getIndexDatasetMap().get(chosenIndex).getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            AccessMethodUtils.indexOnlyPlanCheck(afterJoinRefs, joinRef, indexSubTree, probeSubTree, chosenIndex, analysisCtx, context, (Quadruple<Boolean, Boolean, Boolean, Boolean>)indexOnlyPlanInfo);
        } else {
            isIndexOnlyPlan = false;
            indexOnlyPlanInfo.setFirst((Object)isIndexOnlyPlan);
        }
        analysisCtx.setIndexOnlyPlanInfo((Quadruple<Boolean, Boolean, Boolean, Boolean>)indexOnlyPlanInfo);
        return true;
    }

    public static boolean finalizeJoinPlanTransformation(List<Mutable<ILogicalOperator>> afterJoinRefs, Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean isLeftOuterJoin, boolean isLeftOuterJoinWithSpecialGroupBy, IAlgebricksConstantValue leftOuterMissingValue, ILogicalOperator indexSearchOp, LogicalVariable newMissingNullPlaceHolderVar, Mutable<ILogicalExpression> conditionRef, Dataset dataset, Index chosenIndex) throws AlgebricksException {
        ILogicalOperator finalOp;
        boolean isIndexOnlyPlan = (Boolean)analysisCtx.getIndexOnlyPlanInfo().getFirst();
        ArrayList<Object> probePKVars = null;
        ILogicalOperator finalIndexSearchOp = indexSearchOp;
        if (isLeftOuterJoin) {
            if (isLeftOuterJoinWithSpecialGroupBy) {
                ScalarFunctionCallExpression lojFuncExprs = analysisCtx.getLOJIsMissingNullFuncInSpecialGroupBy();
                ArrayList<LogicalVariable> lojMissingNullVariables = new ArrayList<LogicalVariable>();
                lojFuncExprs.getUsedVariables(lojMissingNullVariables);
                boolean lojMissingNullVarExist = !lojMissingNullVariables.isEmpty();
                AccessMethodUtils.resetLOJMissingNullPlaceholderVarInGroupByOp(analysisCtx, newMissingNullPlaceHolderVar, context);
                if (isIndexOnlyPlan) {
                    finalIndexSearchOp = AccessMethodUtils.resetVariableMappingInUnionOpInIndexOnlyPlan(lojMissingNullVarExist, lojMissingNullVariables, indexSearchOp, afterJoinRefs, context);
                }
            } else {
                if (probeSubTree.hasDataSource()) {
                    probePKVars = new ArrayList<LogicalVariable>();
                    probeSubTree.getPrimaryKeyVars(null, probePKVars);
                }
                if (chosenIndex.getIndexType() == DatasetConfig.IndexType.ARRAY) {
                    ILogicalOperator probeRoot = probeSubTree.getRoot();
                    Triple<Set<LogicalVariable>, ILogicalOperator, FunctionalDependency> primaryKeyOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(probeRoot, false, context);
                    probePKVars = new ArrayList((Collection)primaryKeyOpAndVars.first);
                    if (primaryKeyOpAndVars.third != null) {
                        context.addPrimaryKey((FunctionalDependency)primaryKeyOpAndVars.third);
                    }
                    if (primaryKeyOpAndVars.second != null) {
                        MutableObject assignIdOpRef = new MutableObject((Object)((ILogicalOperator)primaryKeyOpAndVars.second));
                        ((ILogicalOperator)assignIdOpRef.getValue()).getInputs().clear();
                        ((ILogicalOperator)assignIdOpRef.getValue()).getInputs().add(new MutableObject((Object)probeRoot));
                        probeSubTree.setRoot((ILogicalOperator)assignIdOpRef.getValue());
                        probeSubTree.setRootRef((Mutable<ILogicalOperator>)assignIdOpRef);
                        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignIdOpRef.getValue());
                        finalIndexSearchOp = (ILogicalOperator)assignIdOpRef.getValue();
                    }
                }
                if (probePKVars == null || probePKVars.isEmpty()) {
                    return false;
                }
                if (isIndexOnlyPlan) {
                    if (indexSearchOp.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
                        return false;
                    }
                    UnionAllOperator unionAllOp = (UnionAllOperator)indexSearchOp;
                    int ln = probePKVars.size();
                    for (int i = 0; i < ln; ++i) {
                        LogicalVariable unionAllOutputVar = AccessMethodUtils.findUnionAllOutputVariable(unionAllOp, (LogicalVariable)probePKVars.get(i));
                        if (unionAllOutputVar == null) {
                            return false;
                        }
                        probePKVars.set(i, unionAllOutputVar);
                    }
                }
            }
        }
        SourceLocation sourceLoc = ((ILogicalOperator)joinRef.getValue()).getSourceLocation();
        indexSubTree.getDataSourceRef().setValue((Object)finalIndexSearchOp);
        if (conditionRef.getValue() != null) {
            if (isIndexOnlyPlan && dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                ILogicalOperator dataSourceRefOp = AccessMethodUtils.findDataSourceFromIndexUtilizationPlan(finalIndexSearchOp);
                if (dataSourceRefOp != null && (dataSourceRefOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP || dataSourceRefOp.getOperatorTag() == LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP)) {
                    indexSubTree.getDataSourceRef().setValue((Object)dataSourceRefOp);
                }
                finalOp = finalIndexSearchOp;
            } else {
                indexSubTree.getDataSourceRef().setValue((Object)finalIndexSearchOp);
                SelectOperator topSelectOp = isLeftOuterJoin ? new SelectOperator(conditionRef, leftOuterMissingValue, newMissingNullPlaceHolderVar) : new SelectOperator(conditionRef);
                topSelectOp.setSourceLocation(sourceLoc);
                topSelectOp.getInputs().add(indexSubTree.getRootRef());
                topSelectOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)topSelectOp);
                finalOp = topSelectOp;
            }
        } else {
            finalOp = finalIndexSearchOp.getOperatorTag() == LogicalOperatorTag.UNIONALL ? finalIndexSearchOp : (ILogicalOperator)indexSubTree.getRootRef().getValue();
        }
        if (isLeftOuterJoin && !isLeftOuterJoinWithSpecialGroupBy) {
            finalOp = AccessMethodUtils.removeUnjoinedDuplicatesInLOJ(finalOp, probePKVars, newMissingNullPlaceHolderVar, leftOuterMissingValue, context, sourceLoc);
        }
        OperatorManipulationUtil.copyCardCostAnnotations((ILogicalOperator)((ILogicalOperator)joinRef.getValue()), (ILogicalOperator)finalOp);
        joinRef.setValue((Object)finalOp);
        return true;
    }

    private static SelectOperator removeUnjoinedDuplicatesInLOJ(ILogicalOperator inputOp, List<LogicalVariable> probePKVars, LogicalVariable newNullPlaceHolderVar, IAlgebricksConstantValue lojMissingValue, IOptimizationContext context, SourceLocation sourceLoc) throws AlgebricksException {
        if (probePKVars == null || probePKVars.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<MutableObject> winPartitionByList = new ArrayList<MutableObject>(probePKVars.size());
        for (LogicalVariable probePKeyVar : probePKVars) {
            VariableReferenceExpression probePKeyVarRef = new VariableReferenceExpression(probePKeyVar);
            probePKeyVarRef.setSourceLocation(sourceLoc);
            winPartitionByList.add(new MutableObject((Object)probePKeyVarRef));
        }
        VariableReferenceExpression winOrderByVarRef = new VariableReferenceExpression(newNullPlaceHolderVar);
        winOrderByVarRef.setSourceLocation(sourceLoc);
        Pair winOrderByPair = new Pair((Object)OrderOperator.DESC_ORDER, (Object)new MutableObject((Object)winOrderByVarRef));
        LogicalVariable winVar = context.newVar();
        VariableReferenceExpression winOrderByVarRef2 = new VariableReferenceExpression(newNullPlaceHolderVar);
        winOrderByVarRef2.setSourceLocation(sourceLoc);
        FunctionIdentifier winMarkFirstUnknownValueFn = lojMissingValue.isNull() ? BuiltinFunctions.WIN_MARK_FIRST_NULL_IMPL : BuiltinFunctions.WIN_MARK_FIRST_MISSING_IMPL;
        AbstractFunctionCallExpression winExpr = BuiltinFunctions.makeWindowFunctionExpression((FunctionIdentifier)winMarkFirstUnknownValueFn, Collections.singletonList(new MutableObject((Object)winOrderByVarRef2)));
        WindowOperator winOp = new WindowOperator(winPartitionByList, Collections.singletonList(winOrderByPair));
        winOp.getVariables().add(winVar);
        winOp.getExpressions().add(new MutableObject((Object)winExpr));
        winOp.getInputs().add(new MutableObject((Object)inputOp));
        winOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        winOp.setSourceLocation(sourceLoc);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)winOp);
        VariableReferenceExpression winVarRef = new VariableReferenceExpression(winVar);
        winVarRef.setSourceLocation(sourceLoc);
        SelectOperator selectOp = new SelectOperator((Mutable)new MutableObject((Object)winVarRef));
        selectOp.getInputs().add(new MutableObject((Object)winOp));
        selectOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        selectOp.setSourceLocation(sourceLoc);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)selectOp);
        return selectOp;
    }

    public static ILogicalOperator createSecondaryIndexUnnestMap(Dataset dataset, ARecordType recordType, ARecordType metaRecordType, Index index, ILogicalOperator inputOp, AccessMethodJobGenParams jobGenParams, IOptimizationContext context, boolean retainInput, boolean retainNull, boolean generateInstantTrylockResultFromIndexSearch, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        SourceLocation sourceLoc = inputOp.getSourceLocation();
        ArrayList<Mutable<ILogicalExpression>> secondaryIndexFuncArgs = new ArrayList<Mutable<ILogicalExpression>>();
        jobGenParams.writeToFuncArgs(secondaryIndexFuncArgs);
        ArrayList<LogicalVariable> secondaryIndexUnnestVars = new ArrayList<LogicalVariable>();
        ArrayList<Object> secondaryIndexOutputTypes = new ArrayList<Object>();
        AccessMethodUtils.appendSecondaryIndexOutputVars(dataset, recordType, metaRecordType, index, context, secondaryIndexUnnestVars, generateInstantTrylockResultFromIndexSearch);
        AccessMethodUtils.appendSecondaryIndexTypes(dataset, recordType, metaRecordType, index, secondaryIndexOutputTypes, generateInstantTrylockResultFromIndexSearch);
        BuiltinFunctionInfo secondaryIndexSearch = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.INDEX_SEARCH);
        UnnestingFunctionCallExpression secondaryIndexSearchFunc = new UnnestingFunctionCallExpression((IFunctionInfo)secondaryIndexSearch, secondaryIndexFuncArgs);
        secondaryIndexSearchFunc.setSourceLocation(sourceLoc);
        secondaryIndexSearchFunc.setReturnsUniqueValues(true);
        if (retainNull) {
            if (retainInput) {
                LeftOuterUnnestMapOperator secondaryIndexLeftOuterUnnestOp = new LeftOuterUnnestMapOperator(secondaryIndexUnnestVars, (Mutable)new MutableObject((Object)secondaryIndexSearchFunc), secondaryIndexOutputTypes, leftOuterMissingValue);
                secondaryIndexLeftOuterUnnestOp.setSourceLocation(sourceLoc);
                secondaryIndexLeftOuterUnnestOp.setGenerateCallBackProceedResultVar(generateInstantTrylockResultFromIndexSearch);
                secondaryIndexLeftOuterUnnestOp.getInputs().add(new MutableObject((Object)inputOp));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)secondaryIndexLeftOuterUnnestOp);
                secondaryIndexLeftOuterUnnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                return secondaryIndexLeftOuterUnnestOp;
            }
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Left-outer-join should propagate all inputs from the outer branch."});
        }
        UnnestMapOperator secondaryIndexUnnestOp = new UnnestMapOperator(secondaryIndexUnnestVars, (Mutable)new MutableObject((Object)secondaryIndexSearchFunc), secondaryIndexOutputTypes, retainInput);
        secondaryIndexUnnestOp.setSourceLocation(sourceLoc);
        secondaryIndexUnnestOp.setGenerateCallBackProceedResultVar(generateInstantTrylockResultFromIndexSearch);
        secondaryIndexUnnestOp.getInputs().add(new MutableObject((Object)inputOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)secondaryIndexUnnestOp);
        secondaryIndexUnnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        return secondaryIndexUnnestOp;
    }

    private static AbstractUnnestMapOperator createFinalNonIndexOnlySearchPlan(Dataset dataset, ILogicalOperator inputOp, IOptimizationContext context, boolean sortPrimaryKeys, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, boolean requiresDistinct, List<LogicalVariable> primaryKeyVars, List<LogicalVariable> primaryIndexUnnestVars, List<LogicalVariable> auxDistinctVars, List<Object> primaryIndexOutputTypes, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        MutableObject vRef;
        VariableReferenceExpression pkVarRef;
        SourceLocation sourceLoc = inputOp.getSourceLocation();
        if (requiresDistinct && sortPrimaryKeys) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{"Non-index search plan cannot include a DISTINCT and an ORDER."});
        }
        DistinctOperator distinct = null;
        if (requiresDistinct) {
            ArrayList<MutableObject> distinctExprs = new ArrayList<MutableObject>();
            for (LogicalVariable pkVar : primaryKeyVars) {
                pkVarRef = new VariableReferenceExpression(pkVar);
                pkVarRef.setSourceLocation(sourceLoc);
                vRef = new MutableObject((Object)pkVarRef);
                distinctExprs.add(vRef);
            }
            for (LogicalVariable auxVar : auxDistinctVars) {
                VariableReferenceExpression auxVarRef = new VariableReferenceExpression(auxVar);
                auxVarRef.setSourceLocation(sourceLoc);
                vRef = new MutableObject((Object)auxVarRef);
                distinctExprs.add(vRef);
            }
            distinct = new DistinctOperator(distinctExprs);
            distinct.setSourceLocation(sourceLoc);
            distinct.getInputs().add(new MutableObject((Object)inputOp));
            distinct.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)distinct);
        }
        OrderOperator order = null;
        if (sortPrimaryKeys) {
            order = new OrderOperator();
            order.setSourceLocation(sourceLoc);
            for (LogicalVariable pkVar : primaryKeyVars) {
                pkVarRef = new VariableReferenceExpression(pkVar);
                pkVarRef.setSourceLocation(sourceLoc);
                vRef = new MutableObject((Object)pkVarRef);
                order.getOrderExpressions().add(new Pair((Object)OrderOperator.ASC_ORDER, (Object)vRef));
            }
            order.getInputs().add(new MutableObject((Object)inputOp));
            order.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)order);
        }
        AbstractUnnestMapOperator primaryIndexUnnestMapOp = AccessMethodUtils.createPrimaryIndexUnnestMapOp(dataset, retainInput, retainMissing, requiresBroadcast, primaryKeyVars, primaryIndexUnnestVars, primaryIndexOutputTypes, sourceLoc, leftOuterMissingValue);
        if (requiresDistinct) {
            primaryIndexUnnestMapOp.getInputs().add(new MutableObject((Object)distinct));
        } else if (sortPrimaryKeys) {
            primaryIndexUnnestMapOp.getInputs().add(new MutableObject((Object)order));
        } else {
            primaryIndexUnnestMapOp.getInputs().add(new MutableObject((Object)inputOp));
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)primaryIndexUnnestMapOp);
        primaryIndexUnnestMapOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        return primaryIndexUnnestMapOp;
    }

    private static ILogicalOperator createFinalIndexOnlySearchPlan(List<Mutable<ILogicalOperator>> afterTopOpRefs, Mutable<ILogicalOperator> topOpRef, Mutable<ILogicalExpression> conditionRef, List<Mutable<ILogicalOperator>> assignsBeforeTopOpRef, Dataset dataset, ARecordType recordType, ARecordType metaRecordType, ILogicalOperator inputOp, IOptimizationContext context, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, Index secondaryIndex, AccessMethodAnalysisContext analysisCtx, OptimizableOperatorSubTree subTree, LogicalVariable newMissingPlaceHolderForLOJ, IAlgebricksConstantValue leftOuterMissingValue, List<LogicalVariable> pkVarsFromSIdxUnnestMapOp, List<LogicalVariable> primaryIndexUnnestVars, List<Object> primaryIndexOutputTypes, boolean anyRealTypeConvertedToIntegerType) throws AlgebricksException {
        ILogicalOperator assignBeforeTopOp;
        SourceLocation sourceLoc = inputOp.getSourceLocation();
        Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo = analysisCtx.getIndexOnlyPlanInfo();
        List<LogicalVariable> skVarsFromSIdxUnnestMap = AccessMethodUtils.getKeyVarsFromSecondaryUnnestMap(dataset, recordType, metaRecordType, inputOp, secondaryIndex, SecondaryUnnestMapOutputVarType.SECONDARY_KEY);
        boolean skFieldUsedAfterTopOp = (Boolean)indexOnlyPlanInfo.getSecond();
        boolean requireVerificationAfterSIdxSearch = (Boolean)indexOnlyPlanInfo.getThird();
        SplitOperator splitOp = null;
        ArrayList<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> unionVarMap = new ArrayList<Triple<LogicalVariable, LogicalVariable, LogicalVariable>>();
        ArrayList liveVarsAfterTopOp = new ArrayList();
        LinkedHashMap<LogicalVariable, LogicalVariable> origVarToSIdxUnnestMapOpVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        Index.ValueIndexDetails secondaryIndexDetails = (Index.ValueIndexDetails)secondaryIndex.getIndexDetails();
        List chosenIndexFieldNames = secondaryIndexDetails.getKeyFieldNames();
        DatasetConfig.IndexType idxType = secondaryIndex.getIndexType();
        ArrayList<LogicalVariable> usedVarsInTopOp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> uniqueUsedVarsInTopOp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> producedVarsInAssignsBeforeTopOp = new ArrayList<LogicalVariable>();
        ArrayList liveVarsInSubTreeRootOp = new ArrayList();
        ArrayList<LogicalVariable> usedVarsAfterTopOp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> varsTmpList = new ArrayList<LogicalVariable>();
        AssignOperator skVarAssignOpInRightPath = null;
        ArrayList<LogicalVariable> restoredSKVarFromRTree = null;
        LinkedHashMap<LogicalVariable, LogicalVariable> origSKFieldVarToNewSKFieldVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        if (idxType == DatasetConfig.IndexType.RTREE && (skFieldUsedAfterTopOp || requireVerificationAfterSIdxSearch)) {
            int optFieldIdx;
            IOptimizableFuncExpr optFuncExpr = AccessMethodUtils.chooseFirstOptFuncExpr(secondaryIndex, analysisCtx);
            Pair keyPairType = Index.getNonNullableOpenFieldType((Index)secondaryIndex, (IAType)optFuncExpr.getFieldType(optFieldIdx = AccessMethodUtils.chooseFirstOptFuncVar(secondaryIndex, analysisCtx)), optFuncExpr.getFieldName(optFieldIdx), (ARecordType)recordType);
            if (keyPairType == null) {
                return null;
            }
            IAType spatialType = (IAType)keyPairType.first;
            ArrayList<MutableObject> restoredSKFromRTreeExprs = new ArrayList<MutableObject>();
            restoredSKVarFromRTree = new ArrayList<LogicalVariable>();
            switch (spatialType.getTypeTag()) {
                case POINT: {
                    AbstractFunctionCallExpression createPointExpr = AccessMethodUtils.createPointExpression(skVarsFromSIdxUnnestMap, sourceLoc);
                    restoredSKVarFromRTree.add(context.newVar());
                    restoredSKFromRTreeExprs.add(new MutableObject((Object)createPointExpr));
                    skVarAssignOpInRightPath = new AssignOperator(restoredSKVarFromRTree, restoredSKFromRTreeExprs);
                    skVarAssignOpInRightPath.setSourceLocation(sourceLoc);
                    break;
                }
                case RECTANGLE: {
                    AbstractFunctionCallExpression expr1 = AccessMethodUtils.createPointExpression(skVarsFromSIdxUnnestMap.subList(0, 2), sourceLoc);
                    AbstractFunctionCallExpression expr2 = AccessMethodUtils.createPointExpression(skVarsFromSIdxUnnestMap.subList(2, 4), sourceLoc);
                    AbstractFunctionCallExpression createRectangleExpr = AccessMethodUtils.createRectangleExpression(expr1, expr2);
                    restoredSKVarFromRTree.add(context.newVar());
                    restoredSKFromRTreeExprs.add(new MutableObject((Object)createRectangleExpr));
                    skVarAssignOpInRightPath = new AssignOperator(restoredSKVarFromRTree, restoredSKFromRTreeExprs);
                    skVarAssignOpInRightPath.setSourceLocation(sourceLoc);
                    break;
                }
            }
        }
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)subTree.getRootRef().getValue()), liveVarsInSubTreeRootOp);
        VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)topOpRef.getValue()), usedVarsInTopOp);
        Iterator iterator = usedVarsInTopOp.iterator();
        while (iterator.hasNext()) {
            LogicalVariable v = (LogicalVariable)iterator.next();
            if (liveVarsInSubTreeRootOp.contains(v)) continue;
            iterator.remove();
        }
        AccessMethodUtils.copyVarsToAnotherList(usedVarsInTopOp, uniqueUsedVarsInTopOp);
        if (assignsBeforeTopOpRef != null && !assignsBeforeTopOpRef.isEmpty()) {
            for (int i = 0; i < assignsBeforeTopOpRef.size(); ++i) {
                assignBeforeTopOp = (ILogicalOperator)assignsBeforeTopOpRef.get(i).getValue();
                varsTmpList.clear();
                VariableUtilities.getProducedVariables((ILogicalOperator)assignBeforeTopOp, varsTmpList);
                AccessMethodUtils.copyVarsToAnotherList(varsTmpList, producedVarsInAssignsBeforeTopOp);
            }
        }
        AssignOperator constAssignOp = null;
        ILogicalOperator currentOpAfterTopOp = null;
        ArrayList<LogicalVariable> constAssignVars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable> constAssignExprs = new ArrayList<Mutable>();
        ILogicalOperator currentOp = inputOp;
        boolean constantAssignVarUsedInTopOp = false;
        if (assignsBeforeTopOpRef != null) {
            for (int i = assignsBeforeTopOpRef.size() - 1; i >= 0; --i) {
                AssignOperator tmpOp = (AssignOperator)assignsBeforeTopOpRef.get(i).getValue();
                List tmpAssignVars = tmpOp.getVariables();
                List tmpAsssignExprs = tmpOp.getExpressions();
                Iterator varIt = tmpAssignVars.iterator();
                Iterator exprIt = tmpAsssignExprs.iterator();
                boolean changed = false;
                while (exprIt.hasNext()) {
                    Mutable tmpExpr = (Mutable)exprIt.next();
                    LogicalVariable tmpVar = (LogicalVariable)varIt.next();
                    if (((ILogicalExpression)tmpExpr.getValue()).getExpressionTag() != LogicalExpressionTag.CONSTANT) continue;
                    constAssignVars.add(tmpVar);
                    constAssignExprs.add(tmpExpr);
                    varIt.remove();
                    exprIt.remove();
                    changed = true;
                }
                if (!changed) continue;
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)tmpOp);
            }
            if (!constAssignVars.isEmpty()) {
                for (LogicalVariable v : constAssignVars) {
                    if (!usedVarsInTopOp.contains(v)) continue;
                    constantAssignVarUsedInTopOp = true;
                    break;
                }
                constAssignOp = new AssignOperator(constAssignVars, constAssignExprs);
                constAssignOp.setSourceLocation(sourceLoc);
                if (constantAssignVarUsedInTopOp) {
                    constAssignOp.getInputs().add(new MutableObject((Object)inputOp));
                    constAssignOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)constAssignOp);
                    currentOp = constAssignOp;
                }
            }
        }
        HashSet<LogicalVariable> varsTmpSet = new HashSet<LogicalVariable>();
        if (afterTopOpRefs != null) {
            for (Mutable<ILogicalOperator> afterTopOpRef : afterTopOpRefs) {
                varsTmpSet.clear();
                OperatorPropertiesUtil.getFreeVariablesInOp((ILogicalOperator)((ILogicalOperator)afterTopOpRef.getValue()), varsTmpSet);
                AccessMethodUtils.copyVarsToAnotherList(varsTmpSet, usedVarsAfterTopOp);
            }
        }
        List<LogicalVariable> condSplitVars = AccessMethodUtils.getKeyVarsFromSecondaryUnnestMap(dataset, recordType, metaRecordType, inputOp, secondaryIndex, SecondaryUnnestMapOutputVarType.CONDITIONAL_SPLIT_VAR);
        splitOp = new SplitOperator(2, (Mutable)new MutableObject((Object)new VariableReferenceExpression(condSplitVars.get(0))));
        splitOp.setSourceLocation(sourceLoc);
        splitOp.getInputs().add(new MutableObject((Object)currentOp));
        splitOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)splitOp);
        LinkedHashMap<LogicalVariable, LogicalVariable> liveVarAfterSplitToLeftPathMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        LinkedHashMap<LogicalVariable, LogicalVariable> origPKRecAndSKVarToleftPathMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        LinkedHashMap<LogicalVariable, LogicalVariable> origVarToOutputVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        ArrayList liveVarsAfterSplitOp = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)splitOp, liveVarsAfterSplitOp);
        ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>();
        for (LogicalVariable v : liveVarsAfterSplitOp) {
            LogicalVariable newVar = context.newVar();
            liveVarAfterSplitToLeftPathMap.put(v, newVar);
            assignVars.add(newVar);
            VariableReferenceExpression vRef = new VariableReferenceExpression(v);
            vRef.setSourceLocation(sourceLoc);
            assignExprs.add(new MutableObject((Object)vRef));
        }
        AssignOperator origVarsToLeftPathVarsAssignOp = new AssignOperator(assignVars, assignExprs);
        origVarsToLeftPathVarsAssignOp.setSourceLocation(sourceLoc);
        origVarsToLeftPathVarsAssignOp.getInputs().add(new MutableObject((Object)splitOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)origVarsToLeftPathVarsAssignOp);
        origVarsToLeftPathVarsAssignOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        ArrayList<LogicalVariable> pkVarsInLeftPathFromSIdxSearchBeforeSplit = new ArrayList<LogicalVariable>();
        for (LogicalVariable v : pkVarsFromSIdxUnnestMapOp) {
            pkVarsInLeftPathFromSIdxSearchBeforeSplit.add((LogicalVariable)liveVarAfterSplitToLeftPathMap.get(v));
        }
        ArrayList<LogicalVariable> pkVarsFromPIdxSearchInLeftPath = new ArrayList<LogicalVariable>();
        for (int i = 0; i < primaryIndexUnnestVars.size(); ++i) {
            LogicalVariable logicalVariable = context.newVar();
            pkVarsFromPIdxSearchInLeftPath.add(logicalVariable);
            origPKRecAndSKVarToleftPathMap.put(primaryIndexUnnestVars.get(i), logicalVariable);
        }
        for (LogicalVariable logicalVariable : usedVarsAfterTopOp) {
            int n;
            if (AccessMethodUtils.findVarInTripleVarList(unionVarMap, logicalVariable, false) || !primaryIndexUnnestVars.contains(logicalVariable) || (n = primaryIndexUnnestVars.indexOf(logicalVariable)) == -1) continue;
            unionVarMap.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)new Triple((Object)((LogicalVariable)pkVarsFromPIdxSearchInLeftPath.get(n)), (Object)pkVarsFromSIdxUnnestMapOp.get(n), (Object)logicalVariable));
            origVarToOutputVarMap.put(pkVarsFromSIdxUnnestMapOp.get(n), logicalVariable);
            origVarToSIdxUnnestMapOpVarMap.put(logicalVariable, pkVarsFromSIdxUnnestMapOp.get(n));
        }
        for (LogicalVariable logicalVariable : usedVarsAfterTopOp) {
            LogicalVariable replacedVar;
            int n;
            if (AccessMethodUtils.findVarInTripleVarList(unionVarMap, logicalVariable, false) || !usedVarsInTopOp.contains(logicalVariable) && !producedVarsInAssignsBeforeTopOp.contains(logicalVariable) || (n = chosenIndexFieldNames.indexOf(subTree.getVarsToFieldNameMap().get(logicalVariable))) == -1) continue;
            if (idxType == DatasetConfig.IndexType.RTREE) {
                if (!skFieldUsedAfterTopOp && !requireVerificationAfterSIdxSearch) continue;
                replacedVar = context.newVar();
                origPKRecAndSKVarToleftPathMap.put(logicalVariable, replacedVar);
                origSKFieldVarToNewSKFieldVarMap.put(logicalVariable, (LogicalVariable)restoredSKVarFromRTree.get(n));
                unionVarMap.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)new Triple((Object)replacedVar, (Object)((LogicalVariable)restoredSKVarFromRTree.get(n)), (Object)logicalVariable));
                continue;
            }
            replacedVar = context.newVar();
            origPKRecAndSKVarToleftPathMap.put(logicalVariable, replacedVar);
            origVarToOutputVarMap.put(skVarsFromSIdxUnnestMap.get(n), logicalVariable);
            unionVarMap.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)new Triple((Object)replacedVar, (Object)skVarsFromSIdxUnnestMap.get(n), (Object)logicalVariable));
            origVarToSIdxUnnestMapOpVarMap.put(logicalVariable, skVarsFromSIdxUnnestMap.get(n));
        }
        ArrayList<LogicalVariable> varsUsedInTopOpButNotAfterwards = new ArrayList<LogicalVariable>();
        AccessMethodUtils.copyVarsToAnotherList(uniqueUsedVarsInTopOp, varsUsedInTopOpButNotAfterwards);
        varsUsedInTopOpButNotAfterwards.removeAll(usedVarsAfterTopOp);
        if (idxType == DatasetConfig.IndexType.BTREE) {
            for (LogicalVariable logicalVariable : varsUsedInTopOpButNotAfterwards) {
                int sIndexIdx = chosenIndexFieldNames.indexOf(subTree.getVarsToFieldNameMap().get(logicalVariable));
                if (sIndexIdx == -1) continue;
                LogicalVariable replacedVar = context.newVar();
                origPKRecAndSKVarToleftPathMap.put(logicalVariable, replacedVar);
                origVarToOutputVarMap.put(skVarsFromSIdxUnnestMap.get(sIndexIdx), logicalVariable);
                origVarToSIdxUnnestMapOpVarMap.put(logicalVariable, skVarsFromSIdxUnnestMap.get(sIndexIdx));
            }
        }
        if (idxType == DatasetConfig.IndexType.RTREE && (skFieldUsedAfterTopOp || requireVerificationAfterSIdxSearch)) {
            for (LogicalVariable logicalVariable : uniqueUsedVarsInTopOp) {
                if (primaryIndexUnnestVars.contains(logicalVariable)) continue;
                origSKFieldVarToNewSKFieldVarMap.put(logicalVariable, (LogicalVariable)restoredSKVarFromRTree.get(0));
            }
        }
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)topOpRef.getValue()), liveVarsAfterTopOp);
        for (LogicalVariable logicalVariable : usedVarsAfterTopOp) {
            if (!liveVarsAfterTopOp.contains(logicalVariable) || AccessMethodUtils.findVarInTripleVarList(unionVarMap, logicalVariable, false)) continue;
            LogicalVariable outputVar = context.newVar();
            origVarToOutputVarMap.put(logicalVariable, outputVar);
            unionVarMap.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)new Triple((Object)((LogicalVariable)liveVarAfterSplitToLeftPathMap.get(logicalVariable)), (Object)logicalVariable, (Object)outputVar));
        }
        if (afterTopOpRefs != null) {
            for (Mutable<ILogicalOperator> mutable : afterTopOpRefs) {
                VariableUtilities.substituteVariables((ILogicalOperator)((ILogicalOperator)mutable.getValue()), origVarToOutputVarMap, (ITypingContext)context);
            }
        }
        AbstractUnnestMapOperator abstractUnnestMapOperator = AccessMethodUtils.createPrimaryIndexUnnestMapOp(dataset, retainInput, retainMissing, requiresBroadcast, pkVarsInLeftPathFromSIdxSearchBeforeSplit, pkVarsFromPIdxSearchInLeftPath, primaryIndexOutputTypes, sourceLoc, leftOuterMissingValue);
        abstractUnnestMapOperator.setSourceLocation(sourceLoc);
        abstractUnnestMapOperator.getInputs().add(new MutableObject((Object)origVarsToLeftPathVarsAssignOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)abstractUnnestMapOperator);
        abstractUnnestMapOperator.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        LinkedHashMap<LogicalVariable, LogicalVariable> linkedHashMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        linkedHashMap.putAll(liveVarAfterSplitToLeftPathMap);
        linkedHashMap.putAll(origPKRecAndSKVarToleftPathMap);
        ILogicalExpression conditionRefExpr = ((ILogicalExpression)conditionRef.getValue()).cloneExpression();
        LogicalVariable newMissingPlaceHolderVar = retainMissing ? newMissingPlaceHolderForLOJ : null;
        SelectOperator newSelectOpInLeftPath = retainMissing ? new SelectOperator((Mutable)new MutableObject((Object)conditionRefExpr), leftOuterMissingValue, newMissingPlaceHolderVar) : new SelectOperator((Mutable)new MutableObject((Object)conditionRefExpr));
        newSelectOpInLeftPath.setSourceLocation(conditionRefExpr.getSourceLocation());
        VariableUtilities.substituteVariables((ILogicalOperator)newSelectOpInLeftPath, linkedHashMap, (ITypingContext)context);
        if (assignsBeforeTopOpRef != null) {
            assignBeforeTopOp = (ILogicalOperator)assignsBeforeTopOpRef.get(assignsBeforeTopOpRef.size() - 1).getValue();
            assignBeforeTopOp.getInputs().clear();
            assignBeforeTopOp.getInputs().add(new MutableObject((Object)abstractUnnestMapOperator));
            for (int i = assignsBeforeTopOpRef.size() - 1; i >= 0; --i) {
                if (assignsBeforeTopOpRef.get(i) == null) continue;
                AbstractLogicalOperator assignTmpOp = (AbstractLogicalOperator)assignsBeforeTopOpRef.get(i).getValue();
                assignTmpOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
                VariableUtilities.substituteVariables((ILogicalOperator)assignTmpOp, linkedHashMap, (ITypingContext)context);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignTmpOp);
            }
            newSelectOpInLeftPath.getInputs().clear();
            newSelectOpInLeftPath.getInputs().add(new MutableObject((Object)((ILogicalOperator)assignsBeforeTopOpRef.get(0).getValue())));
        } else {
            newSelectOpInLeftPath.getInputs().add(new MutableObject((Object)abstractUnnestMapOperator));
        }
        newSelectOpInLeftPath.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newSelectOpInLeftPath);
        SplitOperator currentTopOpInRightPath = splitOp;
        if (skVarAssignOpInRightPath != null) {
            skVarAssignOpInRightPath.getInputs().add(new MutableObject((Object)splitOp));
            skVarAssignOpInRightPath.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)skVarAssignOpInRightPath);
            currentTopOpInRightPath = skVarAssignOpInRightPath;
        }
        if ((idxType == DatasetConfig.IndexType.RTREE || uniqueUsedVarsInTopOp.size() > 1) && requireVerificationAfterSIdxSearch || anyRealTypeConvertedToIntegerType) {
            ILogicalExpression conditionRefExpr2 = ((ILogicalExpression)conditionRef.getValue()).cloneExpression();
            SelectOperator newSelectOpInRightPath = retainMissing ? new SelectOperator((Mutable)new MutableObject((Object)conditionRefExpr2), leftOuterMissingValue, newMissingPlaceHolderVar) : new SelectOperator((Mutable)new MutableObject((Object)conditionRefExpr2));
            newSelectOpInRightPath.setSourceLocation(conditionRefExpr2.getSourceLocation());
            newSelectOpInRightPath.getInputs().add(new MutableObject((Object)currentTopOpInRightPath));
            VariableUtilities.substituteVariables((ILogicalOperator)newSelectOpInRightPath, origVarToSIdxUnnestMapOpVarMap, (ITypingContext)context);
            VariableUtilities.substituteVariables((ILogicalOperator)newSelectOpInRightPath, origSKFieldVarToNewSKFieldVarMap, (ITypingContext)context);
            newSelectOpInRightPath.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newSelectOpInRightPath);
            currentTopOpInRightPath = newSelectOpInRightPath;
        }
        if (retainMissing && newMissingPlaceHolderForLOJ == primaryIndexUnnestVars.get(0) && !AccessMethodUtils.findVarInTripleVarList(unionVarMap, newMissingPlaceHolderForLOJ, false)) {
            unionVarMap.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)new Triple((Object)((LogicalVariable)origPKRecAndSKVarToleftPathMap.get(newMissingPlaceHolderForLOJ)), (Object)pkVarsFromSIdxUnnestMapOp.get(0), (Object)newMissingPlaceHolderForLOJ));
        }
        UnionAllOperator unionAllOp = new UnionAllOperator(unionVarMap);
        unionAllOp.setSourceLocation(sourceLoc);
        unionAllOp.getInputs().add(new MutableObject((Object)newSelectOpInLeftPath));
        unionAllOp.getInputs().add(new MutableObject((Object)currentTopOpInRightPath));
        unionAllOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionAllOp);
        if (!constAssignVars.isEmpty() && !constantAssignVarUsedInTopOp) {
            constAssignOp.getInputs().clear();
            constAssignOp.getInputs().add(new MutableObject((Object)unionAllOp));
            constAssignOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)constAssignOp);
            currentOpAfterTopOp = (ILogicalOperator)afterTopOpRefs.get(afterTopOpRefs.size() - 1).getValue();
            currentOpAfterTopOp.getInputs().clear();
            currentOpAfterTopOp.getInputs().add(new MutableObject((Object)constAssignOp));
            context.computeAndSetTypeEnvironmentForOperator(currentOpAfterTopOp);
            afterTopOpRefs.add((Mutable<ILogicalOperator>)new MutableObject((Object)constAssignOp));
        }
        return unionAllOp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractUnnestMapOperator createPrimaryIndexUnnestMapOp(Dataset dataset, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, List<LogicalVariable> primaryKeyVars, List<LogicalVariable> primaryIndexUnnestVars, List<Object> primaryIndexOutputTypes, SourceLocation sourceLoc, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        UnnestMapOperator primaryIndexUnnestMapOp;
        ArrayList<Mutable<ILogicalExpression>> primaryIndexFuncArgs = new ArrayList<Mutable<ILogicalExpression>>();
        BTreeJobGenParams jobGenParams = new BTreeJobGenParams(dataset.getDatasetName(), DatasetConfig.IndexType.BTREE, dataset.getDataverseName(), dataset.getDatasetName(), retainInput, requiresBroadcast);
        jobGenParams.setLowKeyInclusive(true);
        jobGenParams.setHighKeyInclusive(true);
        jobGenParams.setLowKeyVarList(primaryKeyVars, 0, primaryKeyVars.size());
        jobGenParams.setHighKeyVarList(primaryKeyVars, 0, primaryKeyVars.size());
        jobGenParams.setIsEqCondition(true);
        jobGenParams.writeToFuncArgs(primaryIndexFuncArgs);
        BuiltinFunctionInfo primaryIndexSearch = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.INDEX_SEARCH);
        ScalarFunctionCallExpression primaryIndexSearchFunc = new ScalarFunctionCallExpression((IFunctionInfo)primaryIndexSearch, primaryIndexFuncArgs);
        primaryIndexSearchFunc.setSourceLocation(sourceLoc);
        if (retainMissing) {
            if (!retainInput) throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Left-outer-join should propagate all inputs from the outer branch."});
            primaryIndexUnnestMapOp = new LeftOuterUnnestMapOperator(primaryIndexUnnestVars, (Mutable)new MutableObject((Object)primaryIndexSearchFunc), primaryIndexOutputTypes, leftOuterMissingValue);
            primaryIndexUnnestMapOp.setSourceLocation(sourceLoc);
            return primaryIndexUnnestMapOp;
        } else {
            primaryIndexUnnestMapOp = new UnnestMapOperator(primaryIndexUnnestVars, (Mutable)new MutableObject((Object)primaryIndexSearchFunc), primaryIndexOutputTypes, retainInput);
            primaryIndexUnnestMapOp.setSourceLocation(sourceLoc);
        }
        return primaryIndexUnnestMapOp;
    }

    public static ILogicalOperator createRestOfIndexSearchPlan(List<Mutable<ILogicalOperator>> afterTopOpRefs, Mutable<ILogicalOperator> topOpRef, Mutable<ILogicalExpression> conditionRef, List<Mutable<ILogicalOperator>> assignsBeforeTopOpRef, AbstractDataSourceOperator dataSourceOp, Dataset dataset, ARecordType recordType, ARecordType metaRecordType, ILogicalOperator inputOp, IOptimizationContext context, boolean sortPrimaryKeys, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, Index secondaryIndex, AccessMethodAnalysisContext analysisCtx, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, LogicalVariable newMissingPlaceHolderForLOJ, IAlgebricksConstantValue leftOuterMissingValue, boolean anyRealTypeConvertedToIntegerType) throws AlgebricksException {
        boolean isArrayIndex;
        ArrayList<LogicalVariable> primaryIndexUnnestVars = new ArrayList<LogicalVariable>();
        ArrayList<Object> primaryIndexOutputTypes = new ArrayList<Object>();
        primaryIndexUnnestVars.addAll(dataSourceOp.getVariables());
        AccessMethodUtils.appendPrimaryIndexTypes(dataset, (IAType)recordType, (IAType)metaRecordType, primaryIndexOutputTypes);
        List<LogicalVariable> pkVarsFromSIdxUnnestMapOp = AccessMethodUtils.getKeyVarsFromSecondaryUnnestMap(dataset, recordType, metaRecordType, inputOp, secondaryIndex, SecondaryUnnestMapOutputVarType.PRIMARY_KEY);
        boolean isIndexOnlyPlan = (Boolean)analysisCtx.getIndexOnlyPlanInfo().getFirst();
        boolean bl = isArrayIndex = secondaryIndex.getIndexType() == DatasetConfig.IndexType.ARRAY;
        if (!isIndexOnlyPlan) {
            List<LogicalVariable> joinPKVars;
            if (isArrayIndex && probeSubTree != null) {
                ILogicalOperator probeRoot = probeSubTree.getRoot();
                Triple<Set<LogicalVariable>, ILogicalOperator, FunctionalDependency> primaryKeyOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(probeRoot, false, context);
                joinPKVars = new ArrayList((Collection)primaryKeyOpAndVars.first);
                if (primaryKeyOpAndVars.third != null) {
                    context.addPrimaryKey((FunctionalDependency)primaryKeyOpAndVars.third);
                }
                if (primaryKeyOpAndVars.second != null) {
                    MutableObject assignIdOpRef = new MutableObject((Object)((ILogicalOperator)primaryKeyOpAndVars.second));
                    OperatorManipulationUtil.substituteOpInInput((ILogicalOperator)((ILogicalOperator)topOpRef.getValue()), (ILogicalOperator)probeRoot, (Mutable)assignIdOpRef);
                    OperatorManipulationUtil.substituteOpInInput((ILogicalOperator)inputOp, (ILogicalOperator)probeRoot, (Mutable)assignIdOpRef);
                    probeSubTree.setRoot((ILogicalOperator)primaryKeyOpAndVars.second);
                    probeSubTree.setRootRef((Mutable<ILogicalOperator>)assignIdOpRef);
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)primaryKeyOpAndVars.second);
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)topOpRef.getValue());
                }
            } else {
                joinPKVars = Collections.emptyList();
            }
            return AccessMethodUtils.createFinalNonIndexOnlySearchPlan(dataset, inputOp, context, !isArrayIndex && sortPrimaryKeys, retainInput, retainMissing, requiresBroadcast, isArrayIndex, pkVarsFromSIdxUnnestMapOp, primaryIndexUnnestVars, joinPKVars, primaryIndexOutputTypes, leftOuterMissingValue);
        }
        if (!isArrayIndex) {
            return AccessMethodUtils.createFinalIndexOnlySearchPlan(afterTopOpRefs, topOpRef, conditionRef, assignsBeforeTopOpRef, dataset, recordType, metaRecordType, inputOp, context, retainInput, retainMissing, requiresBroadcast, secondaryIndex, analysisCtx, indexSubTree, newMissingPlaceHolderForLOJ, leftOuterMissingValue, pkVarsFromSIdxUnnestMapOp, primaryIndexUnnestVars, primaryIndexOutputTypes, anyRealTypeConvertedToIntegerType);
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, inputOp.getSourceLocation(), new Serializable[]{"Cannot use index-only plan with array indexes."});
    }

    private static AbstractFunctionCallExpression createPointExpression(List<LogicalVariable> pointVars, SourceLocation sourceLoc) {
        ArrayList<MutableObject> expressions = new ArrayList<MutableObject>();
        ScalarFunctionCallExpression createPointExpr1 = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_POINT));
        createPointExpr1.setSourceLocation(sourceLoc);
        VariableReferenceExpression pointVarRef0 = new VariableReferenceExpression(pointVars.get(0));
        pointVarRef0.setSourceLocation(sourceLoc);
        expressions.add(new MutableObject((Object)pointVarRef0));
        VariableReferenceExpression pointVarRef1 = new VariableReferenceExpression(pointVars.get(1));
        pointVarRef1.setSourceLocation(sourceLoc);
        expressions.add(new MutableObject((Object)pointVarRef1));
        createPointExpr1.getArguments().addAll(expressions);
        return createPointExpr1;
    }

    private static AbstractFunctionCallExpression createRectangleExpression(AbstractFunctionCallExpression createPointExpr1, AbstractFunctionCallExpression createPointExpr2) {
        ArrayList<MutableObject> expressions = new ArrayList<MutableObject>();
        ScalarFunctionCallExpression createRectangleExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_RECTANGLE));
        createRectangleExpr.setSourceLocation(createPointExpr1.getSourceLocation());
        expressions.add(new MutableObject((Object)createPointExpr1));
        expressions.add(new MutableObject((Object)createPointExpr2));
        createRectangleExpr.getArguments().addAll(expressions);
        return createRectangleExpr;
    }

    private static ScalarFunctionCallExpression getNestedIsMissingNullCall(AbstractFunctionCallExpression call, OptimizableOperatorSubTree rightSubTree, FunctionIdentifier funId) throws AlgebricksException {
        ScalarFunctionCallExpression isMissingNullFuncExpr;
        if (call.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.NOT) && ((ILogicalExpression)((Mutable)call.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((AbstractFunctionCallExpression)((Mutable)call.getArguments().get(0)).getValue()).getFunctionIdentifier().equals((Object)funId) && ((ILogicalExpression)((Mutable)(isMissingNullFuncExpr = (ScalarFunctionCallExpression)((Mutable)call.getArguments().get(0)).getValue()).getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            LogicalVariable var = ((VariableReferenceExpression)((Mutable)isMissingNullFuncExpr.getArguments().get(0)).getValue()).getVariableReference();
            ArrayList liveSubplanVars = new ArrayList();
            VariableUtilities.getSubplanLocalLiveVariables((ILogicalOperator)rightSubTree.getRoot(), liveSubplanVars);
            if (liveSubplanVars.contains(var)) {
                return isMissingNullFuncExpr;
            }
        }
        return null;
    }

    public static ScalarFunctionCallExpression findIsMissingNullInSubplan(AbstractLogicalOperator inputOp, OptimizableOperatorSubTree rightSubTree, FunctionIdentifier funId) throws AlgebricksException {
        ScalarFunctionCallExpression isMissingNullFuncExpr = null;
        AbstractLogicalOperator currentOp = inputOp;
        while (currentOp != null) {
            if (currentOp.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selectOp = (SelectOperator)currentOp;
                if (((ILogicalExpression)selectOp.getCondition().getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                    AbstractFunctionCallExpression call = (AbstractFunctionCallExpression)selectOp.getCondition().getValue();
                    if (call.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
                        for (Mutable mexpr : call.getArguments()) {
                            if (((ILogicalExpression)mexpr.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (isMissingNullFuncExpr = AccessMethodUtils.getNestedIsMissingNullCall((AbstractFunctionCallExpression)mexpr.getValue(), rightSubTree, funId)) == null) continue;
                            return isMissingNullFuncExpr;
                        }
                    }
                    if ((isMissingNullFuncExpr = AccessMethodUtils.getNestedIsMissingNullCall(call, rightSubTree, funId)) != null) {
                        return isMissingNullFuncExpr;
                    }
                }
            } else if (currentOp.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans nestedPlanOp = (AbstractOperatorWithNestedPlans)currentOp;
                for (ILogicalPlan nestedPlan : nestedPlanOp.getNestedPlans()) {
                    for (Mutable root : nestedPlan.getRoots()) {
                        isMissingNullFuncExpr = AccessMethodUtils.findIsMissingNullInSubplan((AbstractLogicalOperator)root.getValue(), rightSubTree, funId);
                        if (isMissingNullFuncExpr == null) continue;
                        return isMissingNullFuncExpr;
                    }
                }
            }
            currentOp = currentOp.getInputs().isEmpty() ? null : (AbstractLogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        return isMissingNullFuncExpr;
    }

    public static ScalarFunctionCallExpression findLOJIsMissingNullFuncInGroupBy(GroupByOperator lojGroupbyOp, OptimizableOperatorSubTree rightSubTree, FunctionIdentifier funId) throws AlgebricksException {
        ALogicalPlanImpl subPlan = (ALogicalPlanImpl)lojGroupbyOp.getNestedPlans().get(0);
        Mutable subPlanRootOpRef = (Mutable)subPlan.getRoots().get(0);
        AbstractLogicalOperator subPlanRootOp = (AbstractLogicalOperator)subPlanRootOpRef.getValue();
        return AccessMethodUtils.findIsMissingNullInSubplan(subPlanRootOp, rightSubTree, funId);
    }

    public static void resetLOJMissingNullPlaceholderVarInGroupByOp(AccessMethodAnalysisContext analysisCtx, LogicalVariable newMissingNullPlaceholderVaraible, IOptimizationContext context) throws AlgebricksException {
        ScalarFunctionCallExpression isMissingNullFuncExpr = analysisCtx.getLOJIsMissingNullFuncInSpecialGroupBy();
        isMissingNullFuncExpr.getArguments().clear();
        VariableReferenceExpression newMissingNullVarRef = new VariableReferenceExpression(newMissingNullPlaceholderVaraible);
        newMissingNullVarRef.setSourceLocation(isMissingNullFuncExpr.getSourceLocation());
        isMissingNullFuncExpr.getArguments().add(new MutableObject((Object)newMissingNullVarRef));
        OperatorPropertiesUtil.typeOpRec(analysisCtx.getLOJSpecialGroupByOpRef(), (IOptimizationContext)context);
    }

    private static void appendExternalRecTypes(IAType itemType, List<Object> target) {
        target.add(AUnionType.createUnknownableType((IAType)itemType));
    }

    private static void appendExternalRecPrimaryKeys(Dataset dataset, List<Object> target) throws AlgebricksException {
        int numPrimaryKeys = IndexingConstants.getRIDSize((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties());
        for (int i = 0; i < numPrimaryKeys; ++i) {
            target.add(IndexingConstants.getFieldType((int)i));
        }
    }

    private static void writeVarList(List<LogicalVariable> varList, List<Mutable<ILogicalExpression>> funcArgs) {
        MutableObject numKeysRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(varList.size()))));
        funcArgs.add((Mutable<ILogicalExpression>)numKeysRef);
        for (LogicalVariable keyVar : varList) {
            MutableObject keyVarRef = new MutableObject((Object)new VariableReferenceExpression(keyVar));
            funcArgs.add((Mutable<ILogicalExpression>)keyVarRef);
        }
    }

    private static void addStringArg(String argument, List<Mutable<ILogicalExpression>> funcArgs) {
        MutableObject stringRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(argument))));
        funcArgs.add((Mutable<ILogicalExpression>)stringRef);
    }

    public static UnnestMapOperator createExternalDataLookupUnnestMap(AbstractDataSourceOperator dataSourceOp, Dataset dataset, ARecordType recordType, ARecordType metaRecordType, ILogicalOperator inputOp, IOptimizationContext context, Index secondaryIndex, boolean retainInput, boolean retainNull) throws AlgebricksException {
        SourceLocation sourceLoc = inputOp.getSourceLocation();
        List<LogicalVariable> primaryKeyVars = AccessMethodUtils.getKeyVarsFromSecondaryUnnestMap(dataset, recordType, metaRecordType, inputOp, secondaryIndex, SecondaryUnnestMapOutputVarType.PRIMARY_KEY);
        OrderOperator order = new OrderOperator();
        order.setSourceLocation(sourceLoc);
        for (LogicalVariable pkVar : primaryKeyVars) {
            VariableReferenceExpression pkVarRef = new VariableReferenceExpression(pkVar);
            pkVarRef.setSourceLocation(sourceLoc);
            MutableObject vRef = new MutableObject((Object)pkVarRef);
            order.getOrderExpressions().add(new Pair((Object)OrderOperator.ASC_ORDER, (Object)vRef));
        }
        order.getInputs().add(new MutableObject((Object)inputOp));
        order.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)order);
        ArrayList<Mutable<ILogicalExpression>> externalLookupArgs = new ArrayList<Mutable<ILogicalExpression>>();
        AccessMethodUtils.addStringArg(dataset.getDataverseName().getCanonicalForm(), externalLookupArgs);
        AccessMethodUtils.addStringArg(dataset.getDatasetName(), externalLookupArgs);
        AccessMethodUtils.writeVarList(primaryKeyVars, externalLookupArgs);
        ArrayList externalUnnestVars = new ArrayList();
        ArrayList<Object> outputTypes = new ArrayList<Object>();
        externalUnnestVars.addAll(dataSourceOp.getVariables());
        AccessMethodUtils.appendExternalRecTypes((IAType)recordType, outputTypes);
        BuiltinFunctionInfo externalLookup = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.EXTERNAL_LOOKUP);
        ScalarFunctionCallExpression externalLookupFunc = new ScalarFunctionCallExpression((IFunctionInfo)externalLookup, externalLookupArgs);
        externalLookupFunc.setSourceLocation(sourceLoc);
        UnnestMapOperator unnestOp = new UnnestMapOperator(externalUnnestVars, (Mutable)new MutableObject((Object)externalLookupFunc), outputTypes, retainInput);
        unnestOp.setSourceLocation(sourceLoc);
        unnestOp.getInputs().add(new MutableObject((Object)order));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestOp);
        unnestOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
        DataSourceId dataSourceId = new DataSourceId(dataset.getDataverseName(), dataset.getDatasetName());
        unnestOp.setPhysicalOperator((IPhysicalOperator)new ExternalDataLookupPOperator(dataSourceId, dataset, recordType, primaryKeyVars, false, retainInput, retainNull));
        return unnestOp;
    }

    public static IAType constantRuntimeResultType(ILogicalExpression expr, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        HashSet usedVariables = new HashSet();
        expr.getUsedVariables(usedVariables);
        if (usedVariables.size() > 0) {
            return null;
        }
        return (IAType)context.getExpressionTypeComputer().getType(expr, context.getMetadataProvider(), typeEnvironment);
    }

    public static boolean retainInputs(List<LogicalVariable> dataSourceVariables, ILogicalOperator sourceOp, List<Mutable<ILogicalOperator>> afterSelectRefs) throws AlgebricksException {
        ArrayList usedVars = new ArrayList();
        ArrayList producedVars = new ArrayList();
        ArrayList liveVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)sourceOp, liveVars);
        for (Mutable<ILogicalOperator> opMutable : afterSelectRefs) {
            ILogicalOperator op = (ILogicalOperator)opMutable.getValue();
            VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVars);
            VariableUtilities.getProducedVariables((ILogicalOperator)op, producedVars);
        }
        usedVars.removeAll(producedVars);
        usedVars.removeAll(dataSourceVariables);
        usedVars.retainAll(liveVars);
        return !usedVars.isEmpty();
    }

    public static Pair<Boolean, Boolean> canFunctionGenerateFalsePositiveResultsUsingIndex(AbstractFunctionCallExpression funcExpr, List<Pair<FunctionIdentifier, Boolean>> funcIdents) {
        boolean requireVerificationAfterSIdxSearch = true;
        FunctionIdentifier argFuncIdent = funcExpr.getFunctionIdentifier();
        boolean functionFound = false;
        for (int i = 0; i < funcIdents.size(); ++i) {
            if (!argFuncIdent.equals(funcIdents.get((int)i).first)) continue;
            functionFound = true;
            requireVerificationAfterSIdxSearch = (Boolean)funcIdents.get((int)i).second;
            break;
        }
        if (!functionFound) {
            block1: for (Mutable arg : funcExpr.getArguments()) {
                ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
                if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
                FunctionIdentifier argExprFuncIdent = argFuncExpr.getFunctionIdentifier();
                for (int i = 0; i < funcIdents.size(); ++i) {
                    if (!argExprFuncIdent.equals(funcIdents.get((int)i).first)) continue;
                    functionFound = true;
                    requireVerificationAfterSIdxSearch = (Boolean)funcIdents.get((int)i).second;
                    continue block1;
                }
            }
        }
        return new Pair((Object)functionFound, (Object)requireVerificationAfterSIdxSearch);
    }

    public static void indexOnlyPlanCheck(List<Mutable<ILogicalOperator>> afterTopRefs, Mutable<ILogicalOperator> topRef, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo) throws AlgebricksException {
        boolean rTreeCheck;
        boolean doesSIdxSearchCoverAllPredicates;
        boolean noIndexOnlyPlanOption;
        Dataset dataset = indexSubTree.getDataset();
        boolean bl = noIndexOnlyPlanOption = !context.getPhysicalOptimizationConfig().isIndexOnly();
        if (noIndexOnlyPlanOption || dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL || chosenIndex.isPrimaryIndex() || chosenIndex.getIndexDetails().isOverridingKeyFieldTypes() || chosenIndex.isEnforced() || AccessMethodUtils.isInvertedIndex(chosenIndex) || chosenIndex.getIndexType() == DatasetConfig.IndexType.ARRAY || IndexUtil.includesUnknowns((Index)chosenIndex)) {
            indexOnlyPlanInfo.setFirst((Object)false);
            return;
        }
        boolean isIndexOnlyPlan = false;
        boolean requireVerificationAfterSIdxSearch = (Boolean)indexOnlyPlanInfo.getThird();
        List<IOptimizableFuncExpr> matchedFuncExprs = analysisCtx.getMatchedFuncExprs();
        ArrayList<LogicalVariable> usedVarsInSelJoinOp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> usedVarsInSelJoinOpTemp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> liveVarsAfterSelJoinOp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> dataScanPKVars = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> dataScanRecordVars = new ArrayList<LogicalVariable>();
        VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)topRef.getValue()), usedVarsInSelJoinOpTemp);
        AccessMethodUtils.copyVarsToAnotherList(usedVarsInSelJoinOpTemp, usedVarsInSelJoinOp);
        ArrayList<LogicalVariable> selectInIndexSubTreeVars = new ArrayList<LogicalVariable>();
        if (probeSubTree != null) {
            ILogicalOperator tmpOp = indexSubTree.getRoot();
            while (tmpOp.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
                if (tmpOp.getOperatorTag() == LogicalOperatorTag.SELECT) {
                    VariableUtilities.getUsedVariables((ILogicalOperator)tmpOp, selectInIndexSubTreeVars);
                    AccessMethodUtils.copyVarsToAnotherList(selectInIndexSubTreeVars, usedVarsInSelJoinOp);
                    selectInIndexSubTreeVars.clear();
                }
                tmpOp = (ILogicalOperator)((Mutable)tmpOp.getInputs().get(0)).getValue();
            }
        }
        usedVarsInSelJoinOpTemp.clear();
        ArrayList<LogicalVariable> liveVarsInSubTreeRootOp = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> producedVarsInSubTreeRootOp = new ArrayList<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)indexSubTree.getRootRef().getValue()), liveVarsInSubTreeRootOp);
        VariableUtilities.getProducedVariables((ILogicalOperator)((ILogicalOperator)indexSubTree.getRootRef().getValue()), producedVarsInSubTreeRootOp);
        AccessMethodUtils.copyVarsToAnotherList(liveVarsInSubTreeRootOp, liveVarsAfterSelJoinOp);
        AccessMethodUtils.copyVarsToAnotherList(producedVarsInSubTreeRootOp, liveVarsAfterSelJoinOp);
        Iterator iterator = usedVarsInSelJoinOp.iterator();
        while (iterator.hasNext()) {
            LogicalVariable v = (LogicalVariable)iterator.next();
            if (liveVarsAfterSelJoinOp.contains(v)) continue;
            iterator.remove();
        }
        List<LogicalVariable> dataScanPKRecordVars = indexSubTree.getDataSourceVariables();
        if (dataScanPKRecordVars.size() > 1) {
            indexSubTree.getPrimaryKeyVars(null, dataScanPKVars);
        }
        dataScanRecordVars.addAll(dataScanPKRecordVars);
        dataScanRecordVars.removeAll(dataScanPKVars);
        List pkFieldNames = dataset.getPrimaryKeys();
        Index.ValueIndexDetails chosenIndexDetails = (Index.ValueIndexDetails)chosenIndex.getIndexDetails();
        List chosenIndexFieldNames = chosenIndexDetails.getKeyFieldNames();
        ArrayList<LogicalVariable> chosenIndexVars = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> constantVars = new ArrayList<LogicalVariable>();
        AccessMethodUtils.getConstantVars(indexSubTree.getAssignsAndUnnests(), constantVars);
        isIndexOnlyPlan = AccessMethodUtils.checkVarUsageInSelectOrJoinCondExpr(matchedFuncExprs, usedVarsInSelJoinOp, pkFieldNames, chosenIndexFieldNames, chosenIndexVars);
        int indexApplicableVarFoundCount = chosenIndexVars.size();
        if (indexApplicableVarFoundCount < usedVarsInSelJoinOp.size()) {
            isIndexOnlyPlan = false;
            doesSIdxSearchCoverAllPredicates = false;
        } else {
            doesSIdxSearchCoverAllPredicates = true;
        }
        if (chosenIndexDetails.getKeyFieldNames().size() > 1 && indexApplicableVarFoundCount > 1) {
            requireVerificationAfterSIdxSearch = true;
        }
        indexOnlyPlanInfo.setFirst((Object)isIndexOnlyPlan);
        indexOnlyPlanInfo.setThird((Object)requireVerificationAfterSIdxSearch);
        indexOnlyPlanInfo.setFourth((Object)doesSIdxSearchCoverAllPredicates);
        if (!isIndexOnlyPlan) {
            return;
        }
        AccessMethodUtils.checkVarUsageAfterSelectOp(afterTopRefs, liveVarsAfterSelJoinOp, dataScanPKVars, chosenIndexVars, chosenIndex, indexSubTree, chosenIndexFieldNames, dataScanRecordVars, context, constantVars, indexOnlyPlanInfo);
        isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
        boolean secondaryKeyFieldUsedAfterSelectOrJoinOp = (Boolean)indexOnlyPlanInfo.getSecond();
        if (chosenIndex.getIndexType() == DatasetConfig.IndexType.RTREE && (rTreeCheck = AccessMethodUtils.checkRTreeSpecificIdxOnlyCondition(probeSubTree, indexSubTree, chosenIndex, analysisCtx, matchedFuncExprs, liveVarsAfterSelJoinOp, indexOnlyPlanInfo))) {
            isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
            requireVerificationAfterSIdxSearch = (Boolean)indexOnlyPlanInfo.getThird();
        }
        indexOnlyPlanInfo.setFirst((Object)isIndexOnlyPlan);
        indexOnlyPlanInfo.setSecond((Object)secondaryKeyFieldUsedAfterSelectOrJoinOp);
        indexOnlyPlanInfo.setThird((Object)requireVerificationAfterSIdxSearch);
        indexOnlyPlanInfo.setFourth((Object)doesSIdxSearchCoverAllPredicates);
    }

    private static void copyVarsToAnotherList(List<LogicalVariable> sourceList, List<LogicalVariable> targetList) {
        for (LogicalVariable v : sourceList) {
            if (targetList.contains(v)) continue;
            targetList.add(v);
        }
    }

    private static void copyVarsToAnotherList(Set<LogicalVariable> sourceSet, List<LogicalVariable> targetList) {
        for (LogicalVariable v : sourceSet) {
            if (targetList.contains(v)) continue;
            targetList.add(v);
        }
    }

    private static boolean checkVarUsageInSelectOrJoinCondExpr(List<IOptimizableFuncExpr> matchedFuncExprs, List<LogicalVariable> usedVarsInSelJoinOp, List<List<String>> PKfieldNames, List<List<String>> chosenIndexFieldNames, List<LogicalVariable> chosenIndexVars) {
        boolean exprOnlyUsesVarsFromIndex = false;
        for (IOptimizableFuncExpr matchedFuncExpr : matchedFuncExprs) {
            for (LogicalVariable conditionVar : usedVarsInSelJoinOp) {
                int varIndex = matchedFuncExpr.findLogicalVar(conditionVar);
                if (varIndex == -1) continue;
                List<String> fieldNameOfSelectVars = matchedFuncExpr.getFieldName(varIndex);
                int keyFoundInPIdx = PKfieldNames.indexOf(fieldNameOfSelectVars);
                int keyFoundInSIdx = chosenIndexFieldNames.indexOf(fieldNameOfSelectVars);
                if (keyFoundInPIdx < 0 && keyFoundInSIdx < 0) {
                    exprOnlyUsesVarsFromIndex = false;
                    break;
                }
                if (!chosenIndexVars.contains(conditionVar)) {
                    chosenIndexVars.add(conditionVar);
                }
                exprOnlyUsesVarsFromIndex = true;
            }
            if (exprOnlyUsesVarsFromIndex) continue;
            break;
        }
        return exprOnlyUsesVarsFromIndex;
    }

    private static void checkVarUsageAfterSelectOp(List<Mutable<ILogicalOperator>> afterSelectOpRefs, List<LogicalVariable> liveVarsAfterSelJoinOp, List<LogicalVariable> dataScanPKVars, List<LogicalVariable> chosenIndexVars, Index chosenIndex, OptimizableOperatorSubTree indexSubTree, List<List<String>> chosenIndexFieldNames, List<LogicalVariable> dataScanRecordVars, IOptimizationContext context, List<LogicalVariable> constantVars, Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo) throws AlgebricksException {
        if (afterSelectOpRefs == null) {
            indexOnlyPlanInfo.setFirst((Object)false);
            indexOnlyPlanInfo.setSecond((Object)false);
            return;
        }
        boolean isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
        boolean secondaryKeyFieldUsedAfterSelectOrJoinOp = (Boolean)indexOnlyPlanInfo.getSecond();
        boolean countAggFunctionIsUsedInThePlan = false;
        ArrayList usedVarsInCount = new ArrayList();
        ArrayList producedVarsAfterSelectOrJoinOp = new ArrayList();
        ArrayList usedVarsAfterSelectOrJoinOp = new ArrayList();
        for (Mutable<ILogicalOperator> afterSelectRef : afterSelectOpRefs) {
            usedVarsAfterSelectOrJoinOp.clear();
            producedVarsAfterSelectOrJoinOp.clear();
            VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)afterSelectRef.getValue()), usedVarsAfterSelectOrJoinOp);
            VariableUtilities.getProducedVariables((ILogicalOperator)((ILogicalOperator)afterSelectRef.getValue()), producedVarsAfterSelectOrJoinOp);
            AbstractLogicalOperator afterSelectRefOp = (AbstractLogicalOperator)afterSelectRef.getValue();
            if (afterSelectRefOp.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
                AggregateOperator aggOp = (AggregateOperator)afterSelectRefOp;
                List condExprs = aggOp.getExpressions();
                for (int i = 0; i < condExprs.size(); ++i) {
                    AbstractFunctionCallExpression condExprFnCall;
                    ILogicalExpression condExpr = (ILogicalExpression)((Mutable)condExprs.get(i)).getValue();
                    if (condExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (condExprFnCall = (AbstractFunctionCallExpression)condExpr).getFunctionIdentifier() != BuiltinFunctions.COUNT) continue;
                    countAggFunctionIsUsedInThePlan = true;
                    VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)afterSelectRef.getValue()), usedVarsInCount);
                    break;
                }
            }
            for (LogicalVariable usedVarAfterSelectOrJoinOp : usedVarsAfterSelectOrJoinOp) {
                if (!liveVarsAfterSelJoinOp.contains(usedVarAfterSelectOrJoinOp)) continue;
                if (dataScanPKVars.contains(usedVarAfterSelectOrJoinOp)) {
                    isIndexOnlyPlan = true;
                    continue;
                }
                if (chosenIndexVars.contains(usedVarAfterSelectOrJoinOp)) {
                    secondaryKeyFieldUsedAfterSelectOrJoinOp = true;
                    if (chosenIndex.getIndexType() == DatasetConfig.IndexType.BTREE || chosenIndex.getIndexType() == DatasetConfig.IndexType.RTREE) {
                        isIndexOnlyPlan = true;
                        continue;
                    }
                    isIndexOnlyPlan = false;
                    break;
                }
                if (indexSubTree.getVarsToFieldNameMap().containsKey(usedVarAfterSelectOrJoinOp)) {
                    if (chosenIndexFieldNames.contains(indexSubTree.getVarsToFieldNameMap().get(usedVarAfterSelectOrJoinOp))) {
                        isIndexOnlyPlan = true;
                        secondaryKeyFieldUsedAfterSelectOrJoinOp = true;
                        continue;
                    }
                    isIndexOnlyPlan = false;
                    break;
                }
                if (dataScanRecordVars.contains(usedVarAfterSelectOrJoinOp)) {
                    if (!countAggFunctionIsUsedInThePlan) {
                        isIndexOnlyPlan = false;
                        break;
                    }
                    if (usedVarsInCount.contains(usedVarAfterSelectOrJoinOp) || usedVarsInCount.containsAll(producedVarsAfterSelectOrJoinOp)) {
                        VariableUtilities.substituteVariables((ILogicalOperator)afterSelectRefOp, (LogicalVariable)usedVarAfterSelectOrJoinOp, (LogicalVariable)dataScanPKVars.get(0), (ITypingContext)context);
                        isIndexOnlyPlan = true;
                        continue;
                    }
                    isIndexOnlyPlan = false;
                    break;
                }
                if (constantVars.contains(usedVarAfterSelectOrJoinOp)) {
                    isIndexOnlyPlan = true;
                    continue;
                }
                isIndexOnlyPlan = false;
                break;
            }
            if (isIndexOnlyPlan) continue;
            break;
        }
        indexOnlyPlanInfo.setFirst((Object)isIndexOnlyPlan);
        indexOnlyPlanInfo.setSecond((Object)secondaryKeyFieldUsedAfterSelectOrJoinOp);
    }

    private static boolean checkRTreeSpecificIdxOnlyCondition(OptimizableOperatorSubTree probeSubTree, OptimizableOperatorSubTree indexSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, List<IOptimizableFuncExpr> matchedFuncExprs, List<LogicalVariable> liveVarsInSelJoinOp, Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo) throws AlgebricksException {
        int optFieldIdx;
        Pair keyPairType;
        boolean isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
        boolean requireVerificationAfterSIdxSearch = (Boolean)indexOnlyPlanInfo.getThird();
        IOptimizableFuncExpr optFuncExpr = AccessMethodUtils.chooseFirstOptFuncExpr(chosenIndex, analysisCtx);
        ARecordType recordType = indexSubTree.getRecordType();
        ARecordType probeRecordType = null;
        if (probeSubTree != null) {
            probeRecordType = probeSubTree.getRecordType();
        }
        if ((keyPairType = Index.getNonNullableOpenFieldType((Index)chosenIndex, (IAType)optFuncExpr.getFieldType(optFieldIdx = AccessMethodUtils.chooseFirstOptFuncVar(chosenIndex, analysisCtx)), optFuncExpr.getFieldName(optFieldIdx), (ARecordType)recordType)) == null) {
            return false;
        }
        if (matchedFuncExprs.size() == 1) {
            AbstractFunctionCallExpression condExpr;
            AbstractFunctionCallExpression condExprFnCall = condExpr = optFuncExpr.getFuncExpr();
            for (int i = 0; i < condExprFnCall.getArguments().size(); ++i) {
                List<String> tmpValFieldName;
                int j;
                AsterixConstantValue tmpVal;
                Mutable expr = (Mutable)condExprFnCall.getArguments().get(i);
                if (((ILogicalExpression)expr.getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                    tmpVal = (AsterixConstantValue)((ConstantExpression)expr.getValue()).getValue();
                    if (tmpVal.getObject().getType().getTypeTag() == ATypeTag.POINT || tmpVal.getObject().getType().getTypeTag() == ATypeTag.RECTANGLE) {
                        if (((IAType)keyPairType.first).getTypeTag() == ATypeTag.POINT || ((IAType)keyPairType.first).getTypeTag() == ATypeTag.RECTANGLE) {
                            requireVerificationAfterSIdxSearch = false;
                            continue;
                        }
                        requireVerificationAfterSIdxSearch = true;
                    } else {
                        requireVerificationAfterSIdxSearch = true;
                    }
                    break;
                }
                if (((ILogicalExpression)expr.getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE || liveVarsInSelJoinOp.contains(tmpVal = ((VariableReferenceExpression)expr.getValue()).getVariableReference())) continue;
                IAType tmpValFieldType = null;
                if (probeSubTree != null) {
                    for (j = 0; j < probeSubTree.getAssignsAndUnnestsRefs().size(); ++j) {
                        UnnestMapOperator tmpUnnestMapOp;
                        ILogicalExpression tmpCondExpr;
                        AbstractFunctionCallExpression tmpCondExprCall;
                        FunctionIdentifier tmpFuncID;
                        ArrayList producedVarsFromProbeTree = new ArrayList();
                        ILogicalOperator tmpOp = (ILogicalOperator)probeSubTree.getAssignsAndUnnestsRefs().get(j).getValue();
                        VariableUtilities.getProducedVariables((ILogicalOperator)tmpOp, producedVarsFromProbeTree);
                        if (!producedVarsFromProbeTree.contains(tmpVal)) continue;
                        if (tmpOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                            Mutable tmpConditionExpr;
                            AssignOperator tmpAssignOp = (AssignOperator)tmpOp;
                            List tmpCondExprs = tmpAssignOp.getExpressions();
                            Iterator iterator = tmpCondExprs.iterator();
                            while (iterator.hasNext() && (((ILogicalExpression)(tmpConditionExpr = (Mutable)iterator.next()).getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (tmpValFieldType = AccessMethodUtils.findSpatialType(tmpFuncID = (tmpCondExprCall = (AbstractFunctionCallExpression)(tmpCondExpr = (ILogicalExpression)tmpConditionExpr.getValue())).getFunctionIdentifier())) == null)) {
                            }
                            continue;
                        }
                        if (tmpOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP && (tmpValFieldType = AccessMethodUtils.findSpatialType(tmpFuncID = (tmpCondExprCall = (AbstractFunctionCallExpression)(tmpCondExpr = (ILogicalExpression)(tmpUnnestMapOp = (UnnestMapOperator)tmpOp).getExpressionRef().getValue())).getFunctionIdentifier())) != null) break;
                    }
                }
                if (tmpValFieldType == null && (tmpValFieldName = probeSubTree.getVarsToFieldNameMap().get(tmpVal)) != null) {
                    for (j = 0; j < probeRecordType.getFieldNames().length; ++j) {
                        String fieldName = probeRecordType.getFieldNames()[j];
                        if (!tmpValFieldName.contains(fieldName)) continue;
                        tmpValFieldType = probeRecordType.getFieldType(fieldName);
                        break;
                    }
                }
                if (((IAType)keyPairType.first).getTypeTag() == ATypeTag.POINT || ((IAType)keyPairType.first).getTypeTag() == ATypeTag.RECTANGLE) {
                    if (tmpValFieldType != null && (tmpValFieldType.getTypeTag() == ATypeTag.POINT || tmpValFieldType.getTypeTag() == ATypeTag.RECTANGLE)) {
                        requireVerificationAfterSIdxSearch = false;
                        continue;
                    }
                    requireVerificationAfterSIdxSearch = true;
                    continue;
                }
                isIndexOnlyPlan = false;
                requireVerificationAfterSIdxSearch = true;
            }
        } else {
            requireVerificationAfterSIdxSearch = true;
        }
        indexOnlyPlanInfo.setFirst((Object)isIndexOnlyPlan);
        indexOnlyPlanInfo.setThird((Object)requireVerificationAfterSIdxSearch);
        return true;
    }

    public static boolean isInvertedIndex(Index index) {
        switch (index.getIndexType()) {
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case SINGLE_PARTITION_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: {
                return true;
            }
        }
        return false;
    }

    public static IAType findSpatialType(FunctionIdentifier fid) {
        if (fid == BuiltinFunctions.CREATE_CIRCLE || fid == BuiltinFunctions.CIRCLE_CONSTRUCTOR) {
            return BuiltinType.ACIRCLE;
        }
        if (fid == BuiltinFunctions.CREATE_POINT || fid == BuiltinFunctions.POINT_CONSTRUCTOR) {
            return BuiltinType.APOINT;
        }
        if (fid == BuiltinFunctions.CREATE_RECTANGLE || fid == BuiltinFunctions.RECTANGLE_CONSTRUCTOR) {
            return BuiltinType.ARECTANGLE;
        }
        if (fid == BuiltinFunctions.CREATE_POLYGON || fid == BuiltinFunctions.POLYGON_CONSTRUCTOR) {
            return BuiltinType.APOLYGON;
        }
        if (fid == BuiltinFunctions.CREATE_LINE || fid == BuiltinFunctions.LINE_CONSTRUCTOR) {
            return BuiltinType.ALINE;
        }
        return null;
    }

    private static void getConstantVars(List<AbstractLogicalOperator> assignOps, List<LogicalVariable> targetVars) {
        for (AbstractLogicalOperator assignUnnestOp : assignOps) {
            if (assignUnnestOp.getOperatorTag() != LogicalOperatorTag.ASSIGN) continue;
            AssignOperator assignOp = (AssignOperator)assignUnnestOp;
            List condExprs = assignOp.getExpressions();
            for (int i = 0; i < condExprs.size(); ++i) {
                ILogicalExpression condExpr = (ILogicalExpression)((Mutable)condExprs.get(i)).getValue();
                if (condExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT || targetVars.contains(assignOp.getVariables().get(i))) continue;
                targetVars.add((LogicalVariable)assignOp.getVariables().get(i));
            }
        }
    }

    public static ILogicalOperator findDataSourceFromIndexUtilizationPlan(ILogicalOperator topOp) {
        if (topOp == null) {
            return null;
        }
        ILogicalOperator dataSourceOp = topOp;
        switch (topOp.getOperatorTag()) {
            case UNNEST_MAP: 
            case LEFT_OUTER_UNNEST_MAP: {
                return topOp;
            }
            case UNIONALL: {
                dataSourceOp = (ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue();
                while ((dataSourceOp = (ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.SPLIT && dataSourceOp.hasInputs()) {
                }
                if (dataSourceOp.getOperatorTag() != LogicalOperatorTag.SPLIT) {
                    return null;
                }
                while ((dataSourceOp = (ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.UNNEST_MAP && dataSourceOp.getOperatorTag() != LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP && dataSourceOp.hasInputs()) {
                }
                if (dataSourceOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP || dataSourceOp.getOperatorTag() == LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) {
                    return dataSourceOp;
                }
                return null;
            }
        }
        return null;
    }

    public static ILogicalOperator resetVariableMappingInUnionOpInIndexOnlyPlan(boolean lojVarExist, List<LogicalVariable> lojMissingNullVariables, ILogicalOperator unionAllOp, List<Mutable<ILogicalOperator>> aboveTopRefs, IOptimizationContext context) throws AlgebricksException {
        if (unionAllOp.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
            return unionAllOp;
        }
        boolean lojVarCanBeDeleted = true;
        if (lojVarExist) {
            ArrayList usedVars = new ArrayList();
            for (int i = 0; i < aboveTopRefs.size(); ++i) {
                usedVars.clear();
                ILogicalOperator lOp = (ILogicalOperator)aboveTopRefs.get(i).getValue();
                VariableUtilities.getUsedVariables((ILogicalOperator)lOp, usedVars);
                if (!usedVars.containsAll(lojMissingNullVariables) || lOp.getOperatorTag() == LogicalOperatorTag.GROUP) continue;
                lojVarCanBeDeleted = false;
                break;
            }
        }
        List varMap = ((UnionAllOperator)unionAllOp).getVariableMappings();
        if (lojVarExist && lojVarCanBeDeleted) {
            Iterator it = varMap.iterator();
            while (it.hasNext()) {
                Triple tripleVars = (Triple)it.next();
                if (!((LogicalVariable)tripleVars.first).equals((Object)lojMissingNullVariables.get(0)) && !((LogicalVariable)tripleVars.second).equals((Object)lojMissingNullVariables.get(0)) && !((LogicalVariable)tripleVars.third).equals((Object)lojMissingNullVariables.get(0))) continue;
                it.remove();
            }
        }
        if (lojVarExist && lojVarCanBeDeleted) {
            UnionAllOperator newUnionAllOp = new UnionAllOperator(varMap);
            newUnionAllOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)unionAllOp.getInputs().get(0)).getValue())));
            newUnionAllOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)unionAllOp.getInputs().get(1)).getValue())));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newUnionAllOp);
            return newUnionAllOp;
        }
        return unionAllOp;
    }

    public static boolean findVarInTripleVarList(List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varsList, LogicalVariable varToFind, boolean checkOnlyFirst) {
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> itVars : varsList) {
            if (varToFind == itVars.first) {
                return true;
            }
            if (checkOnlyFirst || varToFind != itVars.second && varToFind != itVars.third) continue;
            return true;
        }
        return false;
    }

    static LogicalVariable findUnionAllOutputVariable(UnionAllOperator unionAllOp, LogicalVariable inputVar) {
        for (Triple t : unionAllOp.getVariableMappings()) {
            if (!((LogicalVariable)t.first).equals((Object)inputVar) && !((LogicalVariable)t.second).equals((Object)inputVar)) continue;
            return (LogicalVariable)t.third;
        }
        return null;
    }

    static boolean skipSecondaryIndexRequestedByAnnotation(Index index, IOptimizableFuncExpr optFuncExpr) {
        SkipSecondaryIndexSearchExpressionAnnotation ann = (SkipSecondaryIndexSearchExpressionAnnotation)optFuncExpr.getFuncExpr().getAnnotation(SkipSecondaryIndexSearchExpressionAnnotation.class);
        return ann != null && (ann.getIndexNames() == null || ann.getIndexNames().contains(index.getIndexName()));
    }

    static Collection<String> getSecondaryIndexPreferences(IOptimizableFuncExpr optFuncExpr, Class<? extends AbstractExpressionAnnotationWithIndexNames> annClass) {
        AbstractExpressionAnnotationWithIndexNames ann = (AbstractExpressionAnnotationWithIndexNames)optFuncExpr.getFuncExpr().getAnnotation(annClass);
        return ann == null ? null : ann.getIndexNames();
    }

    public static Pair<List<String>, Integer> getFieldNameSetStepsFromSubTree(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int opIndex, int assignVarIndex, int funcVarIndex, ILogicalExpression parentFuncExpr, IOptimizationContext context) throws AlgebricksException {
        if (optFuncExpr != null && parentFuncExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            optFuncExpr.addStepExpr(funcVarIndex, (AbstractFunctionCallExpression)parentFuncExpr);
        }
        return AccessMethodUtils.getFieldNameAndStepsFromSubTree(optFuncExpr, subTree, opIndex, assignVarIndex, funcVarIndex, parentFuncExpr, context);
    }

    private static Pair<List<String>, Integer> getFieldNameAndStepsFromSubTree(IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, int opIndex, int assignVarIndex, int funcVarIndex, ILogicalExpression parentFuncExpr, IOptimizationContext context) throws AlgebricksException {
        List funcArgs;
        AbstractLogicalExpression expr = null;
        AbstractFunctionCallExpression childFuncExpr = null;
        AbstractLogicalOperator op = subTree.getAssignsAndUnnests().get(opIndex);
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            expr = (AbstractLogicalExpression)((Mutable)assignOp.getExpressions().get(assignVarIndex)).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return NO_FIELD_NAME;
            }
            childFuncExpr = (AbstractFunctionCallExpression)expr;
        } else {
            UnnestOperator unnestOp = (UnnestOperator)op;
            expr = (AbstractLogicalExpression)unnestOp.getExpressionRef().getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return NO_FIELD_NAME;
            }
            childFuncExpr = (AbstractFunctionCallExpression)expr;
            if (childFuncExpr.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
                return NO_FIELD_NAME;
            }
            expr = (AbstractLogicalExpression)((Mutable)childFuncExpr.getArguments().get(0)).getValue();
        }
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return NO_FIELD_NAME;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        boolean isByName = false;
        boolean isFieldAccess = false;
        String fieldName = null;
        ArrayList<String> nestedAccessFieldName = null;
        int fieldIndex = -1;
        if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_NAME) {
            fieldName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)1);
            if (fieldName == null) {
                return NO_FIELD_NAME;
            }
            isFieldAccess = true;
            isByName = true;
        } else if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_INDEX) {
            Integer idx = ConstantExpressionUtil.getIntArgument((AbstractFunctionCallExpression)funcExpr, (int)1);
            if (idx == null) {
                return NO_FIELD_NAME;
            }
            fieldIndex = idx;
            isFieldAccess = true;
        } else if (funcIdent == BuiltinFunctions.FIELD_ACCESS_NESTED) {
            ILogicalExpression nameArg = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
            if (nameArg.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                return NO_FIELD_NAME;
            }
            ConstantExpression constExpr = (ConstantExpression)nameArg;
            AOrderedList orderedNestedFieldName = (AOrderedList)((AsterixConstantValue)constExpr.getValue()).getObject();
            nestedAccessFieldName = new ArrayList<String>();
            for (int i = 0; i < orderedNestedFieldName.size(); ++i) {
                nestedAccessFieldName.add(((AString)orderedNestedFieldName.getItem(i)).getStringValue());
            }
            isFieldAccess = true;
            isByName = true;
        }
        if (isFieldAccess) {
            LogicalVariable sourceVar = ((VariableReferenceExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getVariableReference();
            if (optFuncExpr != null) {
                optFuncExpr.setLogicalExpr(funcVarIndex, parentFuncExpr);
                optFuncExpr.addStepExpr(funcVarIndex, funcExpr);
            }
            int[] assignAndExpressionIndexes = null;
            for (int i = opIndex + 1; i < subTree.getAssignsAndUnnests().size(); ++i) {
                List varList;
                AbstractLogicalOperator subOp = subTree.getAssignsAndUnnests().get(i);
                if (subOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    varList = ((AssignOperator)subOp).getVariables();
                } else {
                    if (subOp.getOperatorTag() != LogicalOperatorTag.UNNEST) break;
                    varList = ((UnnestOperator)subOp).getVariables();
                }
                for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                    ArrayList parentVars = new ArrayList();
                    funcExpr.getUsedVariables(parentVars);
                    if (!parentVars.contains(var)) continue;
                    assignAndExpressionIndexes = new int[]{i, varIndex};
                }
            }
            if (assignAndExpressionIndexes != null && assignAndExpressionIndexes[0] > -1) {
                Pair<List<String>, Integer> parentFieldNames = AccessMethodUtils.getFieldNameAndStepsFromSubTree(optFuncExpr, subTree, (int)assignAndExpressionIndexes[0], (int)assignAndExpressionIndexes[1], funcVarIndex, parentFuncExpr, context);
                if (((List)parentFieldNames.first).isEmpty()) {
                    return NO_FIELD_NAME;
                }
                if (!isByName) {
                    IVariableTypeEnvironment outputTypeEnvironment = context.getOutputTypeEnvironment((ILogicalOperator)subTree.getAssignsAndUnnests().get((int)assignAndExpressionIndexes[0]));
                    IAType subFieldType = (IAType)outputTypeEnvironment.getVarType(sourceVar);
                    if ((subFieldType = TypeComputeUtils.getActualType((IAType)subFieldType)).getTypeTag() != ATypeTag.OBJECT) {
                        throw CompilationException.create((ErrorCode)ErrorCode.TYPE_CONVERT, (Serializable[])new Serializable[]{subFieldType, ARecordType.class.getName()});
                    }
                    fieldName = ((ARecordType)subFieldType).getFieldNames()[fieldIndex];
                }
                if (optFuncExpr != null) {
                    optFuncExpr.setSourceVar(funcVarIndex, (LogicalVariable)((AssignOperator)op).getVariables().get(assignVarIndex));
                }
                if (nestedAccessFieldName != null) {
                    ((List)parentFieldNames.first).addAll(nestedAccessFieldName);
                } else {
                    ((List)parentFieldNames.first).add(fieldName);
                }
                return parentFieldNames;
            }
            if (optFuncExpr != null) {
                optFuncExpr.setSourceVar(funcVarIndex, (LogicalVariable)((AssignOperator)op).getVariables().get(assignVarIndex));
            }
            OptimizableOperatorSubTree.RecordTypeSource recType = subTree.getRecordTypeFor(sourceVar);
            if (isByName) {
                if (nestedAccessFieldName != null) {
                    return new Pair(nestedAccessFieldName, (Object)recType.sourceIndicator);
                }
                return new Pair(new ArrayList<String>(List.of(fieldName)), (Object)recType.sourceIndicator);
            }
            return new Pair(new ArrayList<String>(List.of(recType.recordType.getFieldNames()[fieldIndex])), (Object)recType.sourceIndicator);
        }
        if (optFuncExpr != null && optFuncExpr.getFuncExpr().getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE_CHECK) {
            optFuncExpr.setPartialField(true);
        }
        if ((funcArgs = funcExpr.getArguments()).isEmpty()) {
            return NO_FIELD_NAME;
        }
        ILogicalExpression argExpr = (ILogicalExpression)((Mutable)funcArgs.get(0)).getValue();
        if (argExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return NO_FIELD_NAME;
        }
        for (int i = 1; i < funcArgs.size(); ++i) {
            if (((ILogicalExpression)((Mutable)funcArgs.get(i)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) continue;
            return NO_FIELD_NAME;
        }
        if (optFuncExpr != null) {
            optFuncExpr.addStepExpr(funcVarIndex, funcExpr);
        }
        LogicalVariable curVar = ((VariableReferenceExpression)argExpr).getVariableReference();
        for (int assignOrUnnestIndex = opIndex + 1; assignOrUnnestIndex < subTree.getAssignsAndUnnests().size(); ++assignOrUnnestIndex) {
            AbstractLogicalOperator curOp = subTree.getAssignsAndUnnests().get(assignOrUnnestIndex);
            if (curOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assignOp = (AssignOperator)curOp;
                List varList = assignOp.getVariables();
                for (int varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    LogicalVariable var = (LogicalVariable)varList.get(varIndex);
                    if (!var.equals((Object)curVar) || optFuncExpr == null) continue;
                    optFuncExpr.setSourceVar(funcVarIndex, var);
                    return AccessMethodUtils.getFieldNameAndStepsFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, varIndex, funcVarIndex, (ILogicalExpression)childFuncExpr, context);
                }
                continue;
            }
            UnnestOperator unnestOp = (UnnestOperator)curOp;
            LogicalVariable var = unnestOp.getVariable();
            if (!var.equals((Object)curVar)) continue;
            AccessMethodUtils.getFieldNameAndStepsFromSubTree(optFuncExpr, subTree, assignOrUnnestIndex, 0, funcVarIndex, (ILogicalExpression)childFuncExpr, context);
        }
        return NO_FIELD_NAME;
    }

    public static Triple<Integer, List<String>, IAType> analyzeVarForArrayIndexes(List<Index> datasetIndexes, IOptimizableFuncExpr optFuncExpr, OptimizableOperatorSubTree subTree, IOptimizationContext context, LogicalVariable assignVar, AccessMethodAnalysisContext analysisCtx) throws AlgebricksException {
        int lastMatchedDataSourceVar = (Integer)subTree.getLastMatchedDataSourceVars().second;
        if (lastMatchedDataSourceVar < 0) {
            return null;
        }
        ILogicalExpression optVarExpr = (ILogicalExpression)optFuncExpr.getArgument(lastMatchedDataSourceVar).getValue();
        if (optVarExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            optFuncExpr.addStepExpr(lastMatchedDataSourceVar, (AbstractFunctionCallExpression)optVarExpr);
        }
        optFuncExpr.setLogicalExpr(lastMatchedDataSourceVar, optVarExpr);
        for (Index index : datasetIndexes) {
            if (index.getIndexType() != DatasetConfig.IndexType.ARRAY) continue;
            Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
            for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
                if (e.getUnnestList().isEmpty()) continue;
                for (List project : e.getProjectList()) {
                    int optVarIndex;
                    List flatName = ArrayIndexUtil.getFlattenedKeyFieldNames((List)e.getUnnestList(), (List)project);
                    List unnestFlags = ArrayIndexUtil.getUnnestFlags((List)e.getUnnestList(), (List)project);
                    analysisCtx.getArrayIndexStructureMatcher().reset(assignVar, subTree);
                    ArrayIndexUtil.walkArrayPath((Index)index, (ARecordType)subTree.getRecordType(), (List)flatName, (List)unnestFlags, (ArrayIndexUtil.TypeTrackerCommandExecutor)analysisCtx.getArrayIndexStructureMatcher());
                    LogicalVariable varAfterWalk = analysisCtx.getArrayIndexStructureMatcher().getEndVar();
                    ILogicalOperator opAfterWalk = analysisCtx.getArrayIndexStructureMatcher().getEndOperator();
                    if (varAfterWalk == null || opAfterWalk == null || (optVarIndex = optFuncExpr.findLogicalVar(varAfterWalk)) == -1) continue;
                    IAType fieldType = (IAType)context.getOutputTypeEnvironment(opAfterWalk).getVarType(varAfterWalk);
                    optFuncExpr.setSourceVar(optVarIndex, varAfterWalk);
                    optFuncExpr.setOptimizableSubTree(optVarIndex, subTree);
                    MutableInt fieldSource = new MutableInt(0);
                    optFuncExpr.setFieldName(optVarIndex, flatName, fieldSource.intValue());
                    optFuncExpr.setFieldType(optVarIndex, fieldType);
                    IAType type = (IAType)context.getOutputTypeEnvironment(subTree.getRoot()).getVarType(optFuncExpr.getLogicalVar(optVarIndex));
                    optFuncExpr.setFieldType(optVarIndex, type);
                    return new Triple((Object)optVarIndex, (Object)flatName, (Object)fieldType);
                }
            }
        }
        return null;
    }

    public static boolean isFieldAccess(FunctionIdentifier funId) {
        return funId.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) || funId.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX) || funId.equals((Object)BuiltinFunctions.FIELD_ACCESS_NESTED);
    }

    static enum SecondaryUnnestMapOutputVarType {
        PRIMARY_KEY,
        SECONDARY_KEY,
        CONDITIONAL_SPLIT_VAR;

    }

    public static class SearchKeyRoundingFunctionProvider {
        public ATypeHierarchy.TypeCastingMathFunctionType getRoundingFunction(AlgebricksBuiltinFunctions.ComparisonKind cKind, Index chosenIndex, IAType indexedFieldType, IAObject constantValue, boolean realTypeConvertedToIntegerType) throws CompilationException {
            switch (cKind) {
                case LT: 
                case GE: {
                    return ATypeHierarchy.TypeCastingMathFunctionType.CEIL;
                }
                case LE: 
                case GT: {
                    return ATypeHierarchy.TypeCastingMathFunctionType.FLOOR;
                }
            }
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{cKind.toString()});
        }
    }
}

