/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.JoinProductivityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;

public class Stats {
    public double SELECTIVITY_FOR_SECONDARY_INDEX_SELECTION = 0.1;
    protected IOptimizationContext optCtx;
    protected JoinEnum joinEnum;

    public Stats(IOptimizationContext context, JoinEnum joinE) {
        this.optCtx = context;
        this.joinEnum = joinE;
    }

    public DataverseName findDataverseName(DataSourceScanOperator scanOp) {
        if (scanOp == null) {
            return null;
        }
        DataSourceId dsid = (DataSourceId)scanOp.getDataSource().getId();
        return dsid.getDataverseName();
    }

    public Index findSampleIndex(DataSourceScanOperator scanOp, IOptimizationContext context) throws AlgebricksException {
        DataverseName dataverseName = this.findDataverseName(scanOp);
        DataSource ds = (DataSource)scanOp.getDataSource();
        DataSourceId dsid = ds.getId();
        MetadataProvider mdp = (MetadataProvider)context.getMetadataProvider();
        return mdp.findSampleIndex(dataverseName, dsid.getDatasourceName());
    }

    private double findJoinSelectivity(JoinProductivityAnnotation anno, AbstractFunctionCallExpression joinExpr) throws AlgebricksException {
        ArrayList exprUsedVars = new ArrayList();
        joinExpr.getUsedVariables(exprUsedVars);
        if (exprUsedVars.size() != 2) {
            return 1.0;
        }
        int idx1 = this.joinEnum.findJoinNodeIndex((LogicalVariable)exprUsedVars.get(0)) + 1;
        int idx2 = this.joinEnum.findJoinNodeIndex((LogicalVariable)exprUsedVars.get(1)) + 1;
        double card1 = this.joinEnum.getJnArray()[idx1].origCardinality;
        double card2 = this.joinEnum.getJnArray()[idx2].origCardinality;
        if (card1 == 0.0 || card2 == 0.0) {
            return 1.0;
        }
        if (anno != null) {
            int leftIndex = this.joinEnum.findJoinNodeIndexByName(anno.getLeftSideDataSet());
            if (leftIndex != idx1 && leftIndex != idx2) {
                IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
                if (warningCollector.shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)joinExpr.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"productivity", "Invalid collection name/alias: " + anno.getLeftSideDataSet()}));
                }
                return 1.0;
            }
            double productivity = anno.getJoinProductivity();
            if (productivity <= 0.0) {
                IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
                if (warningCollector.shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)joinExpr.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"productivity", "Productivity specified: " + productivity + ", has to be a decimal value greater than 0"}));
                }
                return 1.0;
            }
            if (leftIndex == idx1) {
                return productivity / card2;
            }
            return productivity / card1;
        }
        if (card1 < card2) {
            return 1.0 / card1;
        }
        return 1.0 / card2;
    }

    protected double getSelectivityFromAnnotation(AbstractFunctionCallExpression afcExpr, boolean join) throws AlgebricksException {
        ILogicalExpression lexpr;
        double sel = 1.0;
        if (afcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.OR)) {
            double orSel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(0)).getValue(), join);
            for (int i = 1; i < afcExpr.getArguments().size(); ++i) {
                ILogicalExpression lexpr2 = (ILogicalExpression)((Mutable)afcExpr.getArguments().get(i)).getValue();
                if (!lexpr2.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
                sel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(i)).getValue(), join);
                orSel = orSel + sel - orSel * sel;
            }
            return orSel;
        }
        if (afcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
            double andSel = 1.0;
            for (int i = 0; i < afcExpr.getArguments().size(); ++i) {
                ILogicalExpression lexpr3 = (ILogicalExpression)((Mutable)afcExpr.getArguments().get(i)).getValue();
                if (!lexpr3.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
                sel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(i)).getValue(), join);
                andSel *= sel;
            }
            return andSel;
        }
        if (afcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.NOT) && (lexpr = (ILogicalExpression)((Mutable)afcExpr.getArguments().get(0)).getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            sel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(0)).getValue(), join);
            return 1.0 - sel;
        }
        double s = 1.0;
        PredicateCardinalityAnnotation pca = (PredicateCardinalityAnnotation)afcExpr.getAnnotation(PredicateCardinalityAnnotation.class);
        if (pca != null) {
            s = pca.getSelectivity();
            if (s <= 0.0 || s >= 1.0) {
                IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
                if (warningCollector.shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)afcExpr.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"selectivity", "Selectivity specified: " + s + ", has to be a decimal value greater than 0 and less than 1"}));
                }
            } else {
                sel *= s;
            }
        } else {
            JoinProductivityAnnotation jpa = (JoinProductivityAnnotation)afcExpr.getAnnotation(JoinProductivityAnnotation.class);
            s = this.findJoinSelectivity(jpa, afcExpr);
            sel *= s;
        }
        if (join && s == 1.0) {
            this.joinEnum.singleDatasetPreds.add((ILogicalExpression)afcExpr);
        }
        return sel;
    }

    public double getSelectivityFromAnnotationMain(ILogicalExpression leExpr, boolean join) throws AlgebricksException {
        double sel = 1.0;
        if (leExpr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)leExpr;
            sel = this.getSelectivityFromAnnotation(afcExpr, join);
        }
        return sel;
    }

    protected double getSelectivity(ILogicalOperator op, boolean join) throws AlgebricksException {
        double sel = 1.0;
        if (op == null) {
            return sel;
        }
        while (op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selOper = (SelectOperator)op;
                sel *= this.getSelectivityFromAnnotationMain((ILogicalExpression)selOper.getCondition().getValue(), join);
            }
            if (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                sel *= this.getSelectivity((SubplanOperator)op);
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return sel;
    }

    protected double getSelectivity(SubplanOperator subplanOp) throws AlgebricksException {
        double sel = 1.0;
        ILogicalOperator op = (ILogicalOperator)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)).getValue();
        while (true) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selOper = (SelectOperator)op;
                sel *= this.getSelectivityFromAnnotationMain((ILogicalExpression)selOper.getCondition().getValue(), false);
            }
            if (op.getInputs().size() <= 0) break;
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return sel;
    }
}

