/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.result.IResultMetadata;

public final class PopulateResultMetadataRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        DistributeResultOperator dop = (DistributeResultOperator)op;
        IResultMetadata resultMetadata = dop.getResultMetadata();
        if (resultMetadata == null || resultMetadata.getOutputTypes() != null) {
            return false;
        }
        List exprList = dop.getExpressions();
        ArrayList<Object> exprTypeList = new ArrayList<Object>(exprList.size());
        IVariableTypeEnvironment typeEnv = context.getOutputTypeEnvironment((ILogicalOperator)((Mutable)dop.getInputs().get(0)).getValue());
        for (Mutable exprRef : exprList) {
            exprTypeList.add(typeEnv.getType((ILogicalExpression)exprRef.getValue()));
        }
        resultMetadata.setOutputTypes(exprTypeList);
        return true;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

