/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ByNameToByIndexFieldAccessRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.acceptExpressionTransform(exprRef -> this.rewriteExpressionReference(op, (Mutable<ILogicalExpression>)exprRef, context))) {
            op.removeAnnotation("PUSHED_FIELD_ACCESS");
            context.computeAndSetTypeEnvironmentForOperator(op);
            return true;
        }
        return false;
    }

    private boolean rewriteExpressionReference(ILogicalOperator op, Mutable<ILogicalExpression> exprRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean changed = false;
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
        for (Mutable funcArgRef : fce.getArguments()) {
            if (!this.rewriteExpressionReference(op, (Mutable<ILogicalExpression>)funcArgRef, context)) continue;
            changed = true;
        }
        if (fce.getFunctionIdentifier() != BuiltinFunctions.FIELD_ACCESS_BY_NAME) {
            return changed;
        }
        changed |= this.extractFirstArg(fce, op, context);
        IVariableTypeEnvironment env = context.getOutputTypeEnvironment((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue());
        IAType t = (IAType)env.getType((ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue());
        return changed |= this.rewriteFieldAccess(exprRef, fce, TypeComputeUtils.getActualType((IAType)t));
    }

    private boolean extractFirstArg(AbstractFunctionCallExpression fce, ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression firstArg = (ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue();
        if (firstArg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        SourceLocation sourceLoc = firstArg.getSourceLocation();
        LogicalVariable var1 = context.newVar();
        AssignOperator assignOp = new AssignOperator(new ArrayList<LogicalVariable>(Collections.singletonList(var1)), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)firstArg))));
        assignOp.setSourceLocation(sourceLoc);
        VariableReferenceExpression var1Ref = new VariableReferenceExpression(var1);
        var1Ref.setSourceLocation(sourceLoc);
        ((Mutable)fce.getArguments().get(0)).setValue((Object)var1Ref);
        assignOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue())));
        ((Mutable)op.getInputs().get(0)).setValue((Object)assignOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        return true;
    }

    private boolean rewriteFieldAccess(Mutable<ILogicalExpression> exprRef, AbstractFunctionCallExpression fce, IAType t) {
        boolean changed;
        if (t.getTypeTag() != ATypeTag.OBJECT) {
            return false;
        }
        ILogicalExpression fai = ByNameToByIndexFieldAccessRule.createFieldAccessByIndex((ARecordType)t, fce);
        boolean bl = changed = fai != null;
        if (changed) {
            exprRef.setValue((Object)fai);
        }
        return changed;
    }

    private static ILogicalExpression createFieldAccessByIndex(ARecordType recType, AbstractFunctionCallExpression fce) {
        String s = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)fce, (int)1);
        if (s == null) {
            return null;
        }
        int k = recType.getFieldIndex(s);
        if (k < 0) {
            return null;
        }
        ScalarFunctionCallExpression faExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{(Mutable)fce.getArguments().get(0), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(k))))});
        faExpr.setSourceLocation(fce.getSourceLocation());
        return faExpr;
    }
}

