/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.connectors.ILocalityMap;

public class LocalityAwarePartitionDataWriter
implements IFrameWriter {
    private final IFrameWriter[] pWriters;
    private final boolean[] isWriterOpen;
    private final IFrameTupleAppender[] appenders;
    private final FrameTupleAccessor tupleAccessor;
    private final ITuplePartitionComputer tpc;

    public LocalityAwarePartitionDataWriter(IHyracksTaskContext ctx, IPartitionWriterFactory pwFactory, RecordDescriptor recordDescriptor, ITuplePartitionComputer tpc, int nConsumerPartitions, ILocalityMap localityMap, int senderIndex) throws HyracksDataException {
        int[] consumerPartitions = localityMap.getConsumers(senderIndex, nConsumerPartitions);
        this.pWriters = new IFrameWriter[consumerPartitions.length];
        this.appenders = new IFrameTupleAppender[consumerPartitions.length];
        this.isWriterOpen = new boolean[consumerPartitions.length];
        for (int i = 0; i < consumerPartitions.length; ++i) {
            try {
                this.pWriters[i] = pwFactory.createFrameWriter(consumerPartitions[i]);
                this.appenders[i] = new FrameTupleAppender();
                this.appenders[i].reset((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx), true);
                continue;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.tupleAccessor = new FrameTupleAccessor(recordDescriptor);
        this.tpc = tpc;
    }

    public void open() throws HyracksDataException {
        for (int i = 0; i < this.pWriters.length; ++i) {
            this.isWriterOpen[i] = true;
            this.pWriters[i].open();
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tupleAccessor.reset(buffer);
        int tupleCount = this.tupleAccessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            int h = this.pWriters.length == 1 ? 0 : this.tpc.partition((IFrameTupleAccessor)this.tupleAccessor, i, this.pWriters.length);
            FrameUtils.appendToWriter((IFrameWriter)this.pWriters[h], (IFrameTupleAppender)this.appenders[h], (IFrameTupleAccessor)this.tupleAccessor, (int)i);
        }
    }

    public void fail() throws HyracksDataException {
        HyracksDataException failException = null;
        for (int i = 0; i < this.appenders.length; ++i) {
            if (!this.isWriterOpen[i]) continue;
            try {
                this.pWriters[i].fail();
                continue;
            }
            catch (Throwable th) {
                if (failException == null) {
                    failException = HyracksDataException.create((Throwable)th);
                    continue;
                }
                failException.addSuppressed(th);
            }
        }
        if (failException != null) {
            throw failException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HyracksDataException {
        HyracksDataException closeException = null;
        for (int i = 0; i < this.pWriters.length; ++i) {
            if (!this.isWriterOpen[i]) continue;
            try {
                this.appenders[i].write(this.pWriters[i], true);
                continue;
            }
            catch (Throwable th) {
                if (closeException == null) {
                    closeException = HyracksDataException.create((Throwable)th);
                    continue;
                }
                closeException.addSuppressed(th);
                continue;
            }
            finally {
                try {
                    this.pWriters[i].close();
                }
                catch (Throwable th) {
                    if (closeException == null) {
                        closeException = HyracksDataException.create((Throwable)th);
                    }
                    closeException.addSuppressed(th);
                }
            }
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void flush() throws HyracksDataException {
        for (int i = 0; i < this.pWriters.length; ++i) {
            this.appenders[i].flush(this.pWriters[i]);
        }
    }
}

