/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Date;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.ExternalFileEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class ExternalFileTupleTranslator
extends AbstractTupleTranslator<ExternalFile> {
    private final ExternalFileEntity externalFileEntity;
    protected AMutableInt32 aInt32;
    protected AMutableInt64 aInt64;
    protected AMutableDateTime aDateTime;
    protected ISerializerDeserializer<ADateTime> dateTimeSerde;

    protected ExternalFileTupleTranslator(boolean getTuple, ExternalFileEntity externalFileEntity) {
        super(getTuple, externalFileEntity.getIndex(), externalFileEntity.payloadPosition());
        this.externalFileEntity = externalFileEntity;
        if (getTuple) {
            this.aInt32 = new AMutableInt32(0);
            this.aInt64 = new AMutableInt64(0L);
            this.aDateTime = new AMutableDateTime(0L);
            this.dateTimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
        }
    }

    @Override
    protected ExternalFile createMetadataEntityFromARecord(ARecord externalFileRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)externalFileRecord.getValueByPos(this.externalFileEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.externalFileEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)externalFileRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String datasetName = ((AString)externalFileRecord.getValueByPos(this.externalFileEntity.datasetNameIndex())).getStringValue();
        int fileNumber = ((AInt32)externalFileRecord.getValueByPos(this.externalFileEntity.fileNumberIndex())).getIntegerValue();
        String fileName = ((AString)externalFileRecord.getValueByPos(this.externalFileEntity.fileNameIndex())).getStringValue();
        long fileSize = ((AInt64)externalFileRecord.getValueByPos(this.externalFileEntity.fileSizeIndex())).getLongValue();
        Date lastMoDifiedDate = new Date(((ADateTime)externalFileRecord.getValueByPos(this.externalFileEntity.fileModDateIndex())).getChrononTime());
        DatasetConfig.ExternalFilePendingOp pendingOp = DatasetConfig.ExternalFilePendingOp.values()[((AInt32)externalFileRecord.getValueByPos(this.externalFileEntity.pendingOpIndex())).getIntegerValue()];
        return new ExternalFile(databaseName, dataverseName, datasetName, fileNumber, fileName, lastMoDifiedDate, fileSize, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(ExternalFile externalFile) throws HyracksDataException {
        String dataverseCanonicalName = externalFile.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.externalFileEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(externalFile.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(externalFile.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aInt32.setValue(externalFile.getFileNumber());
        this.int32Serde.serialize((Object)this.aInt32, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.externalFileEntity.getRecordType());
        if (this.externalFileEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(externalFile.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.externalFileEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(externalFile.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.datasetNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(externalFile.getFileNumber());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.fileNumberIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(externalFile.getFileName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.fileNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt64.setValue(externalFile.getSize());
        this.int64Serde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.fileSizeIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aDateTime.setValue(externalFile.getLastModefiedTime().getTime());
        this.dateTimeSerde.serialize((Object)this.aDateTime, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.fileModDateIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(externalFile.getPendingOp().ordinal());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.externalFileEntity.pendingOpIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

