/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.hdfs.web.oauth2.OAuth2Constants;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CredentialBasedAccessTokenProvider
extends AccessTokenProvider {
    public static final String OAUTH_CREDENTIAL_KEY = "dfs.webhdfs.oauth2.credential";
    private AccessTokenTimer timer;
    private String clientId;
    private String refreshURL;
    private String accessToken;
    private boolean initialCredentialObtained = false;

    CredentialBasedAccessTokenProvider() {
        this.timer = new AccessTokenTimer();
    }

    CredentialBasedAccessTokenProvider(Timer timer) {
        this.timer = new AccessTokenTimer(timer);
    }

    public abstract String getCredential();

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.clientId = Utils.notNull(conf, "dfs.webhdfs.oauth2.client.id");
        this.refreshURL = Utils.notNull(conf, "dfs.webhdfs.oauth2.refresh.url");
    }

    @Override
    public synchronized String getAccessToken() throws IOException {
        if (this.timer.shouldRefresh() || !this.initialCredentialObtained) {
            this.refresh();
            this.initialCredentialObtained = true;
        }
        return this.accessToken;
    }

    void refresh() throws IOException {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).build();
        String bodyString = Utils.postBody("client_secret", this.getCredential(), "grant_type", "client_credentials", "client_id", this.clientId);
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)OAuth2Constants.URLENCODED);
        Request request = new Request.Builder().url(this.refreshURL).post(body).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            if (response.code() != 200) {
                throw new IllegalArgumentException("Received invalid http response: " + response.code() + ", text = " + response.toString());
            }
            Map responseBody = (Map)JsonSerialization.mapReader().readValue(response.body().string());
            String newExpiresIn = responseBody.get("expires_in").toString();
            this.timer.setExpiresIn(newExpiresIn);
            this.accessToken = responseBody.get("access_token").toString();
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain access token from credential", e);
        }
    }
}

