/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.compression.file;

import java.util.Objects;
import org.apache.hyracks.api.compression.ICompressorDecompressor;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;

public class CompressedFileReference
extends FileReference {
    private static final long serialVersionUID = 1L;
    private final String lafPath;
    private final FileReference lafFileRef;
    private final transient ICompressorDecompressor compressorDecompressor;

    public CompressedFileReference(IODeviceHandle dev, ICompressorDecompressor compressorDecompressor, String path, String lafPath) {
        super(dev, path);
        this.lafPath = lafPath;
        this.lafFileRef = new FileReference(dev, lafPath);
        this.compressorDecompressor = compressorDecompressor;
    }

    public FileReference getLAFFileReference() {
        return this.lafFileRef;
    }

    public ICompressorDecompressor getCompressorDecompressor() {
        return this.compressorDecompressor;
    }

    public boolean delete() {
        return this.lafFileRef.delete() && super.delete();
    }

    public boolean isCompressed() {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompressedFileReference)) {
            return false;
        }
        return super.equals(o) && this.lafPath.equals(((CompressedFileReference)((Object)o)).lafPath);
    }

    public int hashCode() {
        return Objects.hash(super.getRelativePath(), this.lafPath);
    }

    public String getLAFRelativePath() {
        return this.lafPath;
    }

    public String getLAFAbsolutePath() {
        return this.lafFileRef.getAbsolutePath();
    }
}

