/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.writer.printer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hyracks.api.exceptions.HyracksDataException;

final class TextualOutputStreamDelegate
extends OutputStream {
    private final OutputStream stream;
    private Exception exception;

    TextualOutputStreamDelegate(OutputStream stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.stream.write(b, off, len);
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.stream.write(b);
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.stream.write(b);
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        try {
            this.stream.flush();
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
    }

    void checkError() throws HyracksDataException {
        if (this.exception != null) {
            throw HyracksDataException.create((Throwable)this.exception);
        }
    }
}

