/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.endpoint.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.endpoint.URLEndpoint;
import org.apache.axis2.transport.base.endpoint.URLEndpointsConfiguration;
import org.apache.axis2.transport.base.endpoint.config.URLEndpointFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLEndpointsConfigurationFactory {
    private static final Log log = LogFactory.getLog(URLEndpointsConfigurationFactory.class);

    public URLEndpointsConfiguration create(OMElement element) throws AxisFault {
        Iterator iterator = element.getChildrenWithName(new QName("endpoint"));
        URLEndpointsConfiguration configuration = new URLEndpointsConfiguration();
        URLEndpointFactory fac = new URLEndpointFactory();
        while (iterator.hasNext()) {
            OMElement endpoint = (OMElement)iterator.next();
            URLEndpoint epr = fac.create(endpoint);
            configuration.addEndpoint(epr);
        }
        return configuration;
    }

    public URLEndpointsConfiguration create(String fileName) throws AxisFault {
        File synapseConfigLocation = new File(fileName);
        FileInputStream is = null;
        try {
            is = new FileInputStream(synapseConfigLocation);
        }
        catch (FileNotFoundException e) {
            this.handleException("Error reading file: " + fileName + "for creating the " + "endpoint" + " configurations");
        }
        OMElement element = OMXMLBuilderFactory.createOMBuilder((InputStream)is).getDocumentElement();
        element.build();
        Iterator iterator = element.getChildrenWithName(new QName("endpoint"));
        URLEndpointsConfiguration configuration = new URLEndpointsConfiguration();
        URLEndpointFactory fac = new URLEndpointFactory();
        while (iterator.hasNext()) {
            OMElement endpoint = (OMElement)iterator.next();
            URLEndpoint epr = fac.create(endpoint);
            configuration.addEndpoint(epr);
        }
        return configuration;
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

