/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.util.xml.XMLChar;
import org.w3c.dom.DOMException;

public final class NSUtil {
    private NSUtil() {
    }

    public static void validateName(String name) throws DOMException {
        if (name.length() == 0) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ((i != 0 || XMLChar.isNameStartChar(c)) && (i <= 0 || XMLChar.isNameChar(c))) continue;
            throw DOMExceptionUtil.newDOMException((short)5);
        }
    }

    public static void validatePrefix(String prefix) throws DOMException {
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (c == ':') {
                throw DOMExceptionUtil.newDOMException((short)14);
            }
            if ((i != 0 || XMLChar.isNameStartChar(c)) && (i <= 0 || XMLChar.isNameChar(c))) continue;
            throw DOMExceptionUtil.newDOMException((short)5);
        }
    }

    public static int validateQualifiedName(String qualifiedName) throws DOMException {
        if (qualifiedName.length() == 0) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        int colonPosition = -1;
        boolean checkNameStart = true;
        for (int i = 0; i < qualifiedName.length(); ++i) {
            char c = qualifiedName.charAt(i);
            if (c == ':') {
                if (colonPosition == -1 && i > 0) {
                    colonPosition = i;
                    checkNameStart = true;
                    continue;
                }
                throw DOMExceptionUtil.newDOMException((short)14);
            }
            if (checkNameStart) {
                if (!XMLChar.isNameStartChar(c)) {
                    throw DOMExceptionUtil.newDOMException(XMLChar.isNameChar(c) ? (short)14 : 5);
                }
                checkNameStart = false;
                continue;
            }
            if (XMLChar.isNameChar(c)) continue;
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        if (checkNameStart) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        return colonPosition;
    }

    public static String normalizeNamespaceURI(String namespaceURI) {
        return namespaceURI == null ? "" : namespaceURI;
    }

    public static void validateNamespace(String namespaceURI, String prefix) {
        if (prefix.length() != 0 && namespaceURI.length() == 0) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
    }

    public static void validateAttributeName(String namespaceURI, String localName, String prefix) {
        NSUtil.validateNamespace(namespaceURI, prefix);
        if (prefix.length() == 0 && localName.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        if ("xmlns".equals(prefix)) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
    }

    public static String getDeclaredPrefix(String localName, String prefix) {
        if (prefix.equals("xmlns")) {
            return localName;
        }
        if (prefix.length() == 0 && localName.equals("xmlns")) {
            return "";
        }
        throw DOMExceptionUtil.newDOMException((short)14);
    }
}

