/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.file;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openjdk.tools.javac.file.FSInfo;
import org.openjdk.tools.javac.util.Context;

public class CacheFSInfo
extends FSInfo {
    private final Map<Path, Entry> cache = new ConcurrentHashMap<Path, Entry>();

    public static void preRegister(Context context2) {
        context2.put(FSInfo.class, context -> {
            CacheFSInfo cacheFSInfo = new CacheFSInfo();
            context.put(FSInfo.class, cacheFSInfo);
            return cacheFSInfo;
        });
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Path getCanonicalFile(Path path) {
        Entry entry = this.getEntry(path);
        return entry.canonicalFile;
    }

    @Override
    public boolean exists(Path path) {
        Entry entry = this.getEntry(path);
        return entry.exists;
    }

    @Override
    public boolean isDirectory(Path path) {
        Entry entry = this.getEntry(path);
        return entry.isDirectory;
    }

    @Override
    public boolean isFile(Path path) {
        Entry entry = this.getEntry(path);
        return entry.isFile;
    }

    @Override
    public List<Path> getJarClassPath(Path path) throws IOException {
        Entry entry = this.getEntry(path);
        if (entry.jarClassPath == null) {
            entry.jarClassPath = super.getJarClassPath(path);
        }
        return entry.jarClassPath;
    }

    private Entry getEntry(Path path) {
        Entry entry = this.cache.get(path);
        if (entry == null) {
            entry = new Entry();
            entry.canonicalFile = super.getCanonicalFile(path);
            entry.exists = super.exists(path);
            entry.isDirectory = super.isDirectory(path);
            entry.isFile = super.isFile(path);
            this.cache.put(path, entry);
        }
        return entry;
    }

    private static class Entry {
        Path canonicalFile;
        boolean exists;
        boolean isFile;
        boolean isDirectory;
        List<Path> jarClassPath;

        private Entry() {
        }
    }
}

