/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sandesha2.storage.jdbc;

/**
 * this class is uesd to acquireTransactionLock the transactions util active
 * transaction is finished.
 */
public class TransactionLock {

	//to keep whether an transaction has acquired the storage lock or not
	private boolean isAcquried;

	public void lock() {
		this.isAcquried = true;
	}

	public void release() {
		this.isAcquried = false;
		this.notifyAll();
	}

	public boolean isAcquried() {
		return this.isAcquried;
	}

}
