/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassUseMapper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageElement packageElement;
    final SortedMap<String, Set<TypeElement>> usingPackageToUsedClasses = new TreeMap<String, Set<TypeElement>>();
    protected HtmlTree mainTree = HtmlTree.MAIN();

    public PackageUseWriter(ConfigurationImpl configuration, ClassUseMapper mapper, DocPath filename, PackageElement pkgElement) throws IOException {
        super(configuration, DocPath.forPackage(pkgElement).resolve(filename));
        this.packageElement = pkgElement;
        for (TypeElement usedClass : this.utils.getEnclosedTypeElements(pkgElement)) {
            Set<TypeElement> usingClasses = mapper.classToClass.get(usedClass);
            if (usingClasses == null) continue;
            for (TypeElement usingClass : usingClasses) {
                PackageElement usingPackage = this.utils.containingPackage(usingClass);
                TreeSet<Element> usedClasses = (TreeSet<Element>)this.usingPackageToUsedClasses.get(this.utils.getPackageName(usingPackage));
                if (usedClasses == null) {
                    usedClasses = new TreeSet<Element>(this.utils.makeGeneralPurposeComparator());
                    this.usingPackageToUsedClasses.put(this.utils.getPackageName(usingPackage), usedClasses);
                }
                usedClasses.add(usedClass);
            }
        }
    }

    public static void generate(ConfigurationImpl configuration, ClassUseMapper mapper, PackageElement pkgElement) {
        DocPath filename = DocPaths.PACKAGE_USE;
        try {
            PackageUseWriter pkgusegen = new PackageUseWriter(configuration, mapper, filename, pkgElement);
            pkgusegen.generatePackageUseFile();
            pkgusegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generatePackageUseFile() throws IOException {
        HtmlTree body = this.getPackageUseHeader();
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        if (this.usingPackageToUsedClasses.isEmpty()) {
            div.addContent(this.getResource("doclet.ClassUse_No.usage.of.0", this.utils.getPackageName(this.packageElement)));
        } else {
            this.addPackageUse(div);
        }
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
            body.addContent(this.mainTree);
        } else {
            body.addContent(div);
        }
        HtmlTree tree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : body;
        this.addNavLinks(false, tree);
        this.addBottom(tree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(tree);
        }
        this.printHtmlDocument(null, true, body);
    }

    protected void addPackageUse(Content contentTree) throws IOException {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        if (this.configuration.packages.size() > 1) {
            this.addPackageList(ul);
        }
        this.addClassList(ul);
        contentTree.addContent(ul);
    }

    protected void addPackageList(Content contentTree) throws IOException {
        Content caption = this.getTableCaption(this.configuration.getResource("doclet.ClassUse_Packages.that.use.0", this.getPackageLink(this.packageElement, this.utils.getPackageName(this.packageElement))));
        HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.useSummary, caption) : HtmlTree.TABLE(HtmlStyle.useSummary, this.useTableSummary, caption);
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        boolean altColor = true;
        for (String pkgname : this.usingPackageToUsedClasses.keySet()) {
            PackageElement pkg = this.utils.elementUtils.getPackageElement(pkgname);
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
            altColor = !altColor;
            this.addPackageUse(pkg, tr);
            ((Content)tbody).addContent(tr);
        }
        ((Content)table).addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        contentTree.addContent(li);
    }

    protected void addClassList(Content contentTree) throws IOException {
        List<String> classTableHeader = Arrays.asList(this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")));
        for (String packageName : this.usingPackageToUsedClasses.keySet()) {
            PackageElement usingPackage = this.utils.elementUtils.getPackageElement(packageName);
            HtmlTree li = new HtmlTree(HtmlTag.LI);
            li.addStyle(HtmlStyle.blockList);
            if (usingPackage != null) {
                li.addContent(this.getMarkerAnchor(this.utils.getPackageName(usingPackage)));
            }
            String tableSummary = this.configuration.getText("doclet.Use_Table_Summary", this.configuration.getText("doclet.classes"));
            Content caption = this.getTableCaption(this.configuration.getResource("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLink(this.packageElement, this.utils.getPackageName(this.packageElement)), this.getPackageLink(usingPackage, this.utils.getPackageName(usingPackage))));
            HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.useSummary, caption) : HtmlTree.TABLE(HtmlStyle.useSummary, tableSummary, caption);
            ((Content)table).addContent(this.getSummaryTableHeader(classTableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            boolean altColor = true;
            for (TypeElement te : (Set)this.usingPackageToUsedClasses.get(packageName)) {
                HtmlTree tr = new HtmlTree(HtmlTag.TR);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                altColor = !altColor;
                this.addClassRow(te, usingPackage, tr);
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            li.addContent(table);
            contentTree.addContent(li);
        }
    }

    protected void addClassRow(TypeElement usedClass, PackageElement pkg, Content contentTree) {
        DocPath dp = this.pathString(usedClass, DocPaths.CLASS_USE.resolve(DocPath.forName(this.utils, usedClass)));
        StringContent stringContent = new StringContent(this.utils.getSimpleName(usedClass));
        HtmlTree td = HtmlTree.TD(HtmlStyle.colOne, this.getHyperLink(dp.fragment(this.getPackageAnchorName(pkg)), (Content)stringContent));
        this.addIndexComment(usedClass, td);
        contentTree.addContent(td);
    }

    protected void addPackageUse(PackageElement pkg, Content contentTree) throws IOException {
        HtmlTree tdFirst = HtmlTree.TD(HtmlStyle.colFirst, this.getHyperLink(this.utils.getPackageName(pkg), (Content)new StringContent(this.utils.getPackageName(pkg))));
        contentTree.addContent(tdFirst);
        HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
        tdLast.addStyle(HtmlStyle.colLast);
        if (pkg != null && !pkg.isUnnamed()) {
            this.addSummaryComment(pkg, tdLast);
        } else {
            tdLast.addContent(this.getSpace());
        }
        contentTree.addContent(tdLast);
    }

    protected HtmlTree getPackageUseHeader() {
        String packageText = this.configuration.getText("doclet.Package");
        String name = this.packageElement.isUnnamed() ? "" : this.utils.getPackageName(this.packageElement);
        String title = this.configuration.getText("doclet.Window_ClassUse_Header", packageText, name);
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        ContentBuilder headContent = new ContentBuilder();
        headContent.addContent(this.getResource("doclet.ClassUse_Title", packageText));
        headContent.addContent(new HtmlTree(HtmlTag.BR));
        headContent.addContent(name);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            bodyTree.addContent(div);
        }
        return bodyTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.useLabel);
        return li;
    }

    @Override
    protected Content getNavLinkTree() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

