/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.lease.exp;

import com.twitter.finagle.mux.lease.exp.ByteCounter;
import com.twitter.finagle.mux.lease.exp.JvmInfo;
import com.twitter.finagle.mux.lease.exp.WindowedByteCounter$;
import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Local$;
import com.twitter.util.StorageUnit;
import com.twitter.util.StorageUnit$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d!B\u0001\u0003\u0001\u0011q!aE,j]\u0012|w/\u001a3CsR,7i\\;oi\u0016\u0014(BA\u0002\u0005\u0003\r)\u0007\u0010\u001d\u0006\u0003\u000b\u0019\tQ\u0001\\3bg\u0016T!a\u0002\u0005\u0002\u00075,\bP\u0003\u0002\n\u0015\u00059a-\u001b8bO2,'BA\u0006\r\u0003\u001d!x/\u001b;uKJT\u0011!D\u0001\u0004G>l7\u0003\u0002\u0001\u0010/m\u0001\"\u0001E\u000b\u000e\u0003EQ!AE\n\u0002\t1\fgn\u001a\u0006\u0002)\u0005!!.\u0019<b\u0013\t1\u0012C\u0001\u0004UQJ,\u0017\r\u001a\t\u00031ei\u0011AA\u0005\u00035\t\u00111BQ=uK\u000e{WO\u001c;feB\u0011AdH\u0007\u0002;)\u0011aDC\u0001\u0005kRLG.\u0003\u0002!;\tA1\t\\8tC\ndW\r\u0003\u0005#\u0001\t\u0015\r\u0011\"\u0001%\u0003\u0011IgNZ8\u0004\u0001U\tQ\u0005\u0005\u0002\u0019M%\u0011qE\u0001\u0002\b\u0015Zl\u0017J\u001c4p\u0011!I\u0003A!A!\u0002\u0013)\u0013!B5oM>\u0004\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0007\r$\b\u0010\u0005\u0002.s9\u0011af\u000e\b\u0003_Yr!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005M\u001a\u0013A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\u001f\u0015%\u0011\u0001(H\u0001\u0006\u0019>\u001c\u0017\r\\\u0005\u0003um\u0012qaQ8oi\u0016DHO\u0003\u00029;!1Q\b\u0001C\u0001\ty\na\u0001P5oSRtDcA A\u0003B\u0011\u0001\u0004\u0001\u0005\u0006Eq\u0002\r!\n\u0005\u0006Wq\u0002\r\u0001\f\u0005\u0006{\u0001!\ta\u0011\u000b\u0003\u007f\u0011CQA\t\"A\u0002\u0015BaA\u0012\u0001!\u0002\u00139\u0015AB1mY>\u001c7\u000fE\u0002I\u00176k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u000399K!aT\u000f\u0003\u0017M#xN]1hKVs\u0017\u000e\u001e\u0005\u0007#\u0002\u0001K\u0011\u0002*\u0002\u0007M,X\u000eF\u0001N\u0011\u0019!\u0006\u0001)Q\u0005+\u0006)1m\\;oiB\u0011\u0001JV\u0005\u0003/&\u0013A\u0001T8oO\"\u00121+\u0017\t\u0003\u0011jK!aW%\u0003\u0011Y|G.\u0019;jY\u0016Da!\u0018\u0001!B\u0013q\u0016aA5eqB\u0011\u0001jX\u0005\u0003A&\u00131!\u00138uQ\ta\u0016\fC\u0004d\u0001\u0001\u0007I\u0011\u00013\u0002\r1\f7\u000f^$d+\u0005)\u0007C\u0001\u000fg\u0013\t9WD\u0001\u0003US6,\u0007bB5\u0001\u0001\u0004%\tA[\u0001\u000bY\u0006\u001cHoR2`I\u0015\fHCA6o!\tAE.\u0003\u0002n\u0013\n!QK\\5u\u0011\u001dy\u0007.!AA\u0002\u0015\f1\u0001\u001f\u00132\u0011\u0019\t\b\u0001)Q\u0005K\u00069A.Y:u\u000f\u000e\u0004\u0003F\u00019Z\u0011\u0019!\b\u0001)Q\u0005k\u00069!/\u001e8oS:<\u0007C\u0001%w\u0013\t9\u0018JA\u0004C_>dW-\u00198)\u0005ML\u0006\u0002\u0003>\u0001\u0001\u0004%\t\u0001B>\u0002\u0013A\f7o]\"pk:$X#\u00010\t\u0011u\u0004\u0001\u0019!C\u0001\ty\fQ\u0002]1tg\u000e{WO\u001c;`I\u0015\fHCA6\u0000\u0011\u001dyG0!AA\u0002yCq!a\u0001\u0001A\u0003&a,\u0001\u0006qCN\u001c8i\\;oi\u0002B3!!\u0001Z\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\tAA]1uKR\u0011\u0011Q\u0002\t\u0004\u0011\u0006=\u0011bAA\t\u0013\n1Ai\\;cY\u0016D\u0001\"!\u0006\u0001A\u0013%\u00111B\u0001\tY\u0006\u001cHOU1uK\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0001c\u0001\t\u0002 %\u0019\u0011\u0011E\t\u0003\rM#(/\u001b8h\u0011\u001d\t)\u0003\u0001C!\u0003O\t1A];o)\u0005Y\u0007bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u0006G2|7/\u001a\u000b\u0005\u0003_\t)\u0004\u0005\u0003\u001d\u0003cY\u0017bAA\u001a;\t1a)\u001e;ve\u0016Dq!a\u000e\u0002*\u0001\u0007Q-\u0001\u0005eK\u0006$G.\u001b8f\u000f!\tYD\u0001E\u0001\t\u0005u\u0012aE,j]\u0012|w/\u001a3CsR,7i\\;oi\u0016\u0014\bc\u0001\r\u0002@\u00199\u0011A\u0001E\u0001\t\u0005\u00053\u0003BA \u0003\u0007\u00022\u0001SA#\u0013\r\t9%\u0013\u0002\u0007\u0003:L(+\u001a4\t\u000fu\ny\u0004\"\u0001\u0002LQ\u0011\u0011Q\b\u0005\f\u0003\u001f\nyD1A\u0005\u0002\u0011\t\t&A\u0001X+\t\t\u0019\u0006E\u0002\u001d\u0003+J1!a\u0016\u001e\u0005!!UO]1uS>t\u0007\"CA.\u0003\u007f\u0001\u000b\u0011BA*\u0003\t9\u0006\u0005C\u0006\u0002`\u0005}\"\u0019!C\u0001\t\u0005E\u0013!\u0001)\t\u0013\u0005\r\u0014q\bQ\u0001\n\u0005M\u0013A\u0001)!\u0011)\t9'a\u0010C\u0002\u0013\u0005Aa_\u0001\u0002\u001d\"A\u00111NA A\u0003%a,\u0001\u0002OA\u0001")
public class WindowedByteCounter
extends Thread
implements ByteCounter,
Closable {
    private final JvmInfo info;
    private final Option<?>[] ctx;
    private final StorageUnit[] allocs;
    private volatile long count;
    private volatile int idx;
    private volatile Time lastGc;
    private volatile boolean running;
    private volatile int passCount;

    public final Future<BoxedUnit> close() {
        return Closable.class.close((Closable)this);
    }

    public Future<BoxedUnit> close(Duration after) {
        return Closable.class.close((Closable)this, (Duration)after);
    }

    @Override
    public JvmInfo info() {
        return this.info;
    }

    private StorageUnit sum() {
        int _ = this.idx;
        return (StorageUnit)Predef$.MODULE$.refArrayOps((Object[])this.allocs).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StorageUnit apply(StorageUnit x$1, StorageUnit x$2) {
                return x$1.$plus(x$2);
            }
        });
    }

    @Override
    public Time lastGc() {
        return this.lastGc;
    }

    public void lastGc_$eq(Time x$1) {
        this.lastGc = x$1;
    }

    public int passCount() {
        return this.passCount;
    }

    public void passCount_$eq(int x$1) {
        this.passCount = x$1;
    }

    @Override
    public double rate() {
        return this.sum().inBytes() / WindowedByteCounter$.MODULE$.W().inMilliseconds();
    }

    private double lastRate() {
        return this.allocs[this.idx].inBytes() / WindowedByteCounter$.MODULE$.P().inMilliseconds();
    }

    @Override
    public String toString() {
        return new StringBuilder().append((Object)"WindowedByteCounter(windowed=").append((Object)BoxesRunTime.boxToDouble((double)this.rate())).append((Object)"bpms; last=").append((Object)BoxesRunTime.boxToDouble((double)this.lastRate())).append((Object)"bpms; count=").append((Object)BoxesRunTime.boxToLong((long)this.count)).append((Object)"; sum=").append((Object)this.sum()).append((Object)"bytes)").toString();
    }

    @Override
    public void run() {
        Local$.MODULE$.restore(this.ctx);
        StorageUnit prevUsed = this.info().used();
        while (this.running) {
            Time$.MODULE$.sleep(WindowedByteCounter$.MODULE$.P());
            StorageUnit curUsed = this.info().used();
            long curCount = this.info().generation();
            StorageUnit newlyUsed = curUsed.$minus(prevUsed);
            if (curCount == this.count && newlyUsed.$greater((Object)StorageUnit$.MODULE$.zero())) {
                int nextIdx = (this.idx + 1) % WindowedByteCounter$.MODULE$.N();
                this.allocs[this.idx] = newlyUsed;
                this.idx = nextIdx;
            } else if (curCount == this.count) {
                this.lastGc_$eq(Time$.MODULE$.now());
                this.count = this.info().generation();
            } else {
                this.lastGc_$eq(Time$.MODULE$.now());
                this.count = curCount;
            }
            prevUsed = curUsed;
            this.passCount_$eq(this.passCount() + 1);
        }
    }

    public Future<BoxedUnit> close(Time deadline) {
        this.running = false;
        return Future$.MODULE$.Done();
    }

    public WindowedByteCounter(JvmInfo info, Option<?>[] ctx) {
        this.info = info;
        this.ctx = ctx;
        super("WindowedByteClock");
        Closable.class.$init$((Closable)this);
        this.allocs = (StorageUnit[])Array$.MODULE$.fill(WindowedByteCounter$.MODULE$.N(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StorageUnit apply() {
                return StorageUnit$.MODULE$.zero();
            }
        }, ClassTag$.MODULE$.apply(StorageUnit.class));
        this.count = info.generation();
        this.idx = 0;
        this.lastGc = Time$.MODULE$.now();
        this.running = true;
        this.passCount = 0;
        this.setDaemon(true);
    }

    public WindowedByteCounter(JvmInfo info) {
        this(info, new Option[0]);
    }
}

