/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import java.util.concurrent.CompletionException;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.thrift.service.BulkWriteResponse;
import org.apache.distributedlog.thrift.service.ResponseHeader;
import org.apache.distributedlog.thrift.service.StatusCode;
import org.apache.distributedlog.thrift.service.WriteResponse;

public class ResponseUtils {
    public static ResponseHeader deniedHeader() {
        return new ResponseHeader(StatusCode.REQUEST_DENIED);
    }

    public static ResponseHeader streamUnavailableHeader() {
        return new ResponseHeader(StatusCode.STREAM_UNAVAILABLE);
    }

    public static ResponseHeader successHeader() {
        return new ResponseHeader(StatusCode.SUCCESS);
    }

    public static ResponseHeader ownerToHeader(String owner) {
        return new ResponseHeader(StatusCode.FOUND).setLocation(owner);
    }

    public static ResponseHeader exceptionToHeader(Throwable t) {
        ResponseHeader response = new ResponseHeader();
        if (t instanceof DLException) {
            DLException dle = (DLException)t;
            if (dle instanceof OwnershipAcquireFailedException) {
                response.setLocation(((OwnershipAcquireFailedException)dle).getCurrentOwner());
            }
            response.setCode(StatusCode.findByValue((int)dle.getCode()));
            response.setErrMsg(dle.getMessage());
        } else {
            if (t instanceof CompletionException) {
                return ResponseUtils.exceptionToHeader(t.getCause());
            }
            response.setCode(StatusCode.INTERNAL_SERVER_ERROR);
            response.setErrMsg("Internal server error : " + t.getMessage());
        }
        return response;
    }

    public static WriteResponse write(ResponseHeader responseHeader) {
        return new WriteResponse(responseHeader);
    }

    public static WriteResponse writeSuccess() {
        return new WriteResponse(ResponseUtils.successHeader());
    }

    public static WriteResponse writeDenied() {
        return new WriteResponse(ResponseUtils.deniedHeader());
    }

    public static BulkWriteResponse bulkWrite(ResponseHeader responseHeader) {
        return new BulkWriteResponse(responseHeader);
    }

    public static BulkWriteResponse bulkWriteSuccess() {
        return new BulkWriteResponse(ResponseUtils.successHeader());
    }

    public static BulkWriteResponse bulkWriteDenied() {
        return new BulkWriteResponse(ResponseUtils.deniedHeader());
    }
}

