/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingWriteLacOp
implements BookkeeperInternalCallbacks.WriteLacCallback {
    private static final Logger LOG = LoggerFactory.getLogger(PendingWriteLacOp.class);
    ByteBuf toSend;
    AsyncCallback.AddLacCallback cb;
    long lac;
    Object ctx;
    Set<Integer> writeSet;
    Set<Integer> receivedResponseSet;
    DistributionSchedule.AckSet ackSet;
    boolean completed = false;
    int lastSeenError = -12;
    LedgerHandle lh;
    OpStatsLogger putLacOpLogger;

    PendingWriteLacOp(LedgerHandle lh, AsyncCallback.AddLacCallback cb, Object ctx) {
        this.lh = lh;
        this.cb = cb;
        this.ctx = ctx;
        this.lac = -1L;
        this.ackSet = lh.distributionSchedule.getAckSet();
        this.putLacOpLogger = lh.bk.getWriteLacOpLogger();
    }

    void setLac(long lac) {
        this.lac = lac;
        this.writeSet = new HashSet<Integer>(this.lh.distributionSchedule.getWriteSet(lac));
        this.receivedResponseSet = new HashSet<Integer>(this.writeSet);
    }

    void sendWriteLacRequest(int bookieIndex) {
        this.lh.bk.bookieClient.writeLac(this.lh.metadata.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this.lh.ledgerKey, this.lac, this.toSend, this, bookieIndex);
    }

    void initiate(ByteBuf toSend) {
        this.toSend = toSend;
        for (int bookieIndex : this.writeSet) {
            this.sendWriteLacRequest(bookieIndex);
        }
    }

    @Override
    public void writeLacComplete(int rc, long ledgerId, BookieSocketAddress addr, Object ctx) {
        int bookieIndex = (Integer)ctx;
        if (this.completed) {
            return;
        }
        if (0 != rc) {
            this.lastSeenError = rc;
        }
        this.receivedResponseSet.remove(bookieIndex);
        if (rc == 0) {
            if (this.ackSet.completeBookieAndCheck(bookieIndex) && !this.completed) {
                this.completed = true;
                this.cb.addLacComplete(rc, this.lh, ctx);
                return;
            }
        } else {
            LOG.warn("WriteLac did not succeed: Ledger {} on {}", new Object[]{ledgerId, addr});
        }
        if (this.receivedResponseSet.isEmpty()) {
            this.completed = true;
            this.cb.addLacComplete(this.lastSeenError, this.lh, ctx);
        }
    }
}

