/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.net.CachedDNSToSwitchMapping;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static String normalizeHostName(String name) {
        try {
            return InetAddress.getByName(name).getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }

    public static String resolveNetworkLocation(DNSToSwitchMapping dnsResolver, InetSocketAddress addr) {
        String netLoc;
        ArrayList<String> names = new ArrayList<String>(1);
        if (dnsResolver instanceof CachedDNSToSwitchMapping) {
            names.add(addr.getAddress().getHostAddress());
        } else {
            names.add(addr.getHostName());
        }
        List<String> rNames = dnsResolver.resolve(names);
        if (null == rNames) {
            logger.warn("Failed to resolve network location for {}, using default rack for them : {}.", names, (Object)"/default-region/default-rack");
            netLoc = "/default-region/default-rack";
        } else {
            netLoc = rNames.get(0);
        }
        return netLoc;
    }
}

