/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tls;

import bk-shade.com.google.common.base.Strings;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSContextFactory
implements SecurityHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TLSContextFactory.class);
    private static final String TLSCONTEXT_HANDLER_NAME = "tls";
    private String[] protocols;
    private String[] ciphers;
    private SslContext sslContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPasswordFromFile(String path) throws IOException {
        byte[] pwd;
        try (FileInputStream pwdin = new FileInputStream(path);){
            File passwdFile = new File(path);
            if (passwdFile.length() == 0L) {
                String string = "";
                return string;
            }
            pwd = FileUtils.readFileToByteArray((File)passwdFile);
        }
        return new String(pwd, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String keyStoreType, String keyStoreLocation, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        try (FileInputStream ksin = new FileInputStream(keyStoreLocation);){
            ks.load(ksin, keyStorePassword.trim().toCharArray());
        }
        return ks;
    }

    @Override
    public String getHandlerName() {
        return TLSCONTEXT_HANDLER_NAME;
    }

    private KeyManagerFactory initKeyManagerFactory(String keyStoreType, String keyStoreLocation, String keyStorePasswordPath) throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyManagerFactory kmf = null;
        if (Strings.isNullOrEmpty(keyStoreLocation)) {
            LOG.error("Key store location cannot be empty when Mutual Authentication is enabled!");
            throw new SecurityException("Key store location cannot be empty when Mutual Authentication is enabled!");
        }
        String keyStorePassword = "";
        if (!Strings.isNullOrEmpty(keyStorePasswordPath)) {
            keyStorePassword = this.getPasswordFromFile(keyStorePasswordPath);
        }
        KeyStore ks = this.loadKeyStore(keyStoreType, keyStoreLocation, keyStorePassword);
        kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword.trim().toCharArray());
        return kmf;
    }

    private TrustManagerFactory initTrustManagerFactory(String trustStoreType, String trustStoreLocation, String trustStorePasswordPath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, SecurityException {
        if (Strings.isNullOrEmpty(trustStoreLocation)) {
            LOG.error("Trust Store location cannot be empty!");
            throw new SecurityException("Trust Store location cannot be empty!");
        }
        String trustStorePassword = "";
        if (!Strings.isNullOrEmpty(trustStorePasswordPath)) {
            trustStorePassword = this.getPasswordFromFile(trustStorePasswordPath);
        }
        KeyStore ts = this.loadKeyStore(trustStoreType, trustStoreLocation, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        return tmf;
    }

    private SslProvider getTLSProvider(String sslProvider) {
        if (sslProvider.trim().equalsIgnoreCase("OpenSSL")) {
            if (OpenSsl.isAvailable()) {
                LOG.info("Security provider - OpenSSL");
                return SslProvider.OPENSSL;
            }
            Throwable causeUnavailable = OpenSsl.unavailabilityCause();
            LOG.warn("OpenSSL Unavailable: ", causeUnavailable);
            LOG.info("Security provider - JDK");
            return SslProvider.JDK;
        }
        LOG.info("Security provider - JDK");
        return SslProvider.JDK;
    }

    private void createClientContext(AbstractConfiguration conf) throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyManagerFactory kmf = null;
        TrustManagerFactory tmf = null;
        if (!(conf instanceof ClientConfiguration)) {
            throw new SecurityException("Client configruation not provided");
        }
        ClientConfiguration clientConf = (ClientConfiguration)conf;
        SslProvider provider = this.getTLSProvider(clientConf.getTLSProvider());
        boolean Authentication = clientConf.getTLSClientAuthentication();
        tmf = this.initTrustManagerFactory(clientConf.getTLSTrustStoreType(), clientConf.getTLSTrustStore(), clientConf.getTLSTrustStorePasswordPath());
        if (Authentication) {
            kmf = this.initKeyManagerFactory(clientConf.getTLSKeyStoreType(), clientConf.getTLSKeyStore(), clientConf.getTLSKeyStorePasswordPath());
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().trustManager(tmf).ciphers(null).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(provider).clientAuth(ClientAuth.REQUIRE);
        if (Authentication) {
            sslContextBuilder.keyManager(kmf);
        }
        this.sslContext = sslContextBuilder.build();
    }

    private void createServerContext(AbstractConfiguration conf) throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyManagerFactory kmf = null;
        TrustManagerFactory tmf = null;
        if (!(conf instanceof ServerConfiguration)) {
            throw new SecurityException("Server configruation not provided");
        }
        ServerConfiguration serverConf = (ServerConfiguration)conf;
        SslProvider provider = this.getTLSProvider(serverConf.getTLSProvider());
        boolean Authentication = serverConf.getTLSClientAuthentication();
        kmf = this.initKeyManagerFactory(serverConf.getTLSKeyStoreType(), serverConf.getTLSKeyStore(), serverConf.getTLSKeyStorePasswordPath());
        if (Authentication) {
            tmf = this.initTrustManagerFactory(serverConf.getTLSTrustStoreType(), serverConf.getTLSTrustStore(), serverConf.getTLSTrustStorePasswordPath());
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf).ciphers(null).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(provider).startTls(true);
        if (Authentication) {
            sslContextBuilder.trustManager(tmf).clientAuth(ClientAuth.REQUIRE);
        }
        this.sslContext = sslContextBuilder.build();
    }

    @Override
    public synchronized void init(SecurityHandlerFactory.NodeType type, AbstractConfiguration conf) throws SecurityException {
        String enabledCiphers = conf.getTLSEnabledCipherSuites();
        String enabledProtocols = conf.getTLSEnabledProtocols();
        try {
            switch (type) {
                case Client: {
                    this.createClientContext(conf);
                    break;
                }
                case Server: {
                    this.createServerContext(conf);
                    break;
                }
                default: {
                    throw new SecurityException(new IllegalArgumentException("Invalid NodeType"));
                }
            }
            if (enabledProtocols != null && !enabledProtocols.isEmpty()) {
                this.protocols = enabledProtocols.split(",");
            }
            if (enabledCiphers != null && !enabledCiphers.isEmpty()) {
                this.ciphers = enabledCiphers.split(",");
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Standard keystore type missing", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm missing", e);
        }
        catch (CertificateException e) {
            throw new SecurityException("Unable to load keystore", e);
        }
        catch (IOException e) {
            throw new SecurityException("Error initializing TLSContext", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SecurityException("Unable to load key manager, possibly wrong password given", e);
        }
    }

    @Override
    public SslHandler newTLSHandler() {
        SslHandler sslHandler = this.sslContext.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        if (this.protocols != null && this.protocols.length != 0) {
            sslHandler.engine().setEnabledProtocols(this.protocols);
        }
        if (this.ciphers != null && this.ciphers.length != 0) {
            sslHandler.engine().setEnabledCipherSuites(this.ciphers);
        }
        return sslHandler;
    }
}

