/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.thrift.ChannelBufferToTransport;
import com.twitter.finagle.thrift.ThriftCall;
import com.twitter.finagle.thrift.ThriftReply;
import com.twitter.finagle.thrift.ThriftTypes$;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3Q!\u0001\u0002\u0001\u0005)\u00111\u0003\u00165sS\u001a$8\t\\5f]R$UmY8eKJT!a\u0001\u0003\u0002\rQD'/\u001b4u\u0015\t)a!A\u0004gS:\fw\r\\3\u000b\u0005\u001dA\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0014\u0005\u0001Y\u0001c\u0001\u0007\u001a75\tQB\u0003\u0002\u000f\u001f\u00051!/\u001a9mCfT!\u0001E\t\u0002\u000b\r|G-Z2\u000b\u0005I\u0019\u0012a\u00025b]\u0012dWM\u001d\u0006\u0003)U\tQA\\3uifT!AF\f\u0002\u000b)\u0014wn]:\u000b\u0003a\t1a\u001c:h\u0013\tQRB\u0001\tSKBd\u0017-_5oO\u0012+7m\u001c3feB\u0011A\u0002H\u0005\u0003;5\u0011\u0001BV8jI\u0016sW/\u001c\u0005\t?\u0001\u0011\t\u0011)A\u0005C\u0005y\u0001O]8u_\u000e|GNR1di>\u0014\u0018p\u0001\u0001\u0011\u0005\tBS\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00039s_R|7m\u001c7\u000b\u0005\r1#BA\u0014\u0018\u0003\u0019\t\u0007/Y2iK&\u0011\u0011f\t\u0002\u0011)B\u0013x\u000e^8d_24\u0015m\u0019;pefDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDCA\u00170!\tq\u0003!D\u0001\u0003\u0011\u0015y\"\u00061\u0001\"\u0011\u0015\t\u0004\u0001\"\u00013\u0003E!WmY8eKRC'/\u001b4u%\u0016\u0004H.\u001f\u000b\u0005gm\u001au\t\u0005\u00025s5\tQG\u0003\u00027o\u0005!A.\u00198h\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\r=\u0013'.Z2u\u0011\u0015a\u0004\u00071\u0001>\u0003\r\u0019G\u000f\u001f\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001N\tqa\u00195b]:,G.\u0003\u0002C\u007f\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"\u0002!1\u0001\u0004!\u0005C\u0001 F\u0013\t1uHA\u0004DQ\u0006tg.\u001a7\t\u000b!\u0003\u0004\u0019A%\u0002\r\t,hMZ3s!\tQE*D\u0001L\u0015\tA5#\u0003\u0002N\u0017\ni1\t[1o]\u0016d')\u001e4gKJDQa\u0014\u0001\u0005BA\u000ba\u0001Z3d_\u0012,G#B\u001aR%N#\u0006\"\u0002\u001fO\u0001\u0004i\u0004\"\u0002!O\u0001\u0004!\u0005\"\u0002%O\u0001\u0004I\u0005\"B+O\u0001\u0004Y\u0012!B:uCR,\u0007")
public class ThriftClientDecoder
extends ReplayingDecoder<VoidEnum> {
    private final TProtocolFactory protocolFactory;

    public Object decodeThriftReply(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
        ThriftReply<?> thriftReply;
        ChannelBufferToTransport transport = new ChannelBufferToTransport(buffer);
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
        TMessage message = protocol.readMessageBegin();
        byte by = message.type;
        switch (by) {
            default: {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new TApplicationException(2));
                thriftReply = null;
                break;
            }
            case 2: {
                ThriftCall<?, ?> call = ThriftTypes$.MODULE$.apply(message.name).newInstance();
                Object result = call.readResponse(protocol);
                thriftReply = call.reply(result);
                break;
            }
            case 3: {
                TApplicationException exception = TApplicationException.read((TProtocol)protocol);
                protocol.readMessageEnd();
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)exception);
                thriftReply = null;
            }
        }
        return thriftReply;
    }

    public Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) {
        return buffer.readable() ? this.decodeThriftReply(ctx, channel, buffer) : null;
    }

    public ThriftClientDecoder(TProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }
}

