/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.serverset;

import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.common.zookeeper.ServerSets;
import com.twitter.common.zookeeper.ZooKeeperClient;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLZkServerSet {
    private static final Logger logger = LoggerFactory.getLogger(DLZkServerSet.class);
    static final String ZNODE_WRITE_PROXY = ".write_proxy";
    private final ZooKeeperClient zkClient;
    private final ServerSet zkServerSet;

    private static String getZKServersFromDLUri(URI uri) {
        return uri.getAuthority().replace(";", ",");
    }

    private static Iterable<InetSocketAddress> getZkAddresses(URI uri) {
        String zkServers = DLZkServerSet.getZKServersFromDLUri(uri);
        String[] zkServerList = StringUtils.split((String)zkServers, (char)',');
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String zkServer : zkServerList) {
            HostAndPort hostAndPort = HostAndPort.fromString((String)zkServer).withDefaultPort(2181);
            builder.add((Object)InetSocketAddress.createUnresolved(hostAndPort.getHostText(), hostAndPort.getPort()));
        }
        return builder.build();
    }

    public static DLZkServerSet of(URI uri, int zkSessionTimeoutMs) {
        String zkPath = uri.getPath() + "/" + ZNODE_WRITE_PROXY;
        Iterable<InetSocketAddress> zkAddresses = DLZkServerSet.getZkAddresses(uri);
        ZooKeeperClient zkClient = new ZooKeeperClient(Amount.of((int)zkSessionTimeoutMs, (Unit)Time.MILLISECONDS), zkAddresses);
        ServerSet serverSet = ServerSets.create((ZooKeeperClient)zkClient, (Iterable)ZooDefs.Ids.OPEN_ACL_UNSAFE, (String)zkPath);
        return new DLZkServerSet(zkClient, serverSet);
    }

    public DLZkServerSet(ZooKeeperClient zkClient, ServerSet zkServerSet) {
        this.zkClient = zkClient;
        this.zkServerSet = zkServerSet;
    }

    public ZooKeeperClient getZkClient() {
        return this.zkClient;
    }

    public ServerSet getServerSet() {
        return this.zkServerSet;
    }

    public void close() {
        this.zkClient.close();
    }
}

