/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.twitter.common.base.ExceptionalSupplier;
import com.twitter.common.base.Function;
import javax.annotation.Nullable;

public final class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    private Either(Optional<L> left, Optional<R> right) {
        this.left = left;
        this.right = right;
    }

    public Either<R, L> swap() {
        return new Either<R, L>(this.right, this.left);
    }

    public Optional<L> left() {
        return this.left;
    }

    public Optional<R> right() {
        return this.right;
    }

    public boolean isLeft() {
        return this.left().isPresent();
    }

    public boolean isRight() {
        return this.right().isPresent();
    }

    public L getLeft() {
        return (L)this.left().get();
    }

    public R getRight() {
        return (R)this.right().get();
    }

    public <M> Either<M, R> mapLeft(Function<? super L, M> transformer) {
        if (this.isLeft()) {
            return Either.left(transformer.apply(this.getLeft()));
        }
        Either self = this;
        return self;
    }

    public <M> Either<L, M> mapRight(Function<? super R, M> transformer) {
        if (this.isRight()) {
            return Either.right(transformer.apply(this.getRight()));
        }
        Either self = this;
        return self;
    }

    public static <L, R, T> Transformer<L, R, T> transformer(final Function<? super L, T> leftTransformer, final Function<? super R, T> rightTransformer) {
        return new Transformer<L, R, T>(){

            @Override
            public T mapLeft(L item) {
                return leftTransformer.apply(item);
            }

            @Override
            public T mapRight(R item) {
                return rightTransformer.apply(item);
            }
        };
    }

    public <T> T map(Transformer<? super L, ? super R, T> transformer) {
        if (this.isLeft()) {
            return transformer.mapLeft(this.getLeft());
        }
        return transformer.mapRight(this.getRight());
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Either)) {
            return false;
        }
        Either other = (Either)o;
        return Objects.equal(this.left, other.left) && Objects.equal(this.right, other.right);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.left, this.right});
    }

    public String toString() {
        if (this.isLeft()) {
            return String.format("Left(%s)", this.getLeft());
        }
        return String.format("Right(%s)", this.getRight());
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Either<L, R>(Optional.of(value), Optional.absent());
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either<L, R>(Optional.absent(), Optional.of(value));
    }

    public static <L, R> Iterable<L> lefts(Iterable<Either<L, R>> results) {
        return Optional.presentInstances((Iterable)Iterables.transform(results, (com.google.common.base.Function)new Function<Either<L, R>, Optional<L>>(){

            @Override
            public Optional<L> apply(Either<L, R> item) {
                return item.left();
            }
        }));
    }

    public static <L, R> Iterable<R> rights(Iterable<Either<L, R>> results) {
        return Optional.presentInstances((Iterable)Iterables.transform(results, (com.google.common.base.Function)new Function<Either<L, R>, Optional<R>>(){

            @Override
            public Optional<R> apply(Either<L, R> item) {
                return item.right();
            }
        }));
    }

    public static <X extends Exception, R> Either<X, R> guard(Class<X> exceptionType, ExceptionalSupplier<R, X> work) {
        Either<X, R> either = Either.guard(work, exceptionType, new Class[0]);
        return either;
    }

    public static <X extends Exception, R> Either<X, R> guard(ExceptionalSupplier<R, X> work, Class<? extends X> exceptionType, Class<? extends X> ... rest) {
        return Either.guard(Lists.asList(exceptionType, (Object[])rest), work);
    }

    public static <X extends Exception, R> Either<X, R> guard(Iterable<Class<? extends X>> exceptionTypes, ExceptionalSupplier<R, X> work) {
        try {
            return Either.right(work.get());
        }
        catch (Exception e) {
            for (Class<X> exceptionType : exceptionTypes) {
                if (!exceptionType.isInstance(e)) continue;
                Exception exception = (Exception)exceptionType.cast(e);
                return Either.left(exception);
            }
            throw new UnguardedException(e);
        }
    }

    public static class UnguardedException
    extends RuntimeException {
        public UnguardedException(Throwable cause) {
            super(cause);
        }
    }

    public static abstract class Transformer<L, R, T>
    implements Function<Either<L, R>, T> {
        public abstract T mapLeft(L var1);

        public abstract T mapRight(R var1);

        @Override
        public final T apply(Either<L, R> either) {
            return either.map(this);
        }
    }
}

