/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.RequestDeniedException;
import org.apache.distributedlog.protocol.util.ProtocolUtils;
import org.apache.distributedlog.protocol.util.TwitterFutureUtils;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.config.ServerConfiguration;
import org.apache.distributedlog.service.stream.AbstractWriteOp;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.service.stream.WriteOpWithPayload;
import org.apache.distributedlog.service.streamset.Partition;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.apache.distributedlog.thrift.service.ResponseHeader;
import org.apache.distributedlog.thrift.service.StatusCode;
import org.apache.distributedlog.thrift.service.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class WriteOp
extends AbstractWriteOp
implements WriteOpWithPayload {
    private static final Logger logger = LoggerFactory.getLogger(WriteOp.class);
    private final ByteBuffer payload;
    private final boolean isRecordSet;
    private final Counter deniedWriteCounter;
    private final Counter successRecordCounter;
    private final Counter failureRecordCounter;
    private final Counter redirectRecordCounter;
    private final OpStatsLogger latencyStat;
    private final Counter bytes;
    private final Counter writeBytes;
    private final byte dlsnVersion;
    private final AccessControlManager accessControlManager;

    public WriteOp(String stream, ByteBuffer data, StatsLogger statsLogger, StatsLogger perStreamStatsLogger, StreamPartitionConverter streamPartitionConverter, ServerConfiguration conf, byte dlsnVersion, Long checksum, boolean isRecordSet, Feature checksumDisabledFeature, AccessControlManager accessControlManager) {
        super(stream, WriteOp.requestStat(statsLogger, "write"), checksum, checksumDisabledFeature);
        this.payload = data;
        this.isRecordSet = isRecordSet;
        Partition partition = streamPartitionConverter.convert(stream);
        StreamOpStats streamOpStats = new StreamOpStats(statsLogger, perStreamStatsLogger);
        this.successRecordCounter = streamOpStats.recordsCounter("success");
        this.failureRecordCounter = streamOpStats.recordsCounter("failure");
        this.redirectRecordCounter = streamOpStats.recordsCounter("redirect");
        this.deniedWriteCounter = streamOpStats.requestDeniedCounter("write");
        this.writeBytes = streamOpStats.scopedRequestCounter("write", "bytes");
        this.latencyStat = streamOpStats.streamRequestLatencyStat(partition, "write");
        this.bytes = streamOpStats.streamRequestCounter(partition, "write", "bytes");
        this.dlsnVersion = dlsnVersion;
        this.accessControlManager = accessControlManager;
        final long size = this.getPayloadSize();
        this.result().addEventListener((FutureEventListener)new FutureEventListener<WriteResponse>(){

            public void onSuccess(WriteResponse response) {
                if (response.getHeader().getCode() == StatusCode.SUCCESS) {
                    WriteOp.this.latencyStat.registerSuccessfulEvent(WriteOp.this.stopwatch().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                    WriteOp.this.bytes.add(size);
                    WriteOp.this.writeBytes.add(size);
                } else {
                    WriteOp.this.latencyStat.registerFailedEvent(WriteOp.this.stopwatch().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                }
            }

            public void onFailure(Throwable cause) {
                WriteOp.this.latencyStat.registerFailedEvent(WriteOp.this.stopwatch().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        });
    }

    @Override
    public long getPayloadSize() {
        return this.payload.remaining();
    }

    @Override
    public Long computeChecksum() {
        return ProtocolUtils.writeOpCRC32((String)this.stream, (ByteBuffer)this.payload.duplicate());
    }

    @Override
    public void preExecute() throws DLException {
        if (!this.accessControlManager.allowWrite(this.stream)) {
            this.deniedWriteCounter.inc();
            throw new RequestDeniedException(this.stream, "write");
        }
        super.preExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Future<WriteResponse> executeOp(AsyncLogWriter writer, Sequencer sequencer, Object txnLock) {
        Future writeResult;
        if (!this.stream.equals(writer.getStreamName())) {
            logger.error("Write: Stream Name Mismatch in the Stream Map {}, {}", (Object)this.stream, (Object)writer.getStreamName());
            return Future.exception((Throwable)new IllegalStateException("The stream mapping is incorrect, fail the request"));
        }
        Object object = txnLock;
        synchronized (object) {
            long txnId = sequencer.nextId();
            LogRecord record = new LogRecord(txnId, this.payload);
            if (this.isRecordSet) {
                record.setRecordSet();
            }
            writeResult = TwitterFutureUtils.newTFuture((CompletableFuture)writer.write(record));
        }
        return writeResult.map((Function1)new AbstractFunction1<DLSN, WriteResponse>(){

            public WriteResponse apply(DLSN value) {
                WriteOp.this.successRecordCounter.inc();
                return ResponseUtils.writeSuccess().setDlsn(value.serialize(WriteOp.this.dlsnVersion));
            }
        });
    }

    @Override
    protected void fail(ResponseHeader header) {
        if (StatusCode.FOUND == header.getCode()) {
            this.redirectRecordCounter.inc();
        } else {
            this.failureRecordCounter.inc();
        }
        super.fail(header);
    }
}

