/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.classloading;

import com.google.common.base.Preconditions;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.classloading.ClassLoaderFromBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class ClassLoaderFromStackOfBrooklynClassLoadingContext
extends ClassLoader {
    private final Stack<BrooklynClassLoadingContext> contexts = new Stack();
    private final Stack<ClassLoader> cls = new Stack();
    private final AtomicReference<Thread> lockOwner = new AtomicReference();
    private ManagementContext mgmt;
    private ClassLoader currentClassLoader;
    private AtomicReference<ClassLoaderUtils> currentLoader = new AtomicReference();
    private int lockCount;

    public ClassLoaderFromStackOfBrooklynClassLoadingContext(ClassLoader classLoader) {
        this.setCurrentClassLoader(classLoader);
    }

    public void setManagementContext(ManagementContext mgmt) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.currentLoader.set(new ClassLoaderUtils(this.currentClassLoader, mgmt));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.currentLoader.get().loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public void pushClassLoadingContext(BrooklynClassLoadingContext clcNew) {
        this.acquireLock();
        Object oldClc = !this.contexts.isEmpty() ? this.contexts.peek() : JavaBrooklynClassLoadingContext.create(this.mgmt, this.getCurrentClassLoader());
        BrooklynClassLoadingContextSequential clcMerged = new BrooklynClassLoadingContextSequential(this.mgmt, new BrooklynClassLoadingContext[]{oldClc, clcNew});
        ClassLoader newCL = ClassLoaderFromBrooklynClassLoadingContext.of(clcMerged);
        this.contexts.push(clcMerged);
        this.cls.push(this.getCurrentClassLoader());
        this.setCurrentClassLoader(newCL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popClassLoadingContext() {
        AtomicReference<Thread> atomicReference = this.lockOwner;
        synchronized (atomicReference) {
            this.releaseLock();
            this.setCurrentClassLoader(this.cls.pop());
            this.contexts.pop();
        }
    }

    private ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    private void setCurrentClassLoader(ClassLoader classLoader) {
        this.currentClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.currentLoader.set(new ClassLoaderUtils(this.currentClassLoader, this.mgmt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireLock() {
        AtomicReference<Thread> atomicReference = this.lockOwner;
        synchronized (atomicReference) {
            while (!this.lockOwner.compareAndSet(null, Thread.currentThread()) && !Thread.currentThread().equals(this.lockOwner.get())) {
                try {
                    this.lockOwner.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            ++this.lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock() {
        AtomicReference<Thread> atomicReference = this.lockOwner;
        synchronized (atomicReference) {
            if (this.lockCount <= 0) {
                throw new IllegalStateException("not locked");
            }
            if (--this.lockCount == 0) {
                if (!this.lockOwner.compareAndSet(Thread.currentThread(), null)) {
                    Thread oldOwner = this.lockOwner.getAndSet(null);
                    throw new IllegalStateException("locked by " + oldOwner + " but unlock attempt by " + Thread.currentThread());
                }
                this.lockOwner.notifyAll();
            }
        }
    }
}

