/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.rest.api.ApplicationApi;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.domain.ApplicationSpec;
import org.apache.brooklyn.rest.domain.ApplicationSummary;
import org.apache.brooklyn.rest.domain.Status;
import org.apache.brooklyn.rest.util.WebResourceUtils;

public class ApplicationTransformer {
    public static Function<? super Application, ApplicationSummary> fromApplication(final UriBuilder ub) {
        return new Function<Application, ApplicationSummary>(){

            public ApplicationSummary apply(Application application) {
                return ApplicationTransformer.summaryFromApplication(application, ub);
            }
        };
    }

    public static Status statusFromApplication(Application application) {
        if (application == null) {
            return Status.UNKNOWN;
        }
        Lifecycle state = (Lifecycle)application.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
        if (state != null) {
            return ApplicationTransformer.statusFromLifecycle(state);
        }
        Boolean up = (Boolean)application.getAttribute(Startable.SERVICE_UP);
        if (up != null && up.booleanValue()) {
            return Status.RUNNING;
        }
        return Status.UNKNOWN;
    }

    public static Status statusFromLifecycle(Lifecycle state) {
        if (state == null) {
            return Status.UNKNOWN;
        }
        switch (state) {
            case CREATED: {
                return Status.ACCEPTED;
            }
            case STARTING: {
                return Status.STARTING;
            }
            case RUNNING: {
                return Status.RUNNING;
            }
            case STOPPING: {
                return Status.STOPPING;
            }
            case STOPPED: {
                return Status.STOPPED;
            }
            case DESTROYED: {
                return Status.DESTROYED;
            }
            case ON_FIRE: {
                return Status.ERROR;
            }
        }
        return Status.UNKNOWN;
    }

    public static ApplicationSpec specFromApplication(Application application) {
        Collection locations = Collections2.transform((Collection)application.getLocations(), (Function)new Function<Location, String>(){

            @Nullable
            public String apply(@Nullable Location input) {
                return input.getId();
            }
        });
        return new ApplicationSpec(application.getDisplayName(), application.getEntityType().getName(), null, locations, null);
    }

    public static ApplicationSummary summaryFromApplication(Application application, UriBuilder ub) {
        ImmutableMap links;
        if (application.getId() == null) {
            links = Collections.emptyMap();
        } else {
            URI selfUri = WebResourceUtils.serviceUriBuilder(ub, ApplicationApi.class, "get").build(new Object[]{application.getId()});
            URI entitiesUri = WebResourceUtils.resourceUriBuilder(ub, EntityApi.class).build(new Object[]{application.getId()});
            links = ImmutableMap.of((Object)"self", (Object)selfUri, (Object)"entities", (Object)entitiesUri);
        }
        return new ApplicationSummary(application.getId(), ApplicationTransformer.specFromApplication(application), ApplicationTransformer.statusFromApplication(application), links);
    }
}

