/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.rest.domain.HighAvailabilitySummary;

public class HighAvailabilityTransformer {
    public static HighAvailabilitySummary highAvailabilitySummary(String ownNodeId, ManagementPlaneSyncRecord memento) {
        LinkedHashMap nodes = Maps.newLinkedHashMap();
        for (Map.Entry entry : memento.getManagementNodes().entrySet()) {
            nodes.put(entry.getKey(), HighAvailabilityTransformer.haNodeSummary((ManagementNodeSyncRecord)entry.getValue()));
        }
        ImmutableMap.Builder lb = ImmutableMap.builder();
        return new HighAvailabilitySummary(memento.getPlaneId(), ownNodeId, memento.getMasterNodeId(), (Map)nodes, (Map)lb.build());
    }

    public static HighAvailabilitySummary.HaNodeSummary haNodeSummary(ManagementNodeSyncRecord memento) {
        String status = memento.getStatus() == null ? null : memento.getStatus().toString();
        return new HighAvailabilitySummary.HaNodeSummary(memento.getNodeId(), memento.getUri(), status, Long.valueOf(memento.getLocalTimestamp()), memento.getRemoteTimestamp());
    }
}

