/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum ObjectType {
    VIRTUAL_SERVER,
    LOAD_BALANCER,
    CLOUD_STORAGE,
    STORAGE_DNS,
    SERVER_IMAGE,
    DEDICATED_SERVER,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static ObjectType fromValue(String type) {
        if ("StorageDNS".equals(type)) {
            return STORAGE_DNS;
        }
        try {
            return ObjectType.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

