/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.WildcardGlobs;

public class StringPredicates {
    public static <T extends CharSequence> Predicate<T> isBlank() {
        return new IsBlank();
    }

    @Deprecated
    private static Predicate<CharSequence> isBlankOld() {
        return new Predicate<CharSequence>(){

            public boolean apply(@Nullable CharSequence input) {
                return Strings.isBlank(input);
            }

            public String toString() {
                return "isBlank";
            }
        };
    }

    public static <T> Predicate<T> isNonBlank() {
        return new IsNonBlank();
    }

    public static <T extends CharSequence> Predicate<T> containsLiteralIgnoreCase(String fragment) {
        return new ContainsLiteralIgnoreCase(fragment);
    }

    public static <T extends CharSequence> Predicate<T> containsLiteral(String fragment) {
        return new ContainsLiteral(fragment);
    }

    @Deprecated
    private static Predicate<CharSequence> containsLiteralCaseInsensitiveOld(final String fragment) {
        return new Predicate<CharSequence>(){

            public boolean apply(@Nullable CharSequence input) {
                return Strings.containsLiteralIgnoreCase(input, fragment);
            }

            public String toString() {
                return "containsLiteralCaseInsensitive(" + fragment + ")";
            }
        };
    }

    @Deprecated
    private static Predicate<CharSequence> containsLiteralOld(final String fragment) {
        return new Predicate<CharSequence>(){

            public boolean apply(@Nullable CharSequence input) {
                return Strings.containsLiteral(input, fragment);
            }

            public String toString() {
                return "containsLiteral(" + fragment + ")";
            }
        };
    }

    public static <T extends CharSequence> Predicate<T> containsAllLiterals(String ... fragments) {
        ArrayList fragmentPredicates = Lists.newArrayList();
        for (String fragment : fragments) {
            fragmentPredicates.add(StringPredicates.containsLiteral(fragment));
        }
        return Predicates.and((Iterable)fragmentPredicates);
    }

    @Deprecated
    private static Predicate<CharSequence> containsAllLiteralsOld(String ... fragments) {
        return Predicates.and((Iterable)Iterables.transform(Arrays.asList(fragments), (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String input) {
                return StringPredicates.containsLiteral(input);
            }
        }));
    }

    public static Predicate<CharSequence> containsRegex(String regex) {
        return Predicates.containsPattern((String)regex);
    }

    public static <T extends CharSequence> Predicate<T> startsWith(String prefix) {
        return new StartsWith(prefix);
    }

    @Deprecated
    private static Predicate<CharSequence> startsWithOld(final String prefix) {
        return new Predicate<CharSequence>(){

            public boolean apply(CharSequence input) {
                return input != null && input.toString().startsWith(prefix);
            }
        };
    }

    public static Predicate<Object> isStringStartingWith(String prefix) {
        return Predicates.and((Predicate)Predicates.instanceOf(CharSequence.class), (Predicate)Predicates.compose(StringPredicates.startsWith(prefix), StringFunctions.toStringFunction()));
    }

    @Deprecated
    private static Predicate<Object> isStringStartingWithOld(final String prefix) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof CharSequence && input.toString().startsWith(prefix);
            }
        };
    }

    public static <T> Predicate<T> equalToAny(Iterable<T> vals) {
        return new EqualToAny<T>(vals);
    }

    public static <T extends CharSequence> Predicate<T> matchesRegex(String regex) {
        return new MatchesRegex(regex);
    }

    public static <T extends CharSequence> Predicate<T> matchesGlob(String glob) {
        return new MatchesGlob(glob);
    }

    protected static class MatchesGlob<T extends CharSequence>
    implements Predicate<T> {
        protected final String glob;

        protected MatchesGlob(String glob) {
            this.glob = glob;
        }

        public boolean apply(CharSequence input) {
            return input != null && WildcardGlobs.isGlobMatched(this.glob, input.toString());
        }

        public String toString() {
            return "matchesGlob(" + StringEscapes.JavaStringEscapes.wrapJavaString(this.glob) + ")";
        }
    }

    protected static class MatchesRegex<T extends CharSequence>
    implements Predicate<T> {
        protected final String regex;

        protected MatchesRegex(String regex) {
            this.regex = regex;
        }

        public boolean apply(CharSequence input) {
            return input != null && input.toString().matches(this.regex);
        }

        public String toString() {
            return "matchesRegex(" + StringEscapes.JavaStringEscapes.wrapJavaString(this.regex) + ")";
        }
    }

    private static class EqualToAny<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 6209304291945204422L;
        private final Set<T> vals;

        public EqualToAny(Iterable<? extends T> vals) {
            this.vals = MutableSet.copyOf(vals);
        }

        public boolean apply(T input) {
            return this.vals.contains(input);
        }

        public String toString() {
            return "equalToAny(" + this.vals + ")";
        }
    }

    private static final class StartsWith<T extends CharSequence>
    implements Predicate<T> {
        private final String prefix;

        private StartsWith(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(CharSequence input) {
            return input != null && input.toString().startsWith(this.prefix);
        }

        public String toString() {
            return "startsWith(" + StringEscapes.JavaStringEscapes.wrapJavaString(this.prefix) + ")";
        }
    }

    private static final class ContainsLiteral<T extends CharSequence>
    implements Predicate<T> {
        private final String fragment;

        private ContainsLiteral(String fragment) {
            this.fragment = fragment;
        }

        public boolean apply(@Nullable CharSequence input) {
            return Strings.containsLiteral(input, this.fragment);
        }

        public String toString() {
            return "containsLiteral(" + StringEscapes.JavaStringEscapes.wrapJavaString(this.fragment) + ")";
        }
    }

    private static final class ContainsLiteralIgnoreCase<T extends CharSequence>
    implements Predicate<T> {
        private final String fragment;

        private ContainsLiteralIgnoreCase(String fragment) {
            this.fragment = fragment;
        }

        public boolean apply(@Nullable CharSequence input) {
            return Strings.containsLiteralIgnoreCase(input, this.fragment);
        }

        public String toString() {
            return "containsLiteralCaseInsensitive(" + StringEscapes.JavaStringEscapes.wrapJavaString(this.fragment) + ")";
        }
    }

    private static final class IsNonBlank<T>
    implements Predicate<T> {
        private IsNonBlank() {
        }

        public boolean apply(@Nullable Object input) {
            if (input == null) {
                return false;
            }
            if (!(input instanceof CharSequence)) {
                return true;
            }
            return Strings.isNonBlank((CharSequence)input);
        }

        public String toString() {
            return "isNonBlank()";
        }
    }

    private static final class IsBlank<T extends CharSequence>
    implements Predicate<T> {
        private IsBlank() {
        }

        public boolean apply(@Nullable CharSequence input) {
            return Strings.isBlank(input);
        }

        public String toString() {
            return "isBlank()";
        }
    }
}

