/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.time;

import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import org.apache.brooklyn.util.time.Time;

public class Timestamp
extends Date {
    public Timestamp(Date d) {
        super(d.getTime());
    }

    public Timestamp(Calendar d) {
        this(d.getTime());
    }

    public Timestamp(Instant d) {
        this(d.toEpochMilli());
    }

    public Timestamp(long l) {
        this(new Calendar.Builder().setInstant(l).build());
    }

    public Timestamp(String s) {
        this(Time.parseCalendar(s));
    }

    private Timestamp() {
        this(Calendar.getInstance());
    }

    public static Timestamp fromString(String s) {
        return new Timestamp(s);
    }

    public Calendar toCalendar() {
        return new Calendar.Builder().setInstant(this).build();
    }

    @Override
    public String toString() {
        return Time.makeDateString(this);
    }
}

