/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.reflect.Invokable;
import com.google.inject.Injector;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.Fallback;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.config.InvocationConfig;
import org.jclouds.util.Maps2;
import org.jclouds.util.Predicates2;

@Singleton
@Beta
public class ReadAnnotationsAndProperties
implements InvocationConfig {
    private final Injector injector;
    private final Fallback<Object> defaultFallback;
    private final Map<String, Long> timeouts;

    @Inject
    ReadAnnotationsAndProperties(Injector injector, Function<Predicate<String>, Map<String, String>> filterStringsBoundByName, Fallback<Object> defaultFallback) {
        this.injector = injector;
        this.defaultFallback = defaultFallback;
        this.timeouts = ReadAnnotationsAndProperties.timeouts(filterStringsBoundByName);
    }

    @Override
    public Optional<Long> getTimeoutNanos(Invocation in) {
        String commandName = this.getCommandName(in);
        Optional defaultMillis = Optional.fromNullable((Object)this.timeouts.get("default"));
        Optional timeoutMillis = Optional.fromNullable((Object)this.timeouts.get(commandName));
        Invokable<?, ?> invoked = in.getInvokable();
        if (invoked.isAnnotationPresent(Named.class)) {
            timeoutMillis = timeoutMillis.or(defaultMillis);
        } else {
            String className = invoked.getOwnerType().getRawType().getSimpleName();
            timeoutMillis = timeoutMillis.or(Optional.fromNullable((Object)this.timeouts.get(className))).or(defaultMillis);
        }
        if (timeoutMillis.isPresent()) {
            return Optional.of((Object)TimeUnit.MILLISECONDS.toNanos((Long)timeoutMillis.get()));
        }
        return Optional.absent();
    }

    @Override
    public String getCommandName(Invocation invocation) {
        Invokable<?, ?> invoked = invocation.getInvokable();
        if (invoked.isAnnotationPresent(Named.class)) {
            return ((Named)invoked.getAnnotation(Named.class)).value();
        }
        String className = invoked.getOwnerType().getRawType().getSimpleName();
        return className + "." + invoked.getName();
    }

    @Override
    public Fallback<?> getFallback(Invocation invocation) {
        org.jclouds.rest.annotations.Fallback fallback = (org.jclouds.rest.annotations.Fallback)invocation.getInvokable().getAnnotation(org.jclouds.rest.annotations.Fallback.class);
        if (fallback != null) {
            return (Fallback)this.injector.getInstance(fallback.value());
        }
        return this.defaultFallback;
    }

    static Map<String, Long> timeouts(Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        Map stringBoundWithTimeoutPrefix = (Map)filterStringsBoundByName.apply(Predicates2.startsWith("jclouds.timeouts."));
        Map longsByName = Maps.transformValues((Map)stringBoundWithTimeoutPrefix, (Function)new Function<String, Long>(){

            public Long apply(String input) {
                return Long.valueOf(String.valueOf(input));
            }
        });
        return Maps2.transformKeys(longsByName, new Function<String, String>(){

            public String apply(String input) {
                return input.replaceFirst(Pattern.quote("jclouds.timeouts."), "");
            }
        });
    }
}

