/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseClusterImpl;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNode;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="CouchBase Cluster", description="Couchbase is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications.")
@ImplementedBy(value=CouchbaseClusterImpl.class)
public interface CouchbaseCluster
extends DynamicCluster {
    public static final AttributeSensor<Integer> ACTUAL_CLUSTER_SIZE = Sensors.newIntegerSensor((String)"coucbase.cluster.actualClusterSize", (String)"returns the actual number of nodes in the cluster");
    public static final AttributeSensor<Set<Entity>> COUCHBASE_CLUSTER_UP_NODES = Sensors.newSensor((TypeToken)new TypeToken<Set<Entity>>(){}, (String)"couchbase.cluster.clusterEntities", (String)"the set of service up nodes");
    public static final AttributeSensor<List<String>> COUCHBASE_CLUSTER_BUCKETS = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"couchbase.cluster.buckets", (String)"Names of all the buckets the couchbase cluster");
    public static final AttributeSensor<Entity> COUCHBASE_PRIMARY_NODE = Sensors.newSensor(Entity.class, (String)"couchbase.cluster.primaryNode", (String)"The primary couchbase node to query and issue add-server and rebalance on");
    public static final AttributeSensor<Boolean> IS_CLUSTER_INITIALIZED = Sensors.newBooleanSensor((String)"couchbase.cluster.isClusterInitialized", (String)"flag to emit if the couchbase cluster was intialized");
    @SetFromFlag(value="clusterName")
    public static final ConfigKey<String> CLUSTER_NAME = ConfigKeys.newStringConfigKey((String)"couchbase.cluster.name", (String)"Optional name for this cluster");
    @SetFromFlag(value="intialQuorumSize")
    public static final ConfigKey<Integer> INITIAL_QUORUM_SIZE = ConfigKeys.newIntegerConfigKey((String)"couchbase.cluster.intialQuorumSize", (String)"Initial cluster quorum size - number of initial nodes that must have been successfully started to report success (if < 0, then use value of INITIAL_SIZE)", (Integer)-1);
    @SetFromFlag(value="delayBeforeAdvertisingCluster")
    public static final ConfigKey<Duration> DELAY_BEFORE_ADVERTISING_CLUSTER = ConfigKeys.newConfigKey(Duration.class, (String)"couchbase.cluster.delayBeforeAdvertisingCluster", (String)"Delay after cluster is started before checking and advertising its availability", (Object)Duration.TEN_SECONDS);
    @SetFromFlag(value="postStartStabilizationDelay")
    public static final ConfigKey<Duration> NODES_STARTED_STABILIZATION_DELAY = ConfigKeys.newConfigKey(Duration.class, (String)"couchbase.cluster.postStartStabilizationDelay", (String)"Delay after nodes have been started before treating it as a cluster", (Object)Duration.TEN_SECONDS);
    @SetFromFlag(value="adminUsername")
    public static final ConfigKey<String> COUCHBASE_ADMIN_USERNAME = CouchbaseNode.COUCHBASE_ADMIN_USERNAME;
    @SetFromFlag(value="adminPassword")
    public static final ConfigKey<String> COUCHBASE_ADMIN_PASSWORD = CouchbaseNode.COUCHBASE_ADMIN_PASSWORD;
    public static final AttributeSensor<List<String>> COUCHBASE_CLUSTER_UP_NODE_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"couchbase.cluster.node.addresses", (String)"List of host:port of all active nodes in the cluster (http admin port, and public hostname/IP)");
    public static final AttributeSensor<String> COUCHBASE_CLUSTER_CONNECTION_URL = Sensors.newStringSensor((String)"couchbase.cluster.connection.url", (String)"Couchbase-style URL to connect to the cluster (e.g. http://127.0.0.1:8091/ or couchbase://10.0.0.1,10.0.0.2/)");
    public static final AttributeSensor<Double> OPS_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.ops", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/ops");
    public static final AttributeSensor<Double> EP_BG_FETCHED_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.ep.bg.fetched", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/ep_bg_fetched");
    public static final AttributeSensor<Double> CURR_ITEMS_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.curr.items", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/curr_items");
    public static final AttributeSensor<Double> VB_REPLICA_CURR_ITEMS_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.vb.replica.curr.items", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/vb_replica_curr_items");
    public static final AttributeSensor<Double> GET_HITS_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.get.hits", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/get_hits");
    public static final AttributeSensor<Double> CMD_GET_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.cmd.get", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/cmd_get");
    public static final AttributeSensor<Double> CURR_ITEMS_TOT_PER_NODE = Sensors.newDoubleSensor((String)"couchbase.stats.cluster.per.node.curr.items.tot", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/curr_items_tot");
    public static final AttributeSensor<Long> COUCH_DOCS_DATA_SIZE_PER_NODE = Sensors.newLongSensor((String)"couchbase.stats.cluster.per.node.couch.docs.data.size", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/couch_docs_data_size");
    public static final AttributeSensor<Long> MEM_USED_PER_NODE = Sensors.newLongSensor((String)"couchbase.stats.cluster.per.node.mem.used", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/mem_used");
    public static final AttributeSensor<Long> COUCH_VIEWS_ACTUAL_DISK_SIZE_PER_NODE = Sensors.newLongSensor((String)"couchbase.stats.cluster.per.node.couch.views.actual.disk.size", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/couch_views_actual_disk_size");
    public static final AttributeSensor<Long> COUCH_DOCS_ACTUAL_DISK_SIZE_PER_NODE = Sensors.newLongSensor((String)"couchbase.stats.cluster.per.node.couch.docs.actual.disk.size", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/couch_docs_actual_disk_size");
    public static final AttributeSensor<Long> COUCH_VIEWS_DATA_SIZE_PER_NODE = Sensors.newLongSensor((String)"couchbase.stats.cluster.per.node.couch.views.data.size", (String)"Average across cluster for pools/nodes/<current node>/interestingStats/couch_views_data_size");
    public static final AttributeSensor<Boolean> BUCKET_CREATION_IN_PROGRESS = Sensors.newBooleanSensor((String)"couchbase.cluster.bucketCreationInProgress", (String)"Indicates that a bucket is currently being created, andfurther bucket creation should be deferred");
    @SetFromFlag(value="createBuckets")
    public static final ConfigKey<List<Map<String, Object>>> CREATE_BUCKETS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<Map<String, Object>>>(){}, (String)"couchbase.cluster.createBuckets", (String)"a list of all dedicated port buckets to be created on the couchbase cluster");
    @SetFromFlag(value="replication")
    public static final ConfigKey<List<Map<String, Object>>> REPLICATION = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<Map<String, Object>>>(){}, (String)"couchbase.cluster.replicationConfiguration", (String)"List of replication rules to configure, each rule including target (id of another cluster) and mode (unidirectional or bidirectional)");

    public int getQuorumSize();
}

