/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.riak;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.nosql.riak.RiakNode;
import org.apache.brooklyn.entity.nosql.riak.RiakNodeDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.WebAppServiceMethods;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiakNodeImpl
extends SoftwareProcessImpl
implements RiakNode {
    private static final Logger LOG = LoggerFactory.getLogger(RiakNodeImpl.class);
    private transient HttpFeed httpFeed;

    public RiakNodeDriver getDriver() {
        return (RiakNodeDriver)super.getDriver();
    }

    public Class<RiakNodeDriver> getDriverInterface() {
        return RiakNodeDriver.class;
    }

    public void init() {
        super.init();
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey)RIAK_VM_ARGS_TEMPLATE_URL);
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey)RIAK_APP_CONFIG_TEMPLATE_URL);
        Integer defaultMaxOpenFiles = (Integer)RIAK_MAX_OPEN_FILES.getDefaultValue();
        Integer maxOpenFiles = (Integer)this.getConfig(RiakNode.RIAK_MAX_OPEN_FILES);
        Preconditions.checkArgument((maxOpenFiles >= defaultMaxOpenFiles ? 1 : 0) != 0, (String)"Specified number of open files : %s : is less than the required minimum", (Object)maxOpenFiles, (Object)defaultMaxOpenFiles);
    }

    public boolean isPackageDownloadUrlProvided() {
        AttributeSensorAndConfigKey[] downloadProperties;
        for (AttributeSensorAndConfigKey property : downloadProperties = new AttributeSensorAndConfigKey[]{DOWNLOAD_URL_RHEL_CENTOS, DOWNLOAD_URL_UBUNTU, DOWNLOAD_URL_DEBIAN}) {
            if (this.config().getRaw((ConfigKey.HasConfigKey)property).isAbsent()) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        ConfigBag result = ConfigBag.newInstance((Map)super.obtainProvisioningFlags(location));
        result.configure(CloudLocationConfig.OS_64_BIT, (Object)true);
        return result.getAllConfig();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        Integer erlangRangeStart = (Integer)this.config().get((ConfigKey.HasConfigKey)ERLANG_PORT_RANGE_START);
        Integer erlangRangeEnd = (Integer)this.config().get((ConfigKey.HasConfigKey)ERLANG_PORT_RANGE_END);
        this.sensors().set((AttributeSensor)ERLANG_PORT_RANGE_START, (Object)erlangRangeStart);
        this.sensors().set((AttributeSensor)ERLANG_PORT_RANGE_END, (Object)erlangRangeEnd);
        return super.getRequiredOpenPorts();
    }

    protected void preStart() {
        super.preStart();
        boolean configureInternalNetworking = Boolean.TRUE.equals(this.config().get(CONFIGURE_INTERNAL_NETWORKING));
        if (configureInternalNetworking) {
            this.configureInternalNetworking();
        }
    }

    private void configureInternalNetworking() {
        Location location = this.getDriver().getLocation();
        if (!(location instanceof JcloudsSshMachineLocation)) {
            LOG.info("Not running in a JcloudsSshMachineLocation, not adding IP permissions to {}", (Object)this);
            return;
        }
        JcloudsMachineLocation machine = (JcloudsMachineLocation)location;
        JcloudsLocationSecurityGroupCustomizer customizer = JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getApplicationId());
        String cidr = Cidr.UNIVERSAL.toString();
        MutableList permissions = MutableList.builder().add((Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.sensors().get((AttributeSensor)ERLANG_PORT_RANGE_START)).intValue()).toPort(((Integer)this.sensors().get((AttributeSensor)ERLANG_PORT_RANGE_END)).intValue()).cidrBlock(cidr).build()).add((Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.config().get((ConfigKey.HasConfigKey)HANDOFF_LISTENER_PORT)).intValue()).toPort(((Integer)this.config().get((ConfigKey.HasConfigKey)HANDOFF_LISTENER_PORT)).intValue()).cidrBlock(cidr).build()).add((Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.config().get((ConfigKey.HasConfigKey)EPMD_LISTENER_PORT)).intValue()).toPort(((Integer)this.config().get((ConfigKey.HasConfigKey)EPMD_LISTENER_PORT)).intValue()).cidrBlock(cidr).build()).build();
        LOG.debug("Applying custom security groups to {}: {}", (Object)machine, (Object)permissions);
        customizer.addPermissionsToLocation(machine, (Iterable)permissions);
    }

    public void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getRiakWebPort());
        if (this.isHttpMonitoringEnabled()) {
            HttpFeed.Builder httpFeedBuilder = HttpFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).baseUri(String.format("http://%s/stats", accessible.toString())).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_GETS).onSuccess(HttpValueFunctions.jsonContents((String)"node_gets", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_GETS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"node_gets_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_PUTS).onSuccess(HttpValueFunctions.jsonContents((String)"node_puts", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_PUTS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"node_puts_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_GETS).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_gets", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_GETS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_gets_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_PUTS).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_puts", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_PUTS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_puts_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(READ_REPAIRS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"read_repairs_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(COORD_REDIRS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"coord_redirs_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MEMORY_PROCESSES_USED).onSuccess(HttpValueFunctions.jsonContents((String)"memory_processes_used", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SYS_PROCESS_COUNT).onSuccess(HttpValueFunctions.jsonContents((String)"sys_process_count", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(PBC_CONNECTS).onSuccess(HttpValueFunctions.jsonContents((String)"pbc_connects", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(PBC_ACTIVE).onSuccess(HttpValueFunctions.jsonContents((String)"pbc_active", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(RING_MEMBERS).onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents((String)"ring_members", String[].class), (Function)new Function<String[], List<String>>(){

                @Nullable
                public List<String> apply(@Nullable String[] strings) {
                    return Arrays.asList(strings);
                }
            }))).onFailureOrException(Functions.constant(Arrays.asList(new String[0]))));
            for (AttributeSensor sensor : ONE_MINUTE_SENSORS) {
                httpFeedBuilder.poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(sensor).period(Duration.ONE_MINUTE)).onSuccess(HttpValueFunctions.jsonContents((String)sensor.getName().substring(5), Integer.class))).onFailureOrException(Functions.constant((Object)-1)));
            }
            this.httpFeed = httpFeedBuilder.build();
        }
        this.enrichers().add(((Enrichers.CombinerBuilder)Enrichers.builder().combining(new AttributeSensor[]{NODE_GETS, NODE_PUTS}).computingSum()).publishing(NODE_OPS).build());
        this.enrichers().add(((Enrichers.CombinerBuilder)Enrichers.builder().combining(new AttributeSensor[]{NODE_GETS_TOTAL, NODE_PUTS_TOTAL}).computingSum()).publishing(NODE_OPS_TOTAL).build());
        WebAppServiceMethods.connectWebAppServerPolicies((Entity)this);
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
    }

    @Override
    public void joinCluster(String nodeName) {
        this.getDriver().joinCluster(nodeName);
    }

    @Override
    public void leaveCluster() {
        this.getDriver().leaveCluster();
    }

    @Override
    public void removeNode(String nodeName) {
        this.getDriver().removeNode(nodeName);
    }

    @Override
    public void bucketTypeCreate(String bucketTypeName, String bucketTypeProperties) {
        this.getDriver().bucketTypeCreate(bucketTypeName, bucketTypeProperties);
    }

    @Override
    public List<String> bucketTypeList() {
        return this.getDriver().bucketTypeList();
    }

    @Override
    public List<String> bucketTypeStatus(String bucketTypeName) {
        return this.getDriver().bucketTypeStatus(bucketTypeName);
    }

    @Override
    public void bucketTypeUpdate(String bucketTypeName, String bucketTypeProperties) {
        this.getDriver().bucketTypeUpdate(bucketTypeName, bucketTypeProperties);
    }

    @Override
    public void bucketTypeActivate(String bucketTypeName) {
        this.getDriver().bucketTypeActivate(bucketTypeName);
    }

    @Override
    public void recoverFailedNode(String nodeName) {
        this.getDriver().recoverFailedNode(nodeName);
    }

    protected boolean isHttpMonitoringEnabled() {
        return Boolean.TRUE.equals(this.getConfig(USE_HTTP_MONITORING));
    }

    @Override
    public Integer getRiakWebPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.RIAK_WEB_PORT);
    }

    @Override
    public Integer getRiakPbPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.RIAK_PB_PORT);
    }

    @Override
    public Integer getHandoffListenerPort() {
        return (Integer)this.getConfig((ConfigKey.HasConfigKey)RiakNode.HANDOFF_LISTENER_PORT);
    }

    @Override
    public Integer getEpmdListenerPort() {
        return (Integer)this.getConfig((ConfigKey.HasConfigKey)RiakNode.EPMD_LISTENER_PORT);
    }

    @Override
    public Integer getErlangPortRangeStart() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.ERLANG_PORT_RANGE_START);
    }

    @Override
    public Integer getErlangPortRangeEnd() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.ERLANG_PORT_RANGE_END);
    }

    @Override
    public Boolean isSearchEnabled() {
        return (Boolean)this.getConfig(RiakNode.SEARCH_ENABLED);
    }

    @Override
    public Integer getSearchSolrPort() {
        return (Integer)this.getConfig(RiakNode.SEARCH_SOLR_PORT);
    }

    @Override
    public Integer getSearchSolrJmxPort() {
        return (Integer)this.getConfig(RiakNode.SEARCH_SOLR_JMX_PORT);
    }

    @Override
    public String getMajorVersion() {
        return this.getFullVersion().substring(0, 3);
    }

    @Override
    public String getFullVersion() {
        return (String)this.getConfig(RiakNode.SUGGESTED_VERSION);
    }

    @Override
    public String getOsMajorVersion() {
        return this.getDriver().getOsMajorVersion();
    }
}

