/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.followthesun;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.core.entity.trait.Resizable;
import org.apache.brooklyn.core.sensor.BasicNotificationSensor;
import org.apache.brooklyn.policy.followthesun.FollowTheSunPoolImpl;

@ImplementedBy(value=FollowTheSunPoolImpl.class)
public interface FollowTheSunPool
extends Entity,
Resizable {
    public static final BasicNotificationSensor<Entity> CONTAINER_ADDED = new BasicNotificationSensor(Entity.class, "followthesun.container.added", "Container added");
    public static final BasicNotificationSensor<Entity> CONTAINER_REMOVED = new BasicNotificationSensor(Entity.class, "followthesun.container.removed", "Container removed");
    public static final BasicNotificationSensor<Entity> ITEM_ADDED = new BasicNotificationSensor(Entity.class, "followthesun.item.added", "Item added");
    public static final BasicNotificationSensor<Entity> ITEM_REMOVED = new BasicNotificationSensor(Entity.class, "followthesun.item.removed", "Item removed");
    public static final BasicNotificationSensor<ContainerItemPair> ITEM_MOVED = new BasicNotificationSensor(ContainerItemPair.class, "followthesun.item.moved", "Item moved to the given container");

    public void setContents(Group var1, Group var2);

    public Group getContainerGroup();

    public Group getItemGroup();

    public static class ContainerItemPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Entity container;
        public final Entity item;

        public ContainerItemPair(Entity container, Entity item) {
            this.container = container;
            this.item = (Entity)Preconditions.checkNotNull((Object)item);
        }

        public String toString() {
            return "" + this.item + " @ " + this.container;
        }
    }
}

