/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.xpath.XPathConstants;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindManager;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoManifest;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.ManagedBundleMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.classloading.ClassLoaderFromBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.MementoSerializer;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.persist.RetryingMementoSerializer;
import org.apache.brooklyn.core.mgmt.persist.StoreObjectAccessorLocking;
import org.apache.brooklyn.core.mgmt.persist.XmlMementoSerializer;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.mgmt.rebind.dto.BrooklynMementoImpl;
import org.apache.brooklyn.core.mgmt.rebind.dto.BrooklynMementoManifestImpl;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.xstream.XmlUtil;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class BrooklynMementoPersisterToObjectStore
implements BrooklynMementoPersister {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynMementoPersisterToObjectStore.class);
    public static final String PLANE_ID_FILE_NAME = "planeId";
    public static final ConfigKey<Integer> PERSISTER_MAX_THREAD_POOL_SIZE = ConfigKeys.newIntegerConfigKey("persister.threadpool.maxSize", "Maximum number of concurrent operations for persistence (reads/writes/deletes of *different* objects)", 10);
    public static final ConfigKey<Integer> PERSISTER_MAX_SERIALIZATION_ATTEMPTS = ConfigKeys.newIntegerConfigKey("persister.maxSerializationAttempts", "Maximum number of attempts to serialize a memento (e.g. if first attempts fail because of concurrent modifications of an entity)", 5);
    private final PersistenceObjectStore objectStore;
    private final MementoSerializer<Object> serializerWithStandardClassLoader;
    private final Map<String, PersistenceObjectStore.StoreObjectAccessorWithLock> writers = new LinkedHashMap<String, PersistenceObjectStore.StoreObjectAccessorWithLock>();
    private ListeningExecutorService executor;
    private volatile boolean writesAllowed = false;
    private volatile boolean writesShuttingDown = false;
    private StringConfigMap brooklynProperties;
    private ManagementContext mgmt = null;
    private List<BrooklynMementoPersister.Delta> queuedDeltas = new CopyOnWriteArrayList<BrooklynMementoPersister.Delta>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private Set<String> lastErrors = MutableSet.of();

    public BrooklynMementoPersisterToObjectStore(PersistenceObjectStore objectStore, ManagementContext mgmt) {
        this(objectStore, mgmt, mgmt.getCatalogClassLoader());
    }

    public BrooklynMementoPersisterToObjectStore(PersistenceObjectStore objectStore, ManagementContext mgmt, ClassLoader classLoader) {
        this(objectStore, ((ManagementContextInternal)mgmt).getBrooklynProperties(), classLoader);
        this.mgmt = mgmt;
    }

    @Deprecated
    public BrooklynMementoPersisterToObjectStore(PersistenceObjectStore objectStore, StringConfigMap brooklynProperties, ClassLoader classLoader) {
        this.objectStore = (PersistenceObjectStore)Preconditions.checkNotNull((Object)objectStore, (Object)"objectStore");
        this.brooklynProperties = brooklynProperties;
        int maxSerializationAttempts = (Integer)brooklynProperties.getConfig(PERSISTER_MAX_SERIALIZATION_ATTEMPTS);
        XmlMementoSerializer rawSerializer = XmlMementoSerializer.XmlMementoSerializerBuilder.from(brooklynProperties).withBrooklynDeserializingClassRenames().withClassLoader(classLoader).build();
        this.serializerWithStandardClassLoader = new RetryingMementoSerializer<Object>(rawSerializer, maxSerializationAttempts);
        objectStore.createSubPath("entities");
        objectStore.createSubPath("locations");
        objectStore.createSubPath("policies");
        objectStore.createSubPath("enrichers");
        objectStore.createSubPath("feeds");
        objectStore.createSubPath("catalog");
        objectStore.createSubPath("plane");
        this.resetExecutor();
    }

    private Integer maxThreadPoolSize() {
        return (Integer)this.brooklynProperties.getConfig(PERSISTER_MAX_THREAD_POOL_SIZE);
    }

    public MementoSerializer<Object> getMementoSerializer() {
        return this.getSerializerWithStandardClassLoader();
    }

    protected MementoSerializer<Object> getSerializerWithStandardClassLoader() {
        return this.serializerWithStandardClassLoader;
    }

    protected MementoSerializer<Object> getSerializerWithCustomClassLoader(BrooklynMementoPersister.LookupContext lookupContext, BrooklynObjectType type, String objectId) {
        ClassLoader cl = this.getCustomClassLoaderForBrooklynObject(lookupContext, type, objectId);
        if (cl == null) {
            return this.serializerWithStandardClassLoader;
        }
        return this.getSerializerWithCustomClassLoader(lookupContext, cl);
    }

    protected MementoSerializer<Object> getSerializerWithCustomClassLoader(BrooklynMementoPersister.LookupContext lookupContext, ClassLoader classLoader) {
        int maxSerializationAttempts = (Integer)this.brooklynProperties.getConfig(PERSISTER_MAX_SERIALIZATION_ATTEMPTS);
        XmlMementoSerializer rawSerializer = XmlMementoSerializer.XmlMementoSerializerBuilder.from(this.brooklynProperties).withBrooklynDeserializingClassRenames().withClassLoader(classLoader).build();
        RetryingMementoSerializer<Object> result = new RetryingMementoSerializer<Object>(rawSerializer, maxSerializationAttempts);
        result.setLookupContext(lookupContext);
        return result;
    }

    @Nullable
    protected ClassLoader getCustomClassLoaderForBrooklynObject(BrooklynMementoPersister.LookupContext lookupContext, BrooklynObjectType type, String objectId) {
        String catalogItemId;
        BrooklynObject item = lookupContext.peek(type, objectId);
        String string = catalogItemId = item == null ? null : item.getCatalogItemId();
        if (catalogItemId == null) {
            return null;
        }
        ManagementContext managementContext = lookupContext.lookupManagementContext();
        RegisteredType catalogItem = managementContext.getTypeRegistry().get(catalogItemId);
        if (catalogItem == null) {
            if (Thread.interrupted()) {
                LOG.debug("Aborting (probably old) rebind iteration");
                throw new RuntimeInterruptedException("Rebind iteration cancelled");
            }
            LOG.debug("Unable to load registered type " + catalogItemId + " for custom class loader of " + type + " " + objectId + "; will use default class loader");
            return null;
        }
        BrooklynClassLoadingContextSequential ctx = new BrooklynClassLoadingContextSequential(managementContext, new BrooklynClassLoadingContext[0]);
        ctx.add(CatalogUtils.newClassLoadingContextForCatalogItems(managementContext, item.getCatalogItemId(), item.getCatalogItemIdSearchPath()));
        return ClassLoaderFromBrooklynClassLoadingContext.of(ctx);
    }

    public void enableWriteAccess() {
        this.writesAllowed = true;
    }

    public void disableWriteAccess(boolean graceful) {
        this.writesShuttingDown = true;
        try {
            this.writesAllowed = false;
            this.waitForWritesCompleted(Duration.ONE_HOUR);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.writesShuttingDown = false;
        }
    }

    public void stop(boolean graceful) {
        this.disableWriteAccess(graceful);
        this.stopExecutor(graceful);
    }

    public void reset() {
        this.resetExecutor();
    }

    public void resetExecutor() {
        this.stopExecutor(false);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.maxThreadPoolSize(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "brooklyn-persister");
            }
        }));
    }

    public void stopExecutor(boolean graceful) {
        if (this.executor != null) {
            if (graceful) {
                this.executor.shutdown();
                try {
                    this.executor.awaitTermination(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            } else {
                this.executor.shutdownNow();
            }
        }
    }

    public PersistenceObjectStore getObjectStore() {
        return this.objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistenceObjectStore.StoreObjectAccessorWithLock getWriter(String path) {
        String id = path.substring(path.lastIndexOf(47) + 1);
        Map<String, PersistenceObjectStore.StoreObjectAccessorWithLock> map = this.writers;
        synchronized (map) {
            PersistenceObjectStore.StoreObjectAccessorWithLock writer = this.writers.get(id);
            if (writer == null) {
                writer = new StoreObjectAccessorLocking(this.objectStore.newAccessor(path));
                this.writers.put(id, writer);
            }
            return writer;
        }
    }

    private Map<String, String> makeIdSubPathMap(Iterable<String> subPathLists) {
        MutableMap result = MutableMap.of();
        Iterator<String> iterator = subPathLists.iterator();
        while (iterator.hasNext()) {
            String subpath;
            String id = subpath = iterator.next();
            id = id.substring(id.lastIndexOf(47) + 1);
            id = id.substring(id.lastIndexOf(92) + 1);
            result.put(id, subpath);
        }
        return result;
    }

    protected BrooklynMementoRawData listMementoSubPathsAsData(RebindExceptionHandler exceptionHandler) {
        BrooklynMementoRawData.Builder subPathDataBuilder = BrooklynMementoRawData.builder();
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                subPathDataBuilder.putAll(type, this.makeIdSubPathMap(this.objectStore.listContentsWithSubPath(type.getSubPathName())));
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            exceptionHandler.onLoadMementoFailed(BrooklynObjectType.UNKNOWN, "Failed to list files", e);
            throw new IllegalStateException("Failed to list memento files in " + this.objectStore, e);
        }
        BrooklynMementoRawData subPathData = subPathDataBuilder.build();
        LOG.debug("Loaded rebind lists; took {}: {} entities, {} locations, {} policies, {} enrichers, {} feeds, {} catalog items, {} bundles; from {}", new Object[]{Time.makeTimeStringRounded((Stopwatch)stopwatch), subPathData.getEntities().size(), subPathData.getLocations().size(), subPathData.getPolicies().size(), subPathData.getEnrichers().size(), subPathData.getFeeds().size(), subPathData.getCatalogItems().size(), subPathData.getBundles().size(), this.objectStore.getSummaryName()});
        return subPathData;
    }

    public BrooklynMementoRawData loadMementoRawData(final RebindExceptionHandler exceptionHandler) {
        BrooklynMementoRawData subPathData = this.listMementoSubPathsAsData(exceptionHandler);
        final BrooklynMementoRawData.Builder builder = BrooklynMementoRawData.builder();
        Visitor loaderVisitor = new Visitor(){

            @Override
            public void visit(BrooklynObjectType type, String id, String contentsSubpath) throws Exception {
                if (type == BrooklynObjectType.MANAGED_BUNDLE && id.endsWith(".jar")) {
                    return;
                }
                String contents = null;
                try {
                    contents = BrooklynMementoPersisterToObjectStore.this.read(contentsSubpath);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    exceptionHandler.onLoadMementoFailed(type, "memento " + id + " read error", e);
                }
                if (contents == null) {
                    LOG.warn("No contents for " + contentsSubpath + " in persistence store; ignoring");
                } else {
                    boolean include;
                    String xmlId = (String)XmlUtil.xpathHandlingIllegalChars(contents, "/" + type.toCamelCase() + "/id");
                    String xmlUrl = (String)BrooklynMementoPersisterToObjectStore.this.getXmlValue(contents, "/" + type.toCamelCase() + "/url").orNull();
                    String xmlJavaType = (String)BrooklynMementoPersisterToObjectStore.this.getXmlValue(contents, "/" + type.toCamelCase() + "/type").orNull();
                    String summary = MutableList.of((Object)contentsSubpath, (Object)type.toCamelCase()).appendIfNotNull((Object)xmlId).appendIfNotNull((Object)xmlUrl).appendIfNotNull((Object)xmlJavaType).stream().collect(Collectors.joining(" / "));
                    String safeXmlId = Strings.makeValidFilename((String)xmlId);
                    if (!Objects.equal((Object)id, (Object)safeXmlId)) {
                        LOG.warn("ID mismatch on " + summary + ": xml id is " + safeXmlId);
                    }
                    if (type == BrooklynObjectType.MANAGED_BUNDLE) {
                        byte[] jarData = BrooklynMementoPersisterToObjectStore.this.readBytes(contentsSubpath + ".jar");
                        boolean bl = include = jarData != null;
                        if (!include) {
                            LOG.warn("No JAR data for " + summary + "; assuming deprecated and not meant to be installed, so ignoring");
                        } else {
                            LOG.debug("Including bundle " + summary + ", with jar data size " + jarData.length);
                            builder.bundleJar(id, ByteSource.wrap((byte[])jarData));
                        }
                    } else {
                        LOG.debug("Including item " + summary);
                        include = true;
                    }
                    if (include) {
                        builder.put(type, xmlId, contents);
                    }
                }
            }
        };
        Stopwatch stopwatch = Stopwatch.createStarted();
        builder.planeId(Strings.emptyToNull((String)this.read(PLANE_ID_FILE_NAME)));
        this.visitMemento("loading raw", subPathData, loaderVisitor, exceptionHandler);
        BrooklynMementoRawData result = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded rebind raw data; took {}; {} entities, {} locations, {} policies, {} enrichers, {} feeds, {} catalog items, {} bundles, from {}", new Object[]{Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)), result.getEntities().size(), result.getLocations().size(), result.getPolicies().size(), result.getEnrichers().size(), result.getFeeds().size(), result.getCatalogItems().size(), result.getBundles().size(), this.objectStore.getSummaryName()});
        }
        return result;
    }

    private Maybe<String> getXmlValue(String xml, String path) {
        try {
            return Maybe.ofDisallowingNull((Object)((String)XmlUtil.xpathHandlingIllegalChars(xml, path)));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return Maybe.absent();
        }
    }

    public BrooklynMementoManifest loadMementoManifest(BrooklynMementoRawData mementoDataR, final RebindExceptionHandler exceptionHandler) throws IOException {
        final BrooklynMementoRawData mementoData = mementoDataR == null ? this.loadMementoRawData(exceptionHandler) : mementoDataR;
        final BrooklynMementoManifestImpl.Builder builder = BrooklynMementoManifestImpl.builder();
        builder.planeId(mementoData.getPlaneId());
        Visitor visitor = new Visitor(){

            @Override
            public void visit(BrooklynObjectType type, String objectId, String contents) throws Exception {
                XPathHelper x = new XPathHelper(contents, "/" + type.toCamelCase() + "/");
                switch (type) {
                    case ENTITY: {
                        builder.entity(x.get("id"), x.get("type"), Strings.emptyToNull((String)x.get("parent")), Strings.emptyToNull((String)x.get("catalogItemId")), x.getStringList("searchPath"));
                        break;
                    }
                    case LOCATION: 
                    case POLICY: 
                    case ENRICHER: 
                    case FEED: {
                        builder.putType(type, x.get("id"), x.get("type"));
                        break;
                    }
                    case CATALOG_ITEM: {
                        try {
                            CatalogItemMemento memento = (CatalogItemMemento)BrooklynMementoPersisterToObjectStore.this.getSerializerWithStandardClassLoader().fromString(contents);
                            if (memento == null) {
                                LOG.warn("No " + type.toCamelCase() + "-memento deserialized from " + objectId + "; ignoring and continuing");
                                break;
                            }
                            builder.catalogItem(memento);
                        }
                        catch (Exception e) {
                            exceptionHandler.onLoadMementoFailed(type, "catalog memento " + objectId + " early catalog deserialization error", e);
                        }
                        break;
                    }
                    case MANAGED_BUNDLE: {
                        try {
                            ManagedBundleMemento memento = (ManagedBundleMemento)BrooklynMementoPersisterToObjectStore.this.getSerializerWithStandardClassLoader().fromString(contents);
                            builder.bundle(memento);
                            memento.setJarContent((ByteSource)mementoData.getBundleJars().get(objectId));
                        }
                        catch (Exception e) {
                            exceptionHandler.onLoadMementoFailed(type, "bundle memento " + objectId + " early catalog deserialization error", e);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected brooklyn type: " + type);
                    }
                }
            }
        };
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.visitMemento("manifests", mementoData, visitor, exceptionHandler);
        BrooklynMementoManifest result = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded rebind manifests; took {}: {} entities, {} locations, {} policies, {} enrichers, {} feeds, {} catalog items, {} bundles; from {}", new Object[]{Time.makeTimeStringRounded((Stopwatch)stopwatch), result.getEntityIdToManifest().size(), result.getLocationIdToType().size(), result.getPolicyIdToType().size(), result.getEnricherIdToType().size(), result.getFeedIdToType().size(), result.getCatalogItemMementos().size(), result.getBundles().size(), this.objectStore.getSummaryName()});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrooklynMemento loadMemento(BrooklynMementoRawData mementoData, final BrooklynMementoPersister.LookupContext lookupContext, final RebindExceptionHandler exceptionHandler) throws IOException {
        LOG.debug("Loading mementos");
        if (mementoData == null) {
            mementoData = this.loadMementoRawData(exceptionHandler);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        final BrooklynMementoImpl.Builder builder = BrooklynMementoImpl.builder();
        builder.planeId(mementoData.getPlaneId());
        Visitor visitor = new Visitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(BrooklynObjectType type, String objectId, String contents) throws Exception {
                try {
                    Memento memento;
                    try {
                        lookupContext.pushContextDescription("" + type.toString().toLowerCase() + " " + objectId);
                        memento = (Memento)BrooklynMementoPersisterToObjectStore.this.getSerializerWithCustomClassLoader(lookupContext, type, objectId).fromString(contents);
                    }
                    finally {
                        lookupContext.popContextDescription();
                    }
                    if (memento == null) {
                        LOG.warn("No " + type.toCamelCase() + "-memento deserialized from " + objectId + "; ignoring and continuing");
                    } else {
                        builder.memento(memento);
                    }
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(type, "memento " + objectId + " (" + type + ") deserialization error", e);
                }
            }
        };
        this.getSerializerWithStandardClassLoader().setLookupContext(lookupContext);
        try {
            this.visitMemento("deserialization", mementoData, visitor, exceptionHandler);
        }
        finally {
            this.getSerializerWithStandardClassLoader().unsetLookupContext();
        }
        BrooklynMemento result = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded rebind mementos; took {}: {} entities, {} locations, {} policies, {} enrichers, {} feeds, {} catalog items, {} bundles, from {}", new Object[]{Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)), result.getEntityIds().size(), result.getLocationIds().size(), result.getPolicyIds().size(), result.getEnricherIds().size(), result.getManagedBundleIds().size(), result.getFeedIds().size(), result.getCatalogItemIds().size(), this.objectStore.getSummaryName()});
        }
        return result;
    }

    protected void visitMemento(final String phase, BrooklynMementoRawData rawData, final Visitor visitor, final RebindExceptionHandler exceptionHandler) {
        ArrayList futures = Lists.newArrayList();
        for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
            for (Map.Entry entry : rawData.getObjectsOfType(type).entrySet()) {
                class VisitorWrapper
                implements Runnable {
                    private final BrooklynObjectType type;
                    private final Map.Entry<String, String> objectIdAndData;

                    public VisitorWrapper(BrooklynObjectType type, Map.Entry<String, String> objectIdAndData) {
                        this.type = type;
                        this.objectIdAndData = objectIdAndData;
                    }

                    @Override
                    public void run() {
                        try {
                            try {
                                visitor.visit(this.type, this.objectIdAndData.getKey(), this.objectIdAndData.getValue());
                            }
                            catch (Exception e) {
                                Exceptions.propagateIfFatal((Throwable)e);
                                if (Thread.currentThread().isInterrupted()) {
                                    throw new RuntimeInterruptedException("Interruption discovered", (Throwable)e);
                                }
                                exceptionHandler.onLoadMementoFailed(this.type, "memento " + this.objectIdAndData.getKey() + " " + phase + " error", e);
                            }
                        }
                        catch (RuntimeInterruptedException e) {
                            LOG.debug("Ending persistence on interruption, probably cancelled when server about to transition: " + (Object)((Object)e));
                        }
                    }
                }
                futures.add(this.executor.submit((Runnable)new VisitorWrapper(type, entry)));
            }
        }
        try {
            Futures.allAsList((Iterable)futures).get();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            ArrayList exceptions = Lists.newArrayList();
            for (ListenableFuture future : futures) {
                if (!future.isDone()) continue;
                try {
                    future.get();
                }
                catch (InterruptedException | RuntimeInterruptedException e2) {
                    throw Exceptions.propagate((Throwable)e2);
                }
                catch (ExecutionException e2) {
                    LOG.warn("Problem loading memento (" + phase + "): " + e2, (Throwable)e2);
                    exceptions.add(e2);
                }
                future.cancel(true);
            }
            if (exceptions.isEmpty()) {
                throw Exceptions.propagate((Throwable)e);
            }
            throw new CompoundRuntimeException("Problem loading mementos (" + phase + ")", (Iterable)exceptions);
        }
    }

    protected void checkWritesAllowed() {
        if (!this.writesAllowed && !this.writesShuttingDown) {
            throw new IllegalStateException("Writes not allowed in " + this);
        }
    }

    public Set<String> getLastErrors() {
        return this.lastErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public boolean checkpoint(BrooklynMementoRawData newMemento, PersistenceExceptionHandler exceptionHandler, String context, @Nullable RebindManager contextDetails) {
        this.checkWritesAllowed();
        try {
            this.lock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            if (LOG.isDebugEnabled()) {
                if (contextDetails != null && !contextDetails.hasPending()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Checkpointing memento for {}", (Object)context);
                    }
                } else {
                    LOG.debug("Checkpointing memento for {}", (Object)context);
                }
            }
            exceptionHandler.clearRecentErrors();
            this.objectStore.prepareForMasterUse();
            Stopwatch stopwatch = Stopwatch.createStarted();
            ArrayList futures = Lists.newArrayList();
            futures.add(this.asyncUpdatePlaneId(newMemento.getPlaneId(), exceptionHandler));
            for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                for (Map.Entry entry : newMemento.getObjectsOfType(type).entrySet()) {
                    this.addPersistContentIfManagedBundle(type, (String)entry.getKey(), (String)entry.getValue(), futures, exceptionHandler, contextDetails);
                    futures.add(this.asyncPersist(type.getSubPathName(), type, (String)entry.getKey(), (String)entry.getValue(), exceptionHandler));
                }
            }
            try {
                Futures.successfulAsList((Iterable)futures).get();
                Futures.allAsList((Iterable)futures).get();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checkpointed memento in {} (for {})", (Object)Time.makeTimeStringRounded((Stopwatch)stopwatch), (Object)context);
            }
        }
        finally {
            this.lastErrors = exceptionHandler.getRecentErrors();
            this.lock.writeLock().unlock();
        }
        return this.lastErrors.isEmpty();
    }

    public boolean delta(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHandler) {
        this.checkWritesAllowed();
        MutableSet theseErrors = MutableSet.of();
        while (!this.queuedDeltas.isEmpty()) {
            BrooklynMementoPersister.Delta extraDelta = this.queuedDeltas.remove(0);
            theseErrors.addAll(this.doDelta(extraDelta, exceptionHandler, true));
        }
        theseErrors.addAll(this.doDelta(delta, exceptionHandler, false));
        this.lastErrors = theseErrors;
        return theseErrors.isEmpty();
    }

    protected Set<String> doDelta(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHandler, boolean previouslyQueued) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<String> theseLastErrors = this.deltaImpl(delta, exceptionHandler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checkpointed " + (previouslyQueued ? "previously queued " : "") + "delta of memento in {}: updated {} entities, {} locations, {} policies, {} enrichers, {} catalog items, {} bundles; removed {} entities, {} locations, {} policies, {} enrichers, {} catalog items, {} bundles" + (theseLastErrors.isEmpty() ? "" : "; " + theseLastErrors.size() + " errors: " + theseLastErrors), new Object[]{Time.makeTimeStringRounded((Stopwatch)stopwatch), delta.entities().size(), delta.locations().size(), delta.policies().size(), delta.enrichers().size(), delta.catalogItems().size(), delta.bundles().size(), delta.removedEntityIds().size(), delta.removedLocationIds().size(), delta.removedPolicyIds().size(), delta.removedEnricherIds().size(), delta.removedCatalogItemIds().size(), delta.removedBundleIds().size()});
        }
        return theseLastErrors;
    }

    public void queueDelta(BrooklynMementoPersister.Delta delta) {
        this.queuedDeltas.add(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> deltaImpl(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHandler) {
        try {
            this.lock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            exceptionHandler.clearRecentErrors();
            this.objectStore.prepareForMasterUse();
            ArrayList futures = Lists.newArrayList();
            MutableSet deletedIds = MutableSet.of();
            for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                deletedIds.addAll(delta.getRemovedIdsOfType(type));
            }
            if (delta.planeId() != null) {
                futures.add(this.asyncUpdatePlaneId(delta.planeId(), exceptionHandler));
            }
            for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                for (Memento item : delta.getObjectsOfType(type)) {
                    if (deletedIds.contains(item.getId())) continue;
                    this.addPersistContentIfManagedBundle(type, item.getId(), "" + item.getCatalogItemId() + "/" + item.getDisplayName(), futures, exceptionHandler, null);
                    futures.add(this.asyncPersist(type.getSubPathName(), item, exceptionHandler));
                }
            }
            for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                for (String id : delta.getRemovedIdsOfType(type)) {
                    futures.add(this.asyncDelete(type.getSubPathName(), id, exceptionHandler));
                    if (type != BrooklynObjectType.MANAGED_BUNDLE) continue;
                    futures.add(this.asyncDelete(type.getSubPathName(), id + ".jar", exceptionHandler));
                }
            }
            try {
                Futures.successfulAsList((Iterable)futures).get();
                Futures.allAsList((Iterable)futures).get();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        finally {
            this.lastErrors = exceptionHandler.getRecentErrors();
            this.lock.writeLock().unlock();
        }
        return this.lastErrors;
    }

    private void addPersistContentIfManagedBundle(final BrooklynObjectType type, final String id, String summaryOrContents, List<ListenableFuture<?>> futures, final PersistenceExceptionHandler exceptionHandler, @Nullable RebindManager deltaContext) {
        if (type == BrooklynObjectType.MANAGED_BUNDLE) {
            if (this.mgmt == null) {
                throw new IllegalStateException("Cannot persist bundles without a management context");
            }
            final ManagedBundle mb = ((OsgiManager)((ManagementContextInternal)this.mgmt).getOsgiManager().get()).getManagedBundles().get(id);
            LOG.debug("Persisting managed bundle " + id + ": " + mb + " - " + summaryOrContents);
            if (mb == null) {
                if (deltaContext != null && deltaContext instanceof RebindManagerImpl && ((RebindManagerImpl)deltaContext).isBundleIdUnmanaged(id)) {
                    LOG.trace("Skipipng absent managed bundle for added and removed bundle {}; ignoring (probably uninstalled or reinstalled with another OSGi ID; see debug log for contents)", (Object)id);
                } else {
                    LOG.warn("Cannot find managed bundle for added bundle {}; ignoring (probably uninstalled or reinstalled with another OSGi ID; see debug log for contents)", (Object)id);
                }
                return;
            }
            if (mb instanceof BasicManagedBundle && ((BasicManagedBundle)mb).getPersistenceNeeded()) {
                futures.add(this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (!((BasicManagedBundle)mb).getPersistenceNeeded()) {
                            return;
                        }
                        BrooklynMementoPersisterToObjectStore.this.persist(type.getSubPathName(), type, id + ".jar", Files.asByteSource((File)((OsgiManager)((ManagementContextInternal)BrooklynMementoPersisterToObjectStore.this.mgmt).getOsgiManager().get()).getBundleFile(mb)), exceptionHandler);
                        ((BasicManagedBundle)mb).setPersistenceNeeded(false);
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForWritesCompleted(Duration timeout) throws InterruptedException, TimeoutException {
        boolean locked = this.lock.readLock().tryLock(timeout.toMillisecondsRoundingUp(), TimeUnit.MILLISECONDS);
        if (locked) {
            ImmutableSet wc;
            UnmodifiableIterator unmodifiableIterator = this.writers;
            synchronized (unmodifiableIterator) {
                wc = ImmutableSet.copyOf(this.writers.values());
            }
            this.lock.readLock().unlock();
            for (PersistenceObjectStore.StoreObjectAccessorWithLock writer : wc) {
                writer.waitForCurrentWrites(timeout);
            }
        } else {
            throw new TimeoutException("Timeout waiting for writes to " + this.objectStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriting() {
        boolean locked;
        try {
            locked = this.lock.readLock().tryLock(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (locked) {
            ImmutableSet wc;
            UnmodifiableIterator unmodifiableIterator = this.writers;
            synchronized (unmodifiableIterator) {
                wc = ImmutableSet.copyOf(this.writers.values());
            }
            this.lock.readLock().unlock();
            for (PersistenceObjectStore.StoreObjectAccessorWithLock writer : wc) {
                if (!writer.isWriting()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String read(String subPath) {
        PersistenceObjectStore.StoreObjectAccessor objectAccessor = this.objectStore.newAccessor(subPath);
        return objectAccessor.get();
    }

    private byte[] readBytes(String subPath) {
        PersistenceObjectStore.StoreObjectAccessor objectAccessor = this.objectStore.newAccessor(subPath);
        return objectAccessor.getBytes();
    }

    private void persist(String subPath, Memento memento, PersistenceExceptionHandler exceptionHandler) {
        try {
            this.checkMementoForProblemsAndWarn(memento);
            this.getWriter(this.getPath(subPath, memento.getId())).put(this.getSerializerWithStandardClassLoader().toString(memento));
        }
        catch (Exception e) {
            exceptionHandler.onPersistMementoFailed(memento, e);
        }
    }

    private boolean isKnownNotManagedActive(BrooklynObject bo) {
        return bo != null && (bo instanceof Entity && !Entities.isManagedActive((Entity)bo) || bo instanceof Location && !Locations.isManaged((Location)bo));
    }

    private void checkMementoForProblemsAndWarn(Memento memento) {
        MutableList dependenciesToConfirmExistence = MutableList.of();
        if (memento instanceof EntityMemento || memento instanceof LocationMemento) {
            dependenciesToConfirmExistence.appendIfNotNull((Object)((TreeNode)memento).getParent());
        }
        Maybe me = null;
        for (String id : dependenciesToConfirmExistence) {
            BrooklynObject bo = this.mgmt.lookup(id);
            if (bo == null) {
                if (me == null) {
                    me = Maybe.ofAllowingNull((Object)this.mgmt.lookup(memento.getId()));
                }
                if (me.isPresentAndNonNull() && this.isKnownNotManagedActive((BrooklynObject)me.get())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Persistence dependency incomplete with " + memento.getType() + " " + memento.getId() + "; " + me.get() + " is being unmanaged, and dependency " + id + "(" + bo + ") is not known; likely the former will be unpersisted shortly also but persisting it for now as requested");
                    }
                } else if (me.get() == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Persistence dependency incomplete with " + memento.getType() + " " + memento.getId() + "; " + me.get() + " is not known to mgmt context, and dependency " + id + "(" + bo + ") is not known; likely the former will be unpersisted shortly also but persisting it for now as requested");
                    }
                } else {
                    LOG.warn("Persistence dependency problem with " + memento.getType() + " " + memento.getId() + "; dependency " + id + " not found when persisting the former, potential race in creation/deletion which may prevent rebind");
                }
            }
            if (!this.isKnownNotManagedActive(bo) || !LOG.isDebugEnabled()) continue;
            LOG.debug("Persistence dependency incomplete with " + memento.getType() + " " + memento.getId() + "; dependency " + id + "(" + bo + ") is being unmanaged; likely the former will be unmanaged and unpersisted shortly but persisting it for now as requested");
        }
    }

    private void persist(String subPath, BrooklynObjectType type, String id, String content, PersistenceExceptionHandler exceptionHandler) {
        try {
            if (content == null) {
                LOG.warn("Null content for " + type + " " + id);
            }
            this.getWriter(this.getPath(subPath, id)).put(content);
        }
        catch (Exception e) {
            exceptionHandler.onPersistRawMementoFailed(type, id, e);
        }
    }

    private void persist(String subPath, BrooklynObjectType type, String id, ByteSource content, PersistenceExceptionHandler exceptionHandler) {
        try {
            this.getWriter(this.getPath(subPath, id)).put(content);
        }
        catch (Exception e) {
            exceptionHandler.onPersistRawMementoFailed(type, id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(String subPath, String id, PersistenceExceptionHandler exceptionHandler) {
        try {
            PersistenceObjectStore.StoreObjectAccessorWithLock w = this.getWriter(this.getPath(subPath, id));
            w.delete();
            Map<String, PersistenceObjectStore.StoreObjectAccessorWithLock> map = this.writers;
            synchronized (map) {
                this.writers.remove(id);
            }
        }
        catch (Exception e) {
            exceptionHandler.onDeleteMementoFailed(id, e);
        }
    }

    private void updatePlaneId(String planeId, PersistenceExceptionHandler exceptionHandler) {
        try {
            if (planeId == null) {
                LOG.debug("Null content for planeId; not updating at server");
                return;
            }
            String persistedPlaneId = this.read(PLANE_ID_FILE_NAME);
            if (persistedPlaneId == null) {
                this.getWriter(PLANE_ID_FILE_NAME).put(planeId);
            } else if (!persistedPlaneId.equals(planeId)) {
                throw new IllegalStateException("Persisted planeId found (" + persistedPlaneId + ") but instance planeId is different (" + planeId + ")");
            }
        }
        catch (Exception e) {
            exceptionHandler.onUpdatePlaneIdFailed(planeId, e);
        }
    }

    private ListenableFuture<?> asyncPersist(final String subPath, final Memento memento, final PersistenceExceptionHandler exceptionHandler) {
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                BrooklynMementoPersisterToObjectStore.this.persist(subPath, memento, exceptionHandler);
            }
        });
    }

    private ListenableFuture<?> asyncPersist(final String subPath, final BrooklynObjectType type, final String id, final String content, final PersistenceExceptionHandler exceptionHandler) {
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                BrooklynMementoPersisterToObjectStore.this.persist(subPath, type, id, content, exceptionHandler);
            }
        });
    }

    private ListenableFuture<?> asyncDelete(final String subPath, final String id, final PersistenceExceptionHandler exceptionHandler) {
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                BrooklynMementoPersisterToObjectStore.this.delete(subPath, id, exceptionHandler);
            }
        });
    }

    private ListenableFuture<?> asyncUpdatePlaneId(final String planeId, final PersistenceExceptionHandler exceptionHandler) {
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                BrooklynMementoPersisterToObjectStore.this.updatePlaneId(planeId, exceptionHandler);
            }
        });
    }

    private String getPath(String subPath, String id) {
        return subPath + "/" + Strings.makeValidFilename((String)id);
    }

    public String getBackingStoreDescription() {
        return this.getObjectStore().getSummaryName();
    }

    protected static interface Visitor {
        public void visit(BrooklynObjectType var1, String var2, String var3) throws Exception;
    }

    private static class XPathHelper {
        private String contents;
        private String prefix;

        public XPathHelper(String contents, String prefix) {
            this.contents = contents;
            this.prefix = prefix;
        }

        private String get(String innerPath) {
            return (String)XmlUtil.xpathHandlingIllegalChars(this.contents, this.prefix + innerPath);
        }

        private List<String> getStringList(String innerPath) {
            MutableList result = MutableList.of();
            NodeList nodeList = (NodeList)XmlUtil.xpathHandlingIllegalChars(this.contents, this.prefix + innerPath + "//string", XPathConstants.NODESET);
            for (int c = 0; c < nodeList.getLength(); ++c) {
                result.add(nodeList.item(c).getFirstChild().getNodeValue());
            }
            return result;
        }
    }
}

