/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.Predicate;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.util.text.Strings;

public class SpecParameterPredicates {
    public static Predicate<SpecParameter<?>> sameName(SpecParameter<?> param) {
        return new SameName(param);
    }

    public static Predicate<SpecParameter<?>> labelEqualTo(String label) {
        return new LabelEqualTo(label);
    }

    public static Predicate<SpecParameter<?>> nameEqualTo(String name) {
        return new NameEqualTo(name);
    }

    protected static class NameEqualTo
    implements Predicate<SpecParameter<?>> {
        private final String name;

        public NameEqualTo(String name) {
            this.name = name;
        }

        public boolean apply(SpecParameter<?> input) {
            return input.getConfigKey().getName().equals(this.name);
        }

        public String toString() {
            return String.format("nameEqualTo(%s)", Strings.toString((Object)this.name));
        }
    }

    protected static class LabelEqualTo
    implements Predicate<SpecParameter<?>> {
        private final String label;

        public LabelEqualTo(String label) {
            this.label = label;
        }

        public boolean apply(SpecParameter<?> input) {
            return input.getLabel().equals(this.label);
        }

        public String toString() {
            return String.format("labelEqualTo(%s)", Strings.toString((Object)this.label));
        }
    }

    protected static class SameName
    implements Predicate<SpecParameter<?>> {
        private final SpecParameter<?> param;

        public SameName(SpecParameter<?> param) {
            this.param = param;
        }

        public boolean apply(SpecParameter<?> input) {
            return input.getConfigKey().getName().equals(this.param.getConfigKey().getName());
        }

        public String toString() {
            return String.format("sameName(%s)", Strings.toString(this.param));
        }
    }
}

