/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.AbstractGroupImpl;
import org.apache.brooklyn.entity.group.QuarantineGroup;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarantineGroupImpl
extends AbstractGroupImpl
implements QuarantineGroup {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntity.class);

    @Override
    protected void initEnrichers() {
    }

    @Override
    public void expungeMembers(boolean stopFirst) {
        ImmutableSet members = ImmutableSet.copyOf(this.getMembers());
        RuntimeException exception = null;
        if (stopFirst) {
            LinkedHashMap tasks = Maps.newLinkedHashMap();
            for (Entity member : members) {
                if (!(member instanceof Startable)) continue;
                Task task = Effectors.invocation(member, Startable.STOP, ImmutableMap.of()).asTask();
                tasks.put(member, task);
            }
            DynamicTasks.queueIfPossible(Tasks.parallel("stopping " + tasks.size() + " member" + Strings.s((int)tasks.size()) + " (parallel)", tasks.values())).orSubmitAsync(this);
            try {
                this.waitForTasksOnExpungeMembers(tasks);
            }
            catch (RuntimeException e) {
                Exceptions.propagateIfFatal((Throwable)e);
                exception = e;
                LOG.warn("Problem stopping members of quarantine group " + this + " (rethrowing after unmanaging members): " + e);
            }
        }
        for (Entity member : members) {
            this.removeMember(member);
            Entities.unmanage(member);
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected Map<Entity, Throwable> waitForTasksOnExpungeMembers(Map<? extends Entity, ? extends Task<?>> tasks) {
        LinkedHashMap errors = Maps.newLinkedHashMap();
        for (Map.Entry<Entity, Task<?>> entry : tasks.entrySet()) {
            Entity member = entry.getKey();
            Task<?> task = entry.getValue();
            try {
                task.get();
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable t) {
                Throwable interesting = Exceptions.getFirstInteresting((Throwable)t);
                LOG.error("Quarantine group " + this + " failed to stop quarantined entity " + member + " (removing): " + interesting, interesting);
                LOG.debug("Trace for: Quarantine group " + this + " failed to stop quarantined entity " + member + " (removing): " + t, t);
                errors.put(member, t);
            }
        }
        return errors;
    }
}

