/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.brooklyn.core.mgmt.persist.DeserializingJcloudsRenamesProvider;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiPredicates;
import org.jclouds.osgi.ApiRegistry;
import org.jclouds.osgi.ProviderRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;
import org.jclouds.providers.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class JcloudsProviderAndApiLoader {
    public static final Logger log = LoggerFactory.getLogger(JcloudsProviderAndApiLoader.class);

    public static boolean isProvider(String id) {
        if (Strings.isBlank((CharSequence)id)) {
            return false;
        }
        return JcloudsProviderAndApiLoader.getProvider(id).isPresent();
    }

    public static boolean isApi(String id) {
        if (Strings.isBlank((CharSequence)id)) {
            return false;
        }
        return JcloudsProviderAndApiLoader.getApi(id).isPresent();
    }

    public static Optional<ProviderMetadata> getProvider(String id) {
        if (LazyServiceLoader.INSTANCE.providers.containsKey(id = DeserializingJcloudsRenamesProvider.INSTANCE.applyJcloudsRenames(id))) {
            return Optional.of((Object)LazyServiceLoader.INSTANCE.providers.get(id));
        }
        return Iterables.tryFind((Iterable)ProviderRegistry.fromRegistry(), (Predicate)ProviderPredicates.id((String)id));
    }

    public static Optional<ApiMetadata> getApi(String id) {
        if (LazyServiceLoader.INSTANCE.apis.containsKey(id = DeserializingJcloudsRenamesProvider.INSTANCE.applyJcloudsRenames(id))) {
            return Optional.of((Object)LazyServiceLoader.INSTANCE.apis.get(id));
        }
        return Iterables.tryFind((Iterable)ApiRegistry.fromRegistry(), (Predicate)ApiPredicates.id((String)id));
    }

    private static enum LazyServiceLoader {
        INSTANCE;

        public final Map<String, ProviderMetadata> providers;
        public final Map<String, ApiMetadata> apis;

        private LazyServiceLoader() {
            LinkedHashMap providersTmp = Maps.newLinkedHashMap();
            for (ProviderMetadata p : Providers.fromServiceLoader()) {
                providersTmp.put(p.getId(), p);
            }
            this.providers = ImmutableMap.copyOf((Map)providersTmp);
            LinkedHashMap apisTmp = Maps.newLinkedHashMap();
            ServiceLoader.load(ApiMetadata.class);
            for (ApiMetadata p : ServiceLoader.load(ApiMetadata.class)) {
                apisTmp.put(p.getId(), p);
            }
            this.apis = ImmutableMap.copyOf((Map)apisTmp);
        }
    }
}

